/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.timer;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.netty.timer.AbstractHashedWheelTimerModule;

public final class HashedWheelTimerModule
extends AbstractHashedWheelTimerModule {
    public HashedWheelTimerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public HashedWheelTimerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, HashedWheelTimerModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getTickDuration() != null) {
            JmxAttributeValidationException.checkCondition((this.getTickDuration() > 0L ? 1 : 0) != 0, (String)"value must be greater than 0", (JmxAttribute)this.tickDurationJmxAttribute);
        }
        if (this.getTicksPerWheel() != null) {
            JmxAttributeValidationException.checkCondition((this.getTicksPerWheel() > 0 ? 1 : 0) != 0, (String)"value must be greater than 0", (JmxAttribute)this.ticksPerWheelJmxAttribute);
        }
    }

    @Override
    public AutoCloseable createInstance() {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        if (this.getTickDuration() != null && this.getThreadFactoryDependency() == null && this.getTicksPerWheel() == null) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(this.getTickDuration().longValue(), unit));
        }
        if (this.getTickDuration() != null && this.getThreadFactoryDependency() == null && this.getTicksPerWheel() != null) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(this.getTickDuration().longValue(), unit, this.getTicksPerWheel().intValue()));
        }
        if (this.getTickDuration() == null && this.getThreadFactoryDependency() != null && this.getTicksPerWheel() == null) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(this.getThreadFactoryDependency()));
        }
        if (this.getTickDuration() != null && this.getThreadFactoryDependency() != null && this.getTicksPerWheel() == null) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(this.getThreadFactoryDependency(), this.getTickDuration().longValue(), unit));
        }
        if (this.getTickDuration() != null && this.getThreadFactoryDependency() != null && this.getTicksPerWheel() != null) {
            return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer(this.getThreadFactoryDependency(), this.getTickDuration().longValue(), unit, this.getTicksPerWheel().intValue()));
        }
        return new HashedWheelTimerCloseable((Timer)new HashedWheelTimer());
    }

    private static final class HashedWheelTimerCloseable
    implements AutoCloseable,
    Timer {
        private final Timer timer;

        public HashedWheelTimerCloseable(Timer timer) {
            this.timer = timer;
        }

        @Override
        public void close() throws Exception {
            this.stop();
        }

        public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
            return this.timer.newTimeout(task, delay, unit);
        }

        public Set<Timeout> stop() {
            return this.timer.stop();
        }
    }
}

