/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.timer;

import java.util.concurrent.ThreadFactory;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.netty.TimerServiceInterface;
import org.opendaylight.controller.config.yang.netty.timer.HashedWheelTimerModuleMXBean;
import org.opendaylight.controller.config.yang.threadpool.ThreadFactoryServiceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHashedWheelTimerModule
implements Module,
HashedWheelTimerModuleMXBean,
TimerServiceInterface {
    protected final JmxAttribute threadFactoryJmxAttribute = new JmxAttribute("ThreadFactory");
    private ObjectName threadFactory;
    protected final JmxAttribute ticksPerWheelJmxAttribute = new JmxAttribute("TicksPerWheel");
    private Integer ticksPerWheel;
    protected final JmxAttribute tickDurationJmxAttribute = new JmxAttribute("TickDuration");
    private Long tickDuration;
    private static final Logger logger = LoggerFactory.getLogger(AbstractHashedWheelTimerModule.class);
    private final AbstractHashedWheelTimerModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private ThreadFactory threadFactoryDependency;

    public AbstractHashedWheelTimerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractHashedWheelTimerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractHashedWheelTimerModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public ObjectName getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    @RequireInterface(value=ThreadFactoryServiceInterface.class)
    public void setThreadFactory(ObjectName threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public Integer getTicksPerWheel() {
        return this.ticksPerWheel;
    }

    @Override
    public void setTicksPerWheel(Integer ticksPerWheel) {
        this.ticksPerWheel = ticksPerWheel;
    }

    @Override
    public Long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public void setTickDuration(Long tickDuration) {
        this.tickDuration = tickDuration;
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final ThreadFactory getThreadFactoryDependency() {
        return this.threadFactoryDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.threadFactory != null) {
                this.threadFactoryDependency = (ThreadFactory)this.dependencyResolver.resolveInstance(ThreadFactory.class, this.threadFactory, this.threadFactoryJmxAttribute);
            }
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractHashedWheelTimerModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractHashedWheelTimerModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.threadFactoryDependency != other.threadFactoryDependency) {
            return false;
        }
        if (this.ticksPerWheel == null ? other.ticksPerWheel != null : !this.ticksPerWheel.equals(other.ticksPerWheel)) {
            return false;
        }
        return !(this.tickDuration == null ? other.tickDuration != null : !this.tickDuration.equals(other.tickDuration));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHashedWheelTimerModule that = (AbstractHashedWheelTimerModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

