/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opendaylight.yangtools.concepts.Delegator;

public class AbstractLockableDelegator<T>
implements Delegator<T> {
    private final ReentrantReadWriteLock delegateLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock delegateReadLock = this.delegateLock.readLock();
    private final ReentrantReadWriteLock.WriteLock delegateWriteLock = this.delegateLock.writeLock();
    private T delegate;

    protected Lock getDelegateReadLock() {
        return this.delegateReadLock;
    }

    public AbstractLockableDelegator() {
    }

    public AbstractLockableDelegator(T initialDelegate) {
        this.delegate = initialDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDelegate() {
        try {
            this.delegateReadLock.lock();
            T t = this.delegate;
            return t;
        }
        finally {
            this.delegateReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T retrieveDelegate() {
        try {
            this.delegateReadLock.lock();
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Delegate is null");
            T t = this.delegate;
            return t;
        }
        finally {
            this.delegateReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T changeDelegate(T newDelegate) {
        try {
            this.delegateWriteLock.lock();
            T oldDelegate = this.delegate;
            this.delegate = newDelegate;
            this.onDelegateChanged(oldDelegate, newDelegate);
            T t = oldDelegate;
            return t;
        }
        finally {
            this.delegateWriteLock.unlock();
        }
    }

    protected void onDelegateChanged(T oldDelegate, T newDelegate) {
    }
}

