/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataBroker;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.common.impl.service.DataChangeEventImpl;
import org.opendaylight.controller.md.sal.common.impl.service.DataChangeListenerRegistration;
import org.opendaylight.controller.md.sal.common.impl.service.ListenerStateCapture;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TwoPhaseCommit<P extends Path<P>, D, DCL extends DataChangeListener<P, D>>
implements Callable<RpcResult<TransactionStatus>> {
    private static final Logger log = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(TwoPhaseCommit.class);
            return _logger;
        }
    }.apply();
    private final AbstractDataTransaction<P, D> transaction;
    private final AbstractDataBroker<P, D, DCL> dataBroker;

    public TwoPhaseCommit(AbstractDataTransaction<P, D> transaction, AbstractDataBroker<P, D, DCL> broker) {
        this.transaction = transaction;
        this.dataBroker = broker;
    }

    @Override
    public RpcResult<TransactionStatus> call() throws Exception {
        ArrayList<RpcResult> _arrayList_1;
        ArrayList<DataCommitHandler.DataCommitTransaction<P, D>> _arrayList;
        HashSet _hashSet;
        HashSet affectedPaths = _hashSet = new HashSet();
        Map _createdConfigurationData = this.transaction.getCreatedConfigurationData();
        Set _keySet = _createdConfigurationData.keySet();
        affectedPaths.addAll(_keySet);
        Map _updatedConfigurationData = this.transaction.getUpdatedConfigurationData();
        Set _keySet_1 = _updatedConfigurationData.keySet();
        affectedPaths.addAll(_keySet_1);
        Set _removedConfigurationData = this.transaction.getRemovedConfigurationData();
        affectedPaths.addAll(_removedConfigurationData);
        Map _createdOperationalData = this.transaction.getCreatedOperationalData();
        Set _keySet_2 = _createdOperationalData.keySet();
        affectedPaths.addAll(_keySet_2);
        Map _updatedOperationalData = this.transaction.getUpdatedOperationalData();
        Set _keySet_3 = _updatedOperationalData.keySet();
        affectedPaths.addAll(_keySet_3);
        Set _removedOperationalData = this.transaction.getRemovedOperationalData();
        affectedPaths.addAll(_removedOperationalData);
        ImmutableList<ListenerStateCapture<P, D, DCL>> listeners = this.dataBroker.affectedListenersWithInitialState(affectedPaths);
        Object transactionId = this.transaction.getIdentifier();
        log.trace("Transaction: {} Started.", transactionId);
        ImmutableList<DataCommitHandler<P, D>> commitHandlers = this.dataBroker.affectedCommitHandlers(affectedPaths);
        ArrayList<DataCommitHandler.DataCommitTransaction<P, D>> handlerTransactions = _arrayList = new ArrayList<DataCommitHandler.DataCommitTransaction<P, D>>();
        try {
            for (DataCommitHandler handler : commitHandlers) {
                DataCommitHandler.DataCommitTransaction _requestCommit = handler.requestCommit(this.transaction);
                handlerTransactions.add(_requestCommit);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                log.error("Transaction: {} Request Commit failed", transactionId, (Object)e);
                AtomicLong _failedTransactionsCount = this.dataBroker.getFailedTransactionsCount();
                _failedTransactionsCount.getAndIncrement();
                return this.rollback(handlerTransactions, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        ArrayList<RpcResult> results = _arrayList_1 = new ArrayList<RpcResult>();
        try {
            for (DataCommitHandler.DataCommitTransaction subtransaction : handlerTransactions) {
                RpcResult _finish = subtransaction.finish();
                results.add(_finish);
            }
            this.publishDataChangeEvent(listeners);
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception e_1 = (Exception)_t_1;
                log.error("Transaction: {} Finish Commit failed", transactionId, (Object)e_1);
                AtomicLong _failedTransactionsCount_1 = this.dataBroker.getFailedTransactionsCount();
                _failedTransactionsCount_1.getAndIncrement();
                return this.rollback(handlerTransactions, e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
        log.trace("Transaction: {} Finished successfully.", transactionId);
        AtomicLong _finishedTransactionsCount = this.dataBroker.getFinishedTransactionsCount();
        _finishedTransactionsCount.getAndIncrement();
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)true, (Object)TransactionStatus.COMMITED, _emptySet);
    }

    public void publishDataChangeEvent(ImmutableList<ListenerStateCapture<P, D, DCL>> listeners) {
        for (ListenerStateCapture listenerSet : listeners) {
            DataChangeEventImpl<P, D> _dataChangeEventImpl;
            Object _path = listenerSet.getPath();
            D updatedConfiguration = this.dataBroker.readConfigurationData(_path);
            Object _path_1 = listenerSet.getPath();
            D updatedOperational = this.dataBroker.readOperationalData(_path_1);
            Object _initialConfigurationState = listenerSet.getInitialConfigurationState();
            Object _initialOperationalState = listenerSet.getInitialOperationalState();
            DataChangeEventImpl<P, D> changeEvent = _dataChangeEventImpl = new DataChangeEventImpl<P, D>(this.transaction, _initialConfigurationState, _initialOperationalState, updatedOperational, updatedConfiguration);
            Collection _listeners = listenerSet.getListeners();
            for (DataChangeListenerRegistration listener : _listeners) {
                try {
                    DataChangeListener _instance = (DataChangeListener)listener.getInstance();
                    _instance.onDataChanged(changeEvent);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        e.printStackTrace();
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    public RpcResult<TransactionStatus> rollback(List<DataCommitHandler.DataCommitTransaction<P, D>> transactions, Exception e) {
        for (DataCommitHandler.DataCommitTransaction<P, D> transaction : transactions) {
            transaction.rollback();
        }
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)false, (Object)TransactionStatus.FAILED, _emptySet);
    }
}

