/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.impl.AbstractDataModification;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataBroker;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataTransaction<P extends Path<P>, D>
extends AbstractDataModification<P, D> {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(AbstractDataTransaction.class);
            return _logger;
        }
    }.apply();
    private final Object _identifier;
    private TransactionStatus status;
    private AbstractDataBroker<P, D, ? extends Object> broker;

    public Object getIdentifier() {
        return this._identifier;
    }

    protected AbstractDataTransaction(Object identifier, AbstractDataBroker<P, D, ? extends Object> dataBroker) {
        super(dataBroker);
        this._identifier = identifier;
        this.broker = dataBroker;
        this.status = TransactionStatus.NEW;
        LOG.debug("Transaction {} Allocated.", identifier);
    }

    public Future<RpcResult<TransactionStatus>> commit() {
        return this.broker.commit(this);
    }

    @Override
    public D readConfigurationData(P path) {
        boolean _notEquals;
        Map _updatedConfigurationData = this.getUpdatedConfigurationData();
        Object local = _updatedConfigurationData.get(path);
        boolean bl = _notEquals = !Objects.equal(local, null);
        if (_notEquals) {
            return local;
        }
        return this.broker.readConfigurationData(path);
    }

    @Override
    public D readOperationalData(P path) {
        boolean _notEquals;
        Map _updatedOperationalData = this.getUpdatedOperationalData();
        Object local = _updatedOperationalData.get(path);
        boolean bl = _notEquals = !Objects.equal(local, null);
        if (_notEquals) {
            return local;
        }
        return this.broker.readOperationalData(path);
    }

    public int hashCode() {
        Object _identifier = this.getIdentifier();
        return _identifier.hashCode();
    }

    public boolean equals(Object obj) {
        Object _identifier;
        boolean _equals_3;
        Class<?> _class_1;
        boolean _notEquals;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = this == obj;
        if (_tripleEquals) {
            return true;
        }
        boolean _equals = Objects.equal((Object)obj, null);
        if (_equals) {
            return false;
        }
        Class<?> _class = this.getClass();
        boolean bl2 = _notEquals = !Objects.equal(_class, _class_1 = obj.getClass());
        if (_notEquals) {
            return false;
        }
        AbstractDataTransaction other = (AbstractDataTransaction)obj;
        boolean _equals_1 = Objects.equal(this.broker, null);
        if (_equals_1) {
            boolean _notEquals_1;
            boolean bl3 = _notEquals_1 = !Objects.equal(other.broker, null);
            if (_notEquals_1) {
                return false;
            }
        } else {
            boolean _not;
            boolean _equals_2 = this.broker.equals(other.broker);
            boolean bl4 = _not = !_equals_2;
            if (_not) {
                return false;
            }
        }
        if (_equals_3 = Objects.equal((Object)(_identifier = this.getIdentifier()), null)) {
            boolean _notEquals_2;
            Object _identifier_1 = other.getIdentifier();
            boolean bl5 = _notEquals_2 = !Objects.equal((Object)_identifier_1, null);
            if (_notEquals_2) {
                return false;
            }
        } else {
            boolean _not_1;
            Object _identifier_3;
            Object _identifier_2 = this.getIdentifier();
            boolean _equals_4 = _identifier_2.equals(_identifier_3 = other.getIdentifier());
            boolean bl6 = _not_1 = !_equals_4;
            if (_not_1) {
                return false;
            }
        }
        return true;
    }

    public TransactionStatus getStatus() {
        return this.status;
    }

    protected abstract void onStatusChange(TransactionStatus var1);

    public void changeStatus(TransactionStatus status) {
        Object _identifier = this.getIdentifier();
        LOG.debug("Transaction {} transitioned from {} to {}", new Object[]{_identifier, this.status, status});
        this.status = status;
        this.onStatusChange(status);
    }
}

