/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.sal.common.api.RegistrationListener;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.DataChangePublisher;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandlerRegistration;
import org.opendaylight.controller.md.sal.common.api.data.DataModificationTransactionFactory;
import org.opendaylight.controller.md.sal.common.api.data.DataProvisionService;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.md.sal.common.impl.routing.AbstractDataReadRouter;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.common.impl.service.DataChangeListenerRegistration;
import org.opendaylight.controller.md.sal.common.impl.service.DataCommitHandlerRegistrationImpl;
import org.opendaylight.controller.md.sal.common.impl.service.InitialDataChangeEventImpl;
import org.opendaylight.controller.md.sal.common.impl.service.ListenerStateCapture;
import org.opendaylight.controller.md.sal.common.impl.service.TwoPhaseCommit;
import org.opendaylight.yangtools.concepts.CompositeObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataBroker<P extends Path<P>, D, DCL extends DataChangeListener<P, D>>
implements DataModificationTransactionFactory<P, D>,
DataReader<P, D>,
DataChangePublisher<P, D, DCL>,
DataProvisionService<P, D> {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(AbstractDataBroker.class);
            return _logger;
        }
    }.apply();
    private ExecutorService _executor;
    private AbstractDataReadRouter<P, D> _dataReadRouter;
    private final AtomicLong _submittedTransactionsCount = new Functions.Function0<AtomicLong>(){

        public AtomicLong apply() {
            AtomicLong _atomicLong = new AtomicLong();
            return _atomicLong;
        }
    }.apply();
    private final AtomicLong _failedTransactionsCount = new Functions.Function0<AtomicLong>(){

        public AtomicLong apply() {
            AtomicLong _atomicLong = new AtomicLong();
            return _atomicLong;
        }
    }.apply();
    private final AtomicLong _finishedTransactionsCount = new Functions.Function0<AtomicLong>(){

        public AtomicLong apply() {
            AtomicLong _atomicLong = new AtomicLong();
            return _atomicLong;
        }
    }.apply();
    private Multimap<P, DataChangeListenerRegistration<P, D, DCL>> listeners = new Functions.Function0<Multimap<P, DataChangeListenerRegistration<P, D, DCL>>>(){

        public Multimap<P, DataChangeListenerRegistration<P, D, DCL>> apply() {
            HashMultimap _create = HashMultimap.create();
            SetMultimap _synchronizedSetMultimap = Multimaps.synchronizedSetMultimap((SetMultimap)_create);
            return _synchronizedSetMultimap;
        }
    }.apply();
    private Multimap<P, DataCommitHandlerRegistrationImpl<P, D>> commitHandlers = new Functions.Function0<Multimap<P, DataCommitHandlerRegistrationImpl<P, D>>>(){

        public Multimap<P, DataCommitHandlerRegistrationImpl<P, D>> apply() {
            HashMultimap _create = HashMultimap.create();
            SetMultimap _synchronizedSetMultimap = Multimaps.synchronizedSetMultimap((SetMultimap)_create);
            return _synchronizedSetMultimap;
        }
    }.apply();
    private final ListenerRegistry<RegistrationListener<DataCommitHandlerRegistration<P, D>>> commitHandlerRegistrationListeners = new Functions.Function0<ListenerRegistry<RegistrationListener<DataCommitHandlerRegistration<P, D>>>>(){

        public ListenerRegistry<RegistrationListener<DataCommitHandlerRegistration<P, D>>> apply() {
            ListenerRegistry _listenerRegistry = new ListenerRegistry();
            return _listenerRegistry;
        }
    }.apply();

    public ExecutorService getExecutor() {
        return this._executor;
    }

    public void setExecutor(ExecutorService executor) {
        this._executor = executor;
    }

    public AbstractDataReadRouter<P, D> getDataReadRouter() {
        return this._dataReadRouter;
    }

    public void setDataReadRouter(AbstractDataReadRouter<P, D> dataReadRouter) {
        this._dataReadRouter = dataReadRouter;
    }

    public AtomicLong getSubmittedTransactionsCount() {
        return this._submittedTransactionsCount;
    }

    public AtomicLong getFailedTransactionsCount() {
        return this._failedTransactionsCount;
    }

    public AtomicLong getFinishedTransactionsCount() {
        return this._finishedTransactionsCount;
    }

    protected ImmutableList<DataCommitHandler<P, D>> affectedCommitHandlers(final HashSet<P> paths) {
        Map _asMap = this.commitHandlers.asMap();
        Set _entrySet = _asMap.entrySet();
        FluentIterable _from = FluentIterable.from(_entrySet);
        Predicate _function = new Predicate<Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>>>(){

            public boolean apply(Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>> it) {
                Path _key = (Path)it.getKey();
                boolean _isAffectedBy = AbstractDataBroker.this.isAffectedBy(_key, paths);
                return _isAffectedBy;
            }
        };
        FluentIterable _filter = _from.filter(_function);
        Function _function_1 = new Function<Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>>, Collection<DataCommitHandlerRegistrationImpl<P, D>>>(){

            public Collection<DataCommitHandlerRegistrationImpl<P, D>> apply(Map.Entry<P, Collection<DataCommitHandlerRegistrationImpl<P, D>>> it) {
                Collection _value = it.getValue();
                return _value;
            }
        };
        FluentIterable _transformAndConcat = _filter.transformAndConcat(_function_1);
        Function _function_2 = new Function<DataCommitHandlerRegistrationImpl<P, D>, DataCommitHandler<P, D>>(){

            public DataCommitHandler<P, D> apply(DataCommitHandlerRegistrationImpl<P, D> it) {
                DataCommitHandler _instance = (DataCommitHandler)it.getInstance();
                return _instance;
            }
        };
        FluentIterable _transform = _transformAndConcat.transform(_function_2);
        return _transform.toList();
    }

    public final D readConfigurationData(P path) {
        AbstractDataReadRouter<P, D> _dataReadRouter = this.getDataReadRouter();
        return _dataReadRouter.readConfigurationData(path);
    }

    public final D readOperationalData(P path) {
        AbstractDataReadRouter<P, D> _dataReadRouter = this.getDataReadRouter();
        return _dataReadRouter.readOperationalData(path);
    }

    public final Registration<DataCommitHandler<P, D>> registerCommitHandler(P path, DataCommitHandler<P, D> commitHandler) {
        DataCommitHandlerRegistrationImpl<P, D> _dataCommitHandlerRegistrationImpl;
        DataCommitHandlerRegistrationImpl<P, D> registration = _dataCommitHandlerRegistrationImpl = new DataCommitHandlerRegistrationImpl<P, D>(path, commitHandler, this);
        this.commitHandlers.put(path, registration);
        LOG.trace("Registering Commit Handler {} for path: {}", commitHandler, path);
        for (ListenerRegistration listener : this.commitHandlerRegistrationListeners) {
            try {
                RegistrationListener _instance = (RegistrationListener)listener.getInstance();
                _instance.onRegister(registration);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    RegistrationListener _instance_1 = (RegistrationListener)listener.getInstance();
                    LOG.error("Unexpected exception in listener {} during invoking onRegister", (Object)_instance_1, (Object)e);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return registration;
    }

    public final ListenerRegistration<DCL> registerDataChangeListener(P path, DCL listener) {
        DataChangeListenerRegistration _dataChangeListenerRegistration;
        DataChangeListenerRegistration reg = _dataChangeListenerRegistration = new DataChangeListenerRegistration(path, listener, this);
        this.listeners.put(path, reg);
        AbstractDataReadRouter<P, D> _dataReadRouter = this.getDataReadRouter();
        D initialConfig = _dataReadRouter.readConfigurationData(path);
        AbstractDataReadRouter<P, D> _dataReadRouter_1 = this.getDataReadRouter();
        D initialOperational = _dataReadRouter_1.readOperationalData(path);
        DataChangeEvent<P, D> event = this.createInitialListenerEvent(path, initialConfig, initialOperational);
        listener.onDataChanged(event);
        return reg;
    }

    public final CompositeObjectRegistration<DataReader<P, D>> registerDataReader(P path, DataReader<P, D> reader) {
        AbstractDataReadRouter<P, D> _dataReadRouter = this.getDataReadRouter();
        Registration<DataReader<P, D>> confReg = _dataReadRouter.registerConfigurationReader(path, reader);
        AbstractDataReadRouter<P, D> _dataReadRouter_1 = this.getDataReadRouter();
        Registration<DataReader<P, D>> dataReg = _dataReadRouter_1.registerOperationalReader(path, reader);
        List<Registration> _asList = Arrays.asList(confReg, dataReg);
        CompositeObjectRegistration _compositeObjectRegistration = new CompositeObjectRegistration(reader, _asList);
        return _compositeObjectRegistration;
    }

    public ListenerRegistration<RegistrationListener<DataCommitHandlerRegistration<P, D>>> registerCommitHandlerListener(RegistrationListener<DataCommitHandlerRegistration<P, D>> commitHandlerListener) {
        ListenerRegistration ret = this.commitHandlerRegistrationListeners.register(commitHandlerListener);
        return ret;
    }

    protected DataChangeEvent<P, D> createInitialListenerEvent(P path, D initialConfig, D initialOperational) {
        InitialDataChangeEventImpl _initialDataChangeEventImpl = new InitialDataChangeEventImpl(initialConfig, initialOperational);
        return _initialDataChangeEventImpl;
    }

    protected final boolean removeListener(DataChangeListenerRegistration<P, D, DCL> registration) {
        P _path = registration.getPath();
        boolean _remove = this.listeners.remove(_path, registration);
        return _remove;
    }

    protected final void removeCommitHandler(DataCommitHandlerRegistrationImpl<P, D> registration) {
        P _path = registration.getPath();
        this.commitHandlers.remove(_path, registration);
        DataCommitHandler _instance = (DataCommitHandler)registration.getInstance();
        P _path_1 = registration.getPath();
        LOG.trace("Removing Commit Handler {} for path: {}", (Object)_instance, _path_1);
        for (ListenerRegistration listener : this.commitHandlerRegistrationListeners) {
            try {
                RegistrationListener _instance_1 = (RegistrationListener)listener.getInstance();
                _instance_1.onUnregister(registration);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    RegistrationListener _instance_2 = (RegistrationListener)listener.getInstance();
                    LOG.error("Unexpected exception in listener {} during invoking onUnregister", (Object)_instance_2, (Object)e);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    protected final Collection<Map.Entry<P, DataCommitHandlerRegistrationImpl<P, D>>> getActiveCommitHandlers() {
        return this.commitHandlers.entries();
    }

    protected ImmutableList<ListenerStateCapture<P, D, DCL>> affectedListenersWithInitialState(final HashSet<P> paths) {
        Map _asMap = this.listeners.asMap();
        Set _entrySet = _asMap.entrySet();
        FluentIterable _from = FluentIterable.from(_entrySet);
        Predicate _function = new Predicate<Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>>>(){

            public boolean apply(Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>> it) {
                Path _key = (Path)it.getKey();
                boolean _isAffectedBy = AbstractDataBroker.this.isAffectedBy(_key, paths);
                return _isAffectedBy;
            }
        };
        FluentIterable _filter = _from.filter(_function);
        Function _function_1 = new Function<Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>>, ListenerStateCapture<P, D, DCL>>(){

            public ListenerStateCapture<P, D, DCL> apply(Map.Entry<P, Collection<DataChangeListenerRegistration<P, D, DCL>>> it) {
                Path _key = (Path)it.getKey();
                Object operationalState = AbstractDataBroker.this.readOperationalData(_key);
                Path _key_1 = (Path)it.getKey();
                Object configurationState = AbstractDataBroker.this.readConfigurationData(_key_1);
                Path _key_2 = (Path)it.getKey();
                Collection _value = it.getValue();
                ListenerStateCapture _listenerStateCapture = new ListenerStateCapture(_key_2, _value, operationalState, configurationState);
                return _listenerStateCapture;
            }
        };
        FluentIterable _transform = _filter.transform(_function_1);
        return _transform.toList();
    }

    protected boolean isAffectedBy(P key, Set<P> paths) {
        boolean _contains = paths.contains(key);
        if (_contains) {
            return true;
        }
        for (Path path : paths) {
            boolean _contains_1 = key.contains(path);
            if (!_contains_1) continue;
            return true;
        }
        return false;
    }

    final Future<RpcResult<TransactionStatus>> commit(AbstractDataTransaction<P, D> transaction) {
        TwoPhaseCommit _twoPhaseCommit;
        Preconditions.checkNotNull(transaction);
        transaction.changeStatus(TransactionStatus.SUBMITED);
        TwoPhaseCommit task = _twoPhaseCommit = new TwoPhaseCommit(transaction, this);
        AtomicLong _submittedTransactionsCount = this.getSubmittedTransactionsCount();
        _submittedTransactionsCount.getAndIncrement();
        ExecutorService _executor = this.getExecutor();
        return _executor.submit(task);
    }
}

