/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.routing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChange;

public class RoutingUtils {
    public static <C, P> RouteChange<C, P> removalChange(C context, P path) {
        ImmutableMap announcements = ImmutableMap.of();
        ImmutableMap removals = ImmutableMap.of(context, (Object)ImmutableSet.of(path));
        return new RouteChangeImpl(announcements, removals);
    }

    public static <C, P> RouteChange<C, P> announcementChange(C context, P path) {
        ImmutableMap announcements = ImmutableMap.of(context, (Object)ImmutableSet.of(path));
        ImmutableMap removals = ImmutableMap.of();
        return new RouteChangeImpl(announcements, removals);
    }

    public static <C, P> RouteChange<C, P> change(Map<C, Set<P>> announcements, Map<C, Set<P>> removals) {
        ImmutableMap immutableAnnouncements = ImmutableMap.copyOf(announcements);
        ImmutableMap immutableRemovals = ImmutableMap.copyOf(removals);
        return new RouteChangeImpl(immutableAnnouncements, immutableRemovals);
    }

    private static class RouteChangeImpl<C, P>
    implements RouteChange<C, P> {
        private final Map<C, Set<P>> removal;
        private final Map<C, Set<P>> announcement;

        public RouteChangeImpl(ImmutableMap<C, Set<P>> removal, ImmutableMap<C, Set<P>> announcement) {
            this.removal = removal;
            this.announcement = announcement;
        }

        public Map<C, Set<P>> getAnnouncements() {
            return this.announcement;
        }

        public Map<C, Set<P>> getRemovals() {
            return this.removal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.announcement == null ? 0 : this.announcement.hashCode());
            result = 31 * result + (this.removal == null ? 0 : this.removal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RouteChangeImpl other = (RouteChangeImpl)obj;
            if (this.announcement == null ? other.announcement != null : !this.announcement.equals(other.announcement)) {
                return false;
            }
            return !(this.removal == null ? other.removal != null : !this.removal.equals(other.removal));
        }
    }
}

