/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.routing;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;

public abstract class AbstractDataReadRouter<P extends Path<P>, D>
implements DataReader<P, D> {
    Multimap<P, DataReaderRegistration<P, D>> configReaders = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    Multimap<P, DataReaderRegistration<P, D>> operationalReaders = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public D readConfigurationData(P path) {
        FluentIterable dataBits = FluentIterable.from(this.getReaders(this.configReaders, path)).transform(this.configurationRead(path));
        return this.merge(path, (Iterable<D>)dataBits);
    }

    public D readOperationalData(P path) {
        FluentIterable dataBits = FluentIterable.from(this.getReaders(this.operationalReaders, path)).transform(this.operationalRead(path));
        return this.merge(path, (Iterable<D>)dataBits);
    }

    protected abstract D merge(P var1, Iterable<D> var2);

    private Function<DataReader<P, D>, D> configurationRead(P path) {
        return new Function<DataReader<P, D>, D>((Path)path){
            final /* synthetic */ Path val$path;
            {
                this.val$path = path;
            }

            public D apply(DataReader<P, D> input) {
                return input.readConfigurationData((Object)this.val$path);
            }
        };
    }

    private Function<DataReader<P, D>, D> operationalRead(P path) {
        return new Function<DataReader<P, D>, D>((Path)path){
            final /* synthetic */ Path val$path;
            {
                this.val$path = path;
            }

            public D apply(DataReader<P, D> input) {
                return input.readOperationalData((Object)this.val$path);
            }
        };
    }

    public Registration<DataReader<P, D>> registerOperationalReader(P path, DataReader<P, D> reader) {
        OperationalDataReaderRegistration ret = new OperationalDataReaderRegistration(this, path, reader);
        this.operationalReaders.put(path, (Object)ret);
        return ret;
    }

    public Registration<DataReader<P, D>> registerConfigurationReader(P path, DataReader<P, D> reader) {
        ConfigurationDataReaderRegistration ret = new ConfigurationDataReaderRegistration(this, path, reader);
        this.configReaders.put(path, (Object)ret);
        return ret;
    }

    Iterable<DataReader<P, D>> getOperationalReaders(P path) {
        return this.getReaders(this.operationalReaders, path);
    }

    Iterable<DataReader<P, D>> getConfigurationReaders(P path) {
        return this.getReaders(this.configReaders, path);
    }

    private Iterable<DataReader<P, D>> getReaders(Multimap<P, DataReaderRegistration<P, D>> readerMap, P path) {
        return FluentIterable.from((Iterable)readerMap.entries()).filter(this.affects(path)).transform(this.retrieveInstance());
    }

    private void removeRegistration(OperationalDataReaderRegistration<?, ?> registration) {
        this.operationalReaders.remove(registration.getKey(), registration);
    }

    private void removeRegistration(ConfigurationDataReaderRegistration<?, ?> registration) {
        this.configReaders.remove(registration.getKey(), registration);
    }

    private Function<? super Map.Entry<P, DataReaderRegistration<P, D>>, DataReader<P, D>> retrieveInstance() {
        return new Function<Map.Entry<P, DataReaderRegistration<P, D>>, DataReader<P, D>>(){

            public DataReader<P, D> apply(Map.Entry<P, DataReaderRegistration<P, D>> input) {
                return (DataReader)input.getValue().getInstance();
            }
        };
    }

    private Predicate<? super Map.Entry<P, DataReaderRegistration<P, D>>> affects(P path) {
        return new Predicate<Map.Entry<P, DataReaderRegistration<P, D>>>((Path)path){
            final /* synthetic */ Path val$path;
            {
                this.val$path = path;
            }

            public boolean apply(Map.Entry<P, DataReaderRegistration<P, D>> input) {
                Path key = (Path)input.getKey();
                return key.contains(this.val$path) || this.val$path.contains(key);
            }
        };
    }

    private static abstract class DataReaderRegistration<P extends Path<P>, D>
    extends AbstractObjectRegistration<DataReader<P, D>> {
        private final P key;

        public P getKey() {
            return this.key;
        }

        public DataReaderRegistration(P key, DataReader<P, D> instance) {
            super(instance);
            this.key = key;
        }
    }

    private static class OperationalDataReaderRegistration<P extends Path<P>, D>
    extends DataReaderRegistration<P, D> {
        final /* synthetic */ AbstractDataReadRouter this$0;

        public OperationalDataReaderRegistration(P key, DataReader<P, D> instance) {
            this.this$0 = var1_1;
            super(key, instance);
        }

        protected void removeRegistration() {
            this.this$0.removeRegistration(this);
        }
    }

    private static class ConfigurationDataReaderRegistration<P extends Path<P>, D>
    extends DataReaderRegistration<P, D> {
        final /* synthetic */ AbstractDataReadRouter this$0;

        public ConfigurationDataReaderRegistration(P key, DataReader<P, D> instance) {
            this.this$0 = var1_1;
            super(key, instance);
        }

        protected void removeRegistration() {
            this.this$0.removeRegistration(this);
        }
    }
}

