/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.concepts.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;

public class BindingReflections {
    private static final long EXPIRATION_TIME = 60L;
    private static final String ROOT_PACKAGE_PATTERN_STRING = "(org.opendaylight.yang.gen.v1.[a-z0-9\\.]*.rev[0-9][0-9][0-1][0-9][0-3][0-9])";
    private static final Pattern ROOT_PACKAGE_PATTERN = Pattern.compile("(org.opendaylight.yang.gen.v1.[a-z0-9\\.]*.rev[0-9][0-9][0-1][0-9][0-3][0-9])");
    private static final LoadingCache<Class<?>, Optional<QName>> classToQName = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new ClassToQNameLoader());

    public static Class<? extends Augmentable<?>> findAugmentationTarget(Class<? extends Augmentation<?>> augmentation) {
        return ClassLoaderUtils.findFirstGenericArgument(augmentation, Augmentation.class);
    }

    public static Class<?> findHierarchicalParent(Class<? extends ChildOf<?>> childClass) {
        return ClassLoaderUtils.findFirstGenericArgument(childClass, ChildOf.class);
    }

    public static Class<?> findHierarchicalParent(DataObject childClass) {
        if (childClass instanceof ChildOf) {
            return ClassLoaderUtils.findFirstGenericArgument(childClass.getImplementedInterface(), ChildOf.class);
        }
        return null;
    }

    public static final QName findQName(Class<?> dataType) {
        return (QName)((Optional)classToQName.getUnchecked(dataType)).orNull();
    }

    public static boolean isRpcMethod(Method possibleMethod) {
        return possibleMethod != null && RpcService.class.isAssignableFrom(possibleMethod.getDeclaringClass()) && Future.class.isAssignableFrom(possibleMethod.getReturnType()) && possibleMethod.getParameterTypes().length <= 1;
    }

    public static Optional<Class<?>> resolveRpcOutputClass(Method targetMethod) {
        Preconditions.checkState((boolean)BindingReflections.isRpcMethod(targetMethod), (Object)"Supplied method is not Rpc invocation method");
        Type futureType = targetMethod.getGenericReturnType();
        Type rpcResultType = ClassLoaderUtils.getFirstGenericParameter((Type)futureType);
        Type rpcResultArgument = ClassLoaderUtils.getFirstGenericParameter((Type)rpcResultType);
        if (rpcResultArgument instanceof Class && !Void.class.equals((Object)rpcResultArgument)) {
            return Optional.of((Object)((Class)rpcResultArgument));
        }
        return Optional.absent();
    }

    public static Optional<Class<? extends DataContainer>> resolveRpcInputClass(Method targetMethod) {
        Class<?>[] types = targetMethod.getParameterTypes();
        if (types.length == 0) {
            return Optional.absent();
        }
        if (types.length == 1) {
            return Optional.of(types[0]);
        }
        throw new IllegalArgumentException("Method has 2 or more arguments.");
    }

    public static QName getQName(Class<? extends BaseIdentity> context) {
        return BindingReflections.findQName(context);
    }

    public static boolean isAugmentationChild(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0);
        Class<?> parent = BindingReflections.findHierarchicalParent(clazz);
        String clazzModelPackage = BindingReflections.getModelRootPackageName(clazz.getPackage());
        String parentModelPackage = BindingReflections.getModelRootPackageName(parent.getPackage());
        return !clazzModelPackage.equals(parentModelPackage);
    }

    public static String getModelRootPackageName(Package pkg) {
        return BindingReflections.getModelRootPackageName(pkg.getName());
    }

    public static String getModelRootPackageName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Package name should not be null.");
        Preconditions.checkArgument((boolean)name.startsWith("org.opendaylight.yang.gen.v1"));
        Matcher match = ROOT_PACKAGE_PATTERN.matcher(name);
        Preconditions.checkArgument((boolean)match.find());
        String rootPackage = match.group(0);
        return rootPackage;
    }

    private static class ClassToQNameLoader
    extends CacheLoader<Class<?>, Optional<QName>> {
        private ClassToQNameLoader() {
        }

        public Optional<QName> load(Class<?> key) throws Exception {
            try {
                Field field = key.getField("QNAME");
                Object obj = field.get(null);
                if (obj instanceof QName) {
                    return Optional.of((Object)((QName)obj));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
            return Optional.absent();
        }
    }
}

