/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;

public final class InstanceIdentifier<T extends DataObject>
implements Path<InstanceIdentifier<? extends DataObject>>,
Immutable {
    private final List<PathArgument> path;
    private final Class<T> targetType;

    public InstanceIdentifier(Class<T> type) {
        this.path = Collections.singletonList(new Item<T>(type));
        this.targetType = type;
    }

    public InstanceIdentifier(List<PathArgument> path, Class<T> type) {
        this.path = ImmutableList.copyOf(path);
        this.targetType = type;
    }

    public List<PathArgument> getPath() {
        return this.getPathArguments();
    }

    public List<PathArgument> getPathArguments() {
        return this.path;
    }

    public Class<T> getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return "InstanceIdentifier [path=" + this.path + "]";
    }

    public <T extends DataObject> InstanceIdentifier<T> firstIdentifierOf(Class<T> type) {
        int i = 1;
        for (PathArgument a : this.path) {
            if (type.equals(a.getType())) {
                return new InstanceIdentifier<T>(this.path.subList(0, i), type);
            }
            ++i;
        }
        return null;
    }

    public <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K firstKeyOf(Class<N> listItem, Class<K> listKey) {
        for (PathArgument i : this.path) {
            if (!listItem.equals(i.getType())) continue;
            Object ret = ((IdentifiableItem)i).getKey();
            return (K)ret;
        }
        return null;
    }

    public static <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K keyOf(InstanceIdentifier<N> id) {
        Object ret = ((IdentifiableItem)Iterables.getLast(id.getPath())).getKey();
        return (K)ret;
    }

    @Deprecated
    public static InstanceIdentifierBuilder<?> builder() {
        return new BuilderImpl();
    }

    public static <T extends ChildOf<? extends DataRoot>> InstanceIdentifierBuilder<T> builder(Class<T> container) {
        return new BuilderImpl().addNode(container);
    }

    public static <N extends Identifiable<K> & ChildOf<? extends DataRoot>, K extends Identifier<N>> InstanceIdentifierBuilder<N> builder(Class<N> listItem, K listKey) {
        return new BuilderImpl().addNode(listItem, listKey);
    }

    public static <T extends DataObject> InstanceIdentifierBuilder<T> builder(InstanceIdentifier<T> basePath) {
        return new BuilderImpl(basePath.path, basePath.targetType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public boolean contains(InstanceIdentifier<?> other) {
        if (other == null) {
            throw new IllegalArgumentException("other should not be null");
        }
        int localSize = this.path.size();
        List<PathArgument> otherPath = other.getPath();
        if (localSize > other.path.size()) {
            return false;
        }
        for (int i = 0; i < localSize; ++i) {
            if (this.path.get(i).equals(otherPath.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsWildcarded(InstanceIdentifier<?> other) {
        if (other == null) {
            throw new IllegalArgumentException("other should not be null");
        }
        int localSize = this.path.size();
        List<PathArgument> otherPath = other.getPath();
        if (localSize > other.path.size()) {
            return false;
        }
        for (int i = 0; i < localSize; ++i) {
            PathArgument localArgument = this.path.get(i);
            if (!localArgument.getType().equals(otherPath.get(i).getType())) {
                return false;
            }
            if (!(localArgument instanceof IdentifiableItem) || localArgument.equals(otherPath.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isWildcarded() {
        for (PathArgument pathArgument : this.path) {
            if (!Identifiable.class.isAssignableFrom(pathArgument.getType()) || pathArgument instanceof IdentifiableItem) continue;
            return true;
        }
        return false;
    }

    private static final class BuilderImpl<T extends DataObject>
    implements InstanceIdentifierBuilder<T> {
        private List<PathArgument> path;
        private Class<? extends DataObject> target = null;

        public BuilderImpl() {
            this.path = new ArrayList<PathArgument>();
        }

        public BuilderImpl(List<? extends PathArgument> prefix, Class<? extends DataObject> target) {
            this.path = new ArrayList<PathArgument>(prefix);
            this.target = target;
        }

        private <N extends DataObject> InstanceIdentifierBuilder<N> addNode(Class<N> container) {
            this.target = container;
            this.path.add(new Item<N>(container));
            return this;
        }

        private <N extends DataObject & Identifiable<K>, K extends Identifier<N>> InstanceIdentifierBuilder<N> addNode(Class<N> listItem, K listKey) {
            this.target = listItem;
            this.path.add(new IdentifiableItem<N, K>(listItem, listKey));
            return this;
        }

        public InstanceIdentifier<T> toInstance() {
            List<PathArgument> immutablePath = Collections.unmodifiableList(new ArrayList<PathArgument>(this.path));
            return new InstanceIdentifier<DataObject>(immutablePath, this.target);
        }

        @Override
        public InstanceIdentifier<T> build() {
            return this.toInstance();
        }

        @Override
        public <N extends DataObject> InstanceIdentifierBuilder<N> node(Class<N> container) {
            return this.addNode(container);
        }

        @Override
        public <N extends DataObject & Identifiable<K>, K extends Identifier<N>> InstanceIdentifierBuilder<N> node(Class<N> listItem, K listKey) {
            return this.addNode(listItem, listKey);
        }

        @Override
        public <N extends ChildOf<? super T>> InstanceIdentifierBuilder<N> child(Class<N> container) {
            return this.addNode(container);
        }

        @Override
        public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> InstanceIdentifierBuilder<N> child(Class<N> listItem, K listKey) {
            return this.addNode(listItem, listKey);
        }

        @Override
        public <N extends DataObject & Augmentation<? super T>> InstanceIdentifierBuilder<N> augmentation(Class<N> container) {
            return this.addNode(container);
        }
    }

    public static interface InstanceIdentifierBuilder<T extends DataObject>
    extends Builder<InstanceIdentifier<T>> {
        @Deprecated
        public <N extends DataObject> InstanceIdentifierBuilder<N> node(Class<N> var1);

        @Deprecated
        public <N extends Identifiable<K> & DataObject, K extends Identifier<N>> InstanceIdentifierBuilder<N> node(Class<N> var1, K var2);

        public <N extends ChildOf<? super T>> InstanceIdentifierBuilder<N> child(Class<N> var1);

        public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> InstanceIdentifierBuilder<N> child(Class<N> var1, K var2);

        public <N extends DataObject & Augmentation<? super T>> InstanceIdentifierBuilder<N> augmentation(Class<N> var1);

        public InstanceIdentifier<T> build();
    }

    public static final class IdentifiableItem<I extends Identifiable<T> & DataObject, T extends Identifier<I>>
    implements PathArgument {
        private final T key;
        private final Class<I> type;

        public IdentifiableItem(Class<I> type, T key) {
            if (type == null) {
                throw new IllegalArgumentException("Type must not be null.");
            }
            if (key == null) {
                throw new IllegalArgumentException("Key must not be null.");
            }
            this.type = type;
            this.key = key;
        }

        public T getKey() {
            return this.key;
        }

        public Class<I> getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.hashCode() != this.hashCode()) {
                return false;
            }
            if (!(obj instanceof IdentifiableItem)) {
                return false;
            }
            IdentifiableItem foreign = (IdentifiableItem)obj;
            return this.key.equals(foreign.getKey());
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.type.getName() + "[key=" + this.key + "]";
        }
    }

    public static final class Item<T extends DataObject>
    implements PathArgument {
        private final Class<T> type;

        public Item(Class<T> type) {
            this.type = type;
        }

        public Class<T> getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return this.type.getName();
        }
    }

    public static interface PathArgument {
        public Class<? extends DataObject> getType();
    }
}

