/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;

public final class BindingMapping {
    public static final String VERSION = "0.6";
    public static final Set<String> JAVA_RESERVED_WORDS = ImmutableSet.of((Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"break", (Object)"byte", (Object)"case", (Object[])new String[]{"catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"});
    public static final String DATA_ROOT_SUFFIX = "Data";
    public static final String RPC_SERVICE_SUFFIX = "Service";
    public static final String NOTIFICATION_LISTENER_SUFFIX = "Listener";
    public static final String QNAME_STATIC_FIELD_NAME = "QNAME";
    public static final String PACKAGE_PREFIX = "org.opendaylight.yang.gen.v1";
    private static final Splitter SPACE_SPLITTER = Splitter.on((String)" ").omitEmptyStrings().trimResults();

    public static final String getMethodName(QName name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        return BindingMapping.getMethodName(name.getLocalName());
    }

    public static final String getClassName(String localName) {
        Preconditions.checkArgument((localName != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(localName));
    }

    public static final String getMethodName(String yangIdentifier) {
        Preconditions.checkArgument((yangIdentifier != null ? 1 : 0) != 0, (Object)"Identifier should not be null");
        return BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
    }

    public static final String getClassName(QName name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
    }

    public static String getPropertyName(String yangIdentifier) {
        String potential = BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
        if ("class".equals(potential)) {
            return "xmlClass";
        }
        return potential;
    }

    private static final String toCamelCase(String rawString) {
        Preconditions.checkArgument((rawString != null ? 1 : 0) != 0, (Object)"String should not be null");
        Iterable components = SPACE_SPLITTER.split((CharSequence)rawString.replace('-', ' ').replace('_', ' '));
        StringBuilder builder = new StringBuilder();
        for (String comp : components) {
            builder.append(BindingMapping.toFirstUpper(comp));
        }
        return builder.toString();
    }

    private static String toFirstUpper(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String toFirstLower(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }
}

