/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.yang.types;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.sal.binding.yang.types.NodeWrappedType;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.parser.util.TopologicalSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionDependencySort {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionDependencySort.class);

    public List<ExtendedType> sort(Set<TypeDefinition<?>> typeDefinitions) {
        if (typeDefinitions == null) {
            LOGGER.error("Set of Type Definitions cannot be NULL!");
            throw new IllegalArgumentException("Set of Type Definitions cannot be NULL!");
        }
        Set<ExtendedType> extUnionTypes = this.unionsFromTypeDefinitions(typeDefinitions);
        Set<TopologicalSort.Node> unsorted = this.unionTypesToNodes(extUnionTypes);
        List sortedNodes = TopologicalSort.sort(unsorted);
        return Lists.transform((List)sortedNodes, (Function)new Function<TopologicalSort.Node, ExtendedType>(){

            public ExtendedType apply(TopologicalSort.Node input) {
                return (ExtendedType)((NodeWrappedType)input).getWrappedType();
            }
        });
    }

    private Set<ExtendedType> unionsFromTypeDefinitions(Set<TypeDefinition<?>> typeDefinitions) {
        HashSet unions = Sets.newHashSet();
        for (TypeDefinition<?> typedef : typeDefinitions) {
            if (typedef == null || typedef.getBaseType() == null || !(typedef instanceof ExtendedType) || !(typedef.getBaseType() instanceof UnionTypeDefinition)) continue;
            unions.add((ExtendedType)typedef);
        }
        return unions;
    }

    private Set<TopologicalSort.Node> unionTypesToNodes(Set<ExtendedType> extUnionTypes) {
        HashMap nodeMap = Maps.newHashMap();
        HashSet resultNodes = Sets.newHashSet();
        for (ExtendedType unionType : extUnionTypes) {
            NodeWrappedType node = new NodeWrappedType(unionType);
            nodeMap.put(unionType, node);
            resultNodes.add(node);
        }
        for (TopologicalSort.Node node : resultNodes) {
            NodeWrappedType nodeFrom = (NodeWrappedType)node;
            ExtendedType extUnionType = (ExtendedType)nodeFrom.getWrappedType();
            UnionTypeDefinition unionType = (UnionTypeDefinition)extUnionType.getBaseType();
            List innerTypes = unionType.getTypes();
            for (TypeDefinition typedef : innerTypes) {
                if (!extUnionTypes.contains(typedef)) continue;
                TopologicalSort.Node toNode = (TopologicalSort.Node)nodeMap.get(typedef);
                nodeFrom.addEdge(toNode);
            }
        }
        return resultNodes;
    }
}

