/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.yang.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.EnumerationBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.WildcardType;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.sal.binding.yang.types.BaseYangTypes;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.DataNodeIterator;
import org.opendaylight.yangtools.yang.model.util.EnumerationType;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.Int16;
import org.opendaylight.yangtools.yang.model.util.Int32;
import org.opendaylight.yangtools.yang.model.util.Int64;
import org.opendaylight.yangtools.yang.model.util.Int8;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.StringType;
import org.opendaylight.yangtools.yang.model.util.Uint16;
import org.opendaylight.yangtools.yang.model.util.Uint32;
import org.opendaylight.yangtools.yang.model.util.Uint64;
import org.opendaylight.yangtools.yang.model.util.Uint8;
import org.opendaylight.yangtools.yang.model.util.UnionType;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;

public final class TypeProviderImpl
implements TypeProvider {
    private final SchemaContext schemaContext;
    private Map<String, Map<Date, Map<String, Type>>> genTypeDefsContextMap;
    private final Map<SchemaPath, Type> referencedTypes;
    private final Map<Module, Set<Type>> additionalTypes;

    public TypeProviderImpl(SchemaContext schemaContext) {
        Preconditions.checkArgument((schemaContext != null ? 1 : 0) != 0, (Object)"Schema Context cannot be null!");
        this.schemaContext = schemaContext;
        this.genTypeDefsContextMap = new HashMap<String, Map<Date, Map<String, Type>>>();
        this.referencedTypes = new HashMap<SchemaPath, Type>();
        this.additionalTypes = new HashMap<Module, Set<Type>>();
        this.resolveTypeDefsFromContext();
    }

    public void putReferencedType(SchemaPath refTypePath, Type refType) {
        Preconditions.checkArgument((refTypePath != null ? 1 : 0) != 0, (Object)"Path reference of Enumeration Type Definition cannot be NULL!");
        Preconditions.checkArgument((refType != null ? 1 : 0) != 0, (Object)"Reference to Enumeration Type cannot be NULL!");
        this.referencedTypes.put(refTypePath, refType);
    }

    public Map<Module, Set<Type>> getAdditionalTypes() {
        return this.additionalTypes;
    }

    public Type javaTypeForYangType(String type) {
        return BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForYangType(type);
    }

    public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode) {
        return this.javaTypeForSchemaDefinitionType(typeDefinition, parentNode, null);
    }

    public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode, Restrictions r) {
        Type returnType = null;
        Preconditions.checkArgument((typeDefinition != null ? 1 : 0) != 0, (Object)"Type Definition cannot be NULL!");
        if (typeDefinition.getQName() == null) {
            throw new IllegalArgumentException("Type Definition cannot have non specified QName (QName cannot be NULL!)");
        }
        Preconditions.checkArgument((typeDefinition.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Type Definitions Local Name cannot be NULL!");
        if (typeDefinition instanceof ExtendedType) {
            returnType = this.javaTypeForExtendedType(typeDefinition);
        } else {
            returnType = this.javaTypeForLeafrefOrIdentityRef(typeDefinition, parentNode);
            if (returnType == null) {
                returnType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForYangType(typeDefinition.getQName().getLocalName());
            }
        }
        return returnType;
    }

    private Type javaTypeForLeafrefOrIdentityRef(TypeDefinition<?> typeDefinition, SchemaNode parentNode) {
        if (typeDefinition instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafref = (LeafrefTypeDefinition)typeDefinition;
            return this.provideTypeForLeafref(leafref, parentNode);
        }
        if (typeDefinition instanceof IdentityrefTypeDefinition) {
            IdentityrefTypeDefinition idref = (IdentityrefTypeDefinition)typeDefinition;
            return this.provideTypeForIdentityref(idref);
        }
        return null;
    }

    private Type javaTypeForExtendedType(TypeDefinition<?> typeDefinition) {
        String typedefName = typeDefinition.getQName().getLocalName();
        TypeDefinition<?> baseTypeDef = this.baseTypeDefForExtendedType(typeDefinition);
        Type returnType = null;
        returnType = this.javaTypeForLeafrefOrIdentityRef(baseTypeDef, (SchemaNode)typeDefinition);
        if (returnType == null) {
            if (baseTypeDef instanceof EnumTypeDefinition) {
                EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)baseTypeDef;
                returnType = this.provideTypeForEnum(enumTypeDef, typedefName, (SchemaNode)typeDefinition);
            } else {
                Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, typeDefinition);
                Restrictions r = BindingGeneratorUtil.getRestrictions(typeDefinition);
                if (module != null) {
                    Map<Date, Map<String, Type>> modulesByDate = this.genTypeDefsContextMap.get(module.getName());
                    Map<String, Type> genTOs = modulesByDate.get(module.getRevision());
                    if (genTOs != null) {
                        returnType = genTOs.get(typedefName);
                    }
                    if (returnType == null) {
                        returnType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(baseTypeDef, typeDefinition, r);
                    }
                }
            }
        }
        return returnType;
    }

    private Type provideTypeForIdentityref(IdentityrefTypeDefinition idref) {
        QName baseIdQName = idref.getIdentity().getQName();
        Module module = this.schemaContext.findModuleByNamespaceAndRevision(baseIdQName.getNamespace(), baseIdQName.getRevision());
        IdentitySchemaNode identity = null;
        for (IdentitySchemaNode id : module.getIdentities()) {
            if (!id.getQName().equals((Object)baseIdQName)) continue;
            identity = id;
        }
        Preconditions.checkArgument((identity != null ? 1 : 0) != 0, (Object)("Target identity '" + baseIdQName + "' do not exists"));
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)identity.getPath());
        String genTypeName = BindingGeneratorUtil.parseToClassName((String)identity.getQName().getLocalName());
        ConcreteType baseType = Types.typeForClass(Class.class);
        WildcardType paramType = Types.wildcardTypeFor((String)packageName, (String)genTypeName);
        return Types.parameterizedTypeFor((Type)baseType, (Type[])new Type[]{paramType});
    }

    public Type generatedTypeForExtendedDefinitionType(TypeDefinition<?> typeDefinition, SchemaNode parentNode) {
        Map<Date, Map<String, Type>> modulesByDate;
        Map<String, Type> genTOs;
        Module module;
        TypeDefinition<?> baseTypeDef;
        Type returnType = null;
        Preconditions.checkArgument((typeDefinition != null ? 1 : 0) != 0, (Object)"Type Definition cannot be NULL!");
        if (typeDefinition.getQName() == null) {
            throw new IllegalArgumentException("Type Definition cannot have non specified QName (QName cannot be NULL!)");
        }
        Preconditions.checkArgument((typeDefinition.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Type Definitions Local Name cannot be NULL!");
        String typedefName = typeDefinition.getQName().getLocalName();
        if (typeDefinition instanceof ExtendedType && !((baseTypeDef = this.baseTypeDefForExtendedType(typeDefinition)) instanceof LeafrefTypeDefinition) && !(baseTypeDef instanceof IdentityrefTypeDefinition) && (module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode)) != null && (genTOs = (modulesByDate = this.genTypeDefsContextMap.get(module.getName())).get(module.getRevision())) != null) {
            returnType = genTOs.get(typedefName);
        }
        return returnType;
    }

    private TypeDefinition<?> baseTypeDefForExtendedType(TypeDefinition<?> extendTypeDef) {
        Preconditions.checkArgument((extendTypeDef != null ? 1 : 0) != 0, (Object)"Type Definiition reference cannot be NULL!");
        TypeDefinition baseTypeDef = extendTypeDef.getBaseType();
        if (baseTypeDef == null) {
            return extendTypeDef;
        }
        if (baseTypeDef instanceof ExtendedType) {
            return this.baseTypeDefForExtendedType(baseTypeDef);
        }
        return baseTypeDef;
    }

    public Type provideTypeForLeafref(LeafrefTypeDefinition leafrefType, SchemaNode parentNode) {
        Object returnType = null;
        Preconditions.checkArgument((leafrefType != null ? 1 : 0) != 0, (Object)"Leafref Type Definition reference cannot be NULL!");
        Preconditions.checkArgument((leafrefType.getPathStatement() != null ? 1 : 0) != 0, (Object)"The Path Statement for Leafref Type Definition cannot be NULL!");
        RevisionAwareXPath xpath = leafrefType.getPathStatement();
        String strXPath = xpath.toString();
        if (strXPath != null) {
            if (strXPath.contains("[")) {
                returnType = Types.typeForClass(Object.class);
            } else {
                Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
                if (module != null) {
                    SchemaNode dataNode = xpath.isAbsolute() ? SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (Module)module, (RevisionAwareXPath)xpath) : SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)this.schemaContext, (Module)module, (SchemaNode)parentNode, (RevisionAwareXPath)xpath);
                    returnType = this.leafContainsEnumDefinition(dataNode) ? this.referencedTypes.get(dataNode.getPath()) : (this.leafListContainsEnumDefinition(dataNode) ? Types.listTypeFor((Type)this.referencedTypes.get(dataNode.getPath())) : this.resolveTypeFromDataSchemaNode(dataNode));
                }
            }
        }
        return returnType;
    }

    private boolean leafContainsEnumDefinition(SchemaNode dataNode) {
        LeafSchemaNode leaf;
        return dataNode instanceof LeafSchemaNode && (leaf = (LeafSchemaNode)dataNode).getType() instanceof EnumTypeDefinition;
    }

    private boolean leafListContainsEnumDefinition(SchemaNode dataNode) {
        LeafListSchemaNode leafList;
        return dataNode instanceof LeafListSchemaNode && (leafList = (LeafListSchemaNode)dataNode).getType() instanceof EnumTypeDefinition;
    }

    private Enumeration provideTypeForEnum(EnumTypeDefinition enumTypeDef, String enumName, SchemaNode parentNode) {
        Preconditions.checkArgument((enumTypeDef != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition reference cannot be NULL!");
        Preconditions.checkArgument((enumTypeDef.getValues() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain at least ONE value definition!");
        Preconditions.checkArgument((enumTypeDef.getQName() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain NON-NULL QName!");
        Preconditions.checkArgument((enumTypeDef.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Local Name in EnumTypeDefinition QName cannot be NULL!");
        String enumerationName = BindingGeneratorUtil.parseToClassName((String)enumName);
        Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        EnumerationBuilderImpl enumBuilder = new EnumerationBuilderImpl(basePackageName, enumerationName);
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        return enumBuilder.toInstance(null);
    }

    private Enumeration addInnerEnumerationToTypeBuilder(EnumTypeDefinition enumTypeDef, String enumName, GeneratedTypeBuilderBase<?> typeBuilder) {
        Preconditions.checkArgument((enumTypeDef != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition reference cannot be NULL!");
        Preconditions.checkArgument((enumTypeDef.getValues() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain at least ONE value definition!");
        Preconditions.checkArgument((enumTypeDef.getQName() != null ? 1 : 0) != 0, (Object)"EnumTypeDefinition MUST contain NON-NULL QName!");
        Preconditions.checkArgument((enumTypeDef.getQName().getLocalName() != null ? 1 : 0) != 0, (Object)"Local Name in EnumTypeDefinition QName cannot be NULL!");
        Preconditions.checkArgument((typeBuilder != null ? 1 : 0) != 0, (Object)"Generated Type Builder reference cannot be NULL!");
        String enumerationName = BindingGeneratorUtil.parseToClassName((String)enumName);
        EnumBuilder enumBuilder = typeBuilder.addEnumeration(enumerationName);
        enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
        return enumBuilder.toInstance((Type)enumBuilder);
    }

    private Type resolveTypeFromDataSchemaNode(SchemaNode dataNode) {
        Type returnType = null;
        if (dataNode != null) {
            if (dataNode instanceof LeafSchemaNode) {
                LeafSchemaNode leaf = (LeafSchemaNode)dataNode;
                returnType = this.javaTypeForSchemaDefinitionType(leaf.getType(), (SchemaNode)leaf);
            } else if (dataNode instanceof LeafListSchemaNode) {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataNode;
                returnType = this.javaTypeForSchemaDefinitionType(leafList.getType(), (SchemaNode)leafList);
            }
        }
        return returnType;
    }

    private void resolveTypeDefsFromContext() {
        Set modules = this.schemaContext.getModules();
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (Object)"Sef of Modules cannot be NULL!");
        Module[] modulesArray = new Module[modules.size()];
        int i = 0;
        for (Module modul : modules) {
            modulesArray[i++] = modul;
        }
        List modulesSortedByDependency = ModuleDependencySort.sort((Module[])modulesArray);
        for (Module module : modulesSortedByDependency) {
            Map<Date, Map<String, Type>> dateTypeMap = this.genTypeDefsContextMap.get(module.getName());
            if (dateTypeMap == null) {
                dateTypeMap = new HashMap<Date, Map<String, Type>>();
            }
            HashMap typeMap = new HashMap();
            dateTypeMap.put(module.getRevision(), typeMap);
            this.genTypeDefsContextMap.put(module.getName(), dateTypeMap);
        }
        for (Module module : modulesSortedByDependency) {
            if (module == null) continue;
            String moduleName = module.getName();
            String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
            DataNodeIterator it = new DataNodeIterator((DataNodeContainer)module);
            List typeDefinitions = it.allTypedefs();
            List<TypeDefinition<?>> listTypeDefinitions = this.sortTypeDefinitionAccordingDepth(typeDefinitions);
            if (listTypeDefinitions == null || basePackageName == null) continue;
            for (TypeDefinition<?> typedef : listTypeDefinitions) {
                this.typedefToGeneratedType(basePackageName, module, typedef);
            }
        }
    }

    private Type typedefToGeneratedType(String basePackageName, Module module, TypeDefinition<?> typedef) {
        String moduleName = module.getName();
        Date moduleRevision = module.getRevision();
        if (basePackageName != null && moduleName != null && typedef != null && typedef.getQName() != null) {
            String typedefName = typedef.getQName().getLocalName();
            TypeDefinition innerTypeDefinition = typedef.getBaseType();
            if (!(innerTypeDefinition instanceof LeafrefTypeDefinition) && !(innerTypeDefinition instanceof IdentityrefTypeDefinition)) {
                GeneratedTransferObject returnType = null;
                if (innerTypeDefinition instanceof ExtendedType) {
                    ExtendedType innerExtendedType = (ExtendedType)innerTypeDefinition;
                    returnType = this.provideGeneratedTOFromExtendedType(typedef, innerExtendedType, basePackageName);
                } else if (innerTypeDefinition instanceof UnionTypeDefinition) {
                    GeneratedTOBuilder genTOBuilder = this.provideGeneratedTOBuilderForUnionTypeDef(basePackageName, (UnionTypeDefinition)innerTypeDefinition, typedefName, (SchemaNode)typedef);
                    genTOBuilder.setTypedef(true);
                    genTOBuilder.setIsUnion(true);
                    this.addUnitsToGenTO(genTOBuilder, typedef.getUnits());
                    returnType = genTOBuilder.toInstance();
                    GeneratedTOBuilderImpl unionBuilder = new GeneratedTOBuilderImpl(genTOBuilder.getPackageName(), genTOBuilder.getName() + "Builder");
                    unionBuilder.setIsUnionBuilder(true);
                    MethodSignatureBuilder method = unionBuilder.addMethod("getDefaultInstance");
                    method.setReturnType((Type)returnType);
                    method.addParameter((Type)Types.STRING, "defaultValue");
                    method.setAccessModifier(AccessModifier.PUBLIC);
                    method.setStatic(true);
                    HashSet types = this.additionalTypes.get(module);
                    if (types == null) {
                        types = Sets.newHashSet((Object[])new Type[]{unionBuilder.toInstance()});
                        this.additionalTypes.put(module, types);
                    } else {
                        types.add((Type)unionBuilder.toInstance());
                    }
                } else if (innerTypeDefinition instanceof EnumTypeDefinition) {
                    EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)innerTypeDefinition;
                    returnType = this.provideTypeForEnum(enumTypeDef, typedefName, (SchemaNode)typedef);
                } else if (innerTypeDefinition instanceof BitsTypeDefinition) {
                    BitsTypeDefinition bitsTypeDefinition = (BitsTypeDefinition)innerTypeDefinition;
                    GeneratedTOBuilder genTOBuilder = this.provideGeneratedTOBuilderForBitsTypeDefinition(basePackageName, (TypeDefinition<?>)bitsTypeDefinition, typedefName);
                    genTOBuilder.setTypedef(true);
                    this.addUnitsToGenTO(genTOBuilder, typedef.getUnits());
                    returnType = genTOBuilder.toInstance();
                } else {
                    Type javaType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(innerTypeDefinition, typedef);
                    returnType = this.wrapJavaTypeIntoTO(basePackageName, typedef, javaType);
                }
                if (returnType != null) {
                    Map<Date, Map<String, Type>> modulesByDate = this.genTypeDefsContextMap.get(moduleName);
                    Map<String, Type> typeMap = modulesByDate.get(moduleRevision);
                    if (typeMap != null) {
                        typeMap.put(typedefName, (Type)returnType);
                    }
                    return returnType;
                }
            }
        }
        return null;
    }

    private GeneratedTransferObject wrapJavaTypeIntoTO(String basePackageName, TypeDefinition<?> typedef, Type javaType) {
        Preconditions.checkNotNull((Object)javaType, (Object)"javaType cannot be null");
        String propertyName = "value";
        GeneratedTOBuilder genTOBuilder = this.typedefToTransferObject(basePackageName, typedef);
        genTOBuilder.setRestrictions(BindingGeneratorUtil.getRestrictions(typedef));
        GeneratedPropertyBuilder genPropBuilder = genTOBuilder.addProperty("value");
        genPropBuilder.setReturnType(javaType);
        genTOBuilder.addEqualsIdentity(genPropBuilder);
        genTOBuilder.addHashIdentity(genPropBuilder);
        genTOBuilder.addToStringProperty(genPropBuilder);
        if (javaType instanceof ConcreteType && "String".equals(javaType.getName()) && typedef instanceof ExtendedType) {
            List<String> regExps = this.resolveRegExpressionsFromTypedef((ExtendedType)typedef);
            this.addStringRegExAsConstant(genTOBuilder, regExps);
        }
        this.addUnitsToGenTO(genTOBuilder, typedef.getUnits());
        genTOBuilder.setTypedef(true);
        return genTOBuilder.toInstance();
    }

    public GeneratedTOBuilder provideGeneratedTOBuilderForUnionTypeDef(String basePackageName, UnionTypeDefinition typedef, String typeDefName, SchemaNode parentNode) {
        List<GeneratedTOBuilder> genTOBuilders = this.provideGeneratedTOBuildersForUnionTypeDef(basePackageName, typedef, typeDefName, parentNode);
        GeneratedTOBuilder resultTOBuilder = null;
        if (!genTOBuilders.isEmpty()) {
            resultTOBuilder = genTOBuilders.remove(0);
            for (GeneratedTOBuilder genTOBuilder : genTOBuilders) {
                resultTOBuilder.addEnclosingTransferObject(genTOBuilder);
            }
        }
        GeneratedPropertyBuilder genPropBuilder = resultTOBuilder.addProperty("value");
        genPropBuilder.setReturnType(Types.primitiveType((String)"char[]", null));
        resultTOBuilder.addEqualsIdentity(genPropBuilder);
        resultTOBuilder.addHashIdentity(genPropBuilder);
        resultTOBuilder.addToStringProperty(genPropBuilder);
        return resultTOBuilder;
    }

    public List<GeneratedTOBuilder> provideGeneratedTOBuildersForUnionTypeDef(String basePackageName, UnionTypeDefinition typedef, String typeDefName, SchemaNode parentNode) {
        GeneratedTOBuilder unionGenTOBuilder;
        Preconditions.checkNotNull((Object)basePackageName, (Object)"Base Package Name cannot be NULL!");
        Preconditions.checkNotNull((Object)typedef, (Object)"Type Definition cannot be NULL!");
        Preconditions.checkNotNull((Object)typedef.getQName(), (Object)"Type definition QName cannot be NULL!");
        ArrayList<GeneratedTOBuilder> generatedTOBuilders = new ArrayList<GeneratedTOBuilder>();
        List unionTypes = typedef.getTypes();
        if (typeDefName != null && !typeDefName.isEmpty()) {
            String typeName = BindingGeneratorUtil.parseToClassName((String)typeDefName);
            unionGenTOBuilder = new GeneratedTOBuilderImpl(basePackageName, typeName);
        } else {
            unionGenTOBuilder = this.typedefToTransferObject(basePackageName, (TypeDefinition<?>)typedef);
        }
        generatedTOBuilders.add(unionGenTOBuilder);
        unionGenTOBuilder.setIsUnion(true);
        ArrayList<String> regularExpressions = new ArrayList<String>();
        for (TypeDefinition unionType : unionTypes) {
            String unionTypeName = unionType.getQName().getLocalName();
            if (unionType instanceof UnionType) {
                generatedTOBuilders.addAll(this.resolveUnionSubtypeAsUnion(unionGenTOBuilder, (UnionTypeDefinition)((UnionType)unionType), basePackageName, parentNode));
                continue;
            }
            if (unionType instanceof ExtendedType) {
                this.resolveExtendedSubtypeAsUnion(unionGenTOBuilder, (ExtendedType)unionType, regularExpressions, parentNode);
                continue;
            }
            if (unionType instanceof EnumTypeDefinition) {
                Enumeration enumeration = this.addInnerEnumerationToTypeBuilder((EnumTypeDefinition)unionType, unionTypeName, (GeneratedTypeBuilderBase<?>)unionGenTOBuilder);
                this.updateUnionTypeAsProperty(unionGenTOBuilder, (Type)enumeration, unionTypeName);
                continue;
            }
            Type javaType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(unionType, parentNode);
            this.updateUnionTypeAsProperty(unionGenTOBuilder, javaType, unionTypeName);
        }
        if (!regularExpressions.isEmpty()) {
            this.addStringRegExAsConstant(unionGenTOBuilder, regularExpressions);
        }
        this.storeGenTO((TypeDefinition<?>)typedef, unionGenTOBuilder, parentNode);
        return generatedTOBuilders;
    }

    private List<GeneratedTOBuilder> resolveUnionSubtypeAsUnion(GeneratedTOBuilder parentUnionGenTOBuilder, UnionTypeDefinition unionSubtype, String basePackageName, SchemaNode parentNode) {
        String newTOBuilderName = this.provideAvailableNameForGenTOBuilder(parentUnionGenTOBuilder.getName());
        List<GeneratedTOBuilder> subUnionGenTOBUilders = this.provideGeneratedTOBuildersForUnionTypeDef(basePackageName, unionSubtype, newTOBuilderName, parentNode);
        GeneratedPropertyBuilder propertyBuilder = parentUnionGenTOBuilder.addProperty(BindingGeneratorUtil.parseToValidParamName((String)newTOBuilderName));
        propertyBuilder.setReturnType((Type)subUnionGenTOBUilders.get(0));
        parentUnionGenTOBuilder.addEqualsIdentity(propertyBuilder);
        parentUnionGenTOBuilder.addToStringProperty(propertyBuilder);
        return subUnionGenTOBUilders;
    }

    private void resolveExtendedSubtypeAsUnion(GeneratedTOBuilder parentUnionGenTOBuilder, ExtendedType unionSubtype, List<String> regularExpressions, SchemaNode parentNode) {
        String unionTypeName = unionSubtype.getQName().getLocalName();
        Type genTO = this.findGenTO(unionTypeName, (SchemaNode)unionSubtype);
        if (genTO != null) {
            this.updateUnionTypeAsProperty(parentUnionGenTOBuilder, genTO, genTO.getName());
        } else {
            Type javaType;
            TypeDefinition<?> baseType = this.baseTypeDefForExtendedType((TypeDefinition<?>)unionSubtype);
            if (unionTypeName.equals(baseType.getQName().getLocalName()) && (javaType = BaseYangTypes.BASE_YANG_TYPES_PROVIDER.javaTypeForSchemaDefinitionType(baseType, parentNode)) != null) {
                this.updateUnionTypeAsProperty(parentUnionGenTOBuilder, javaType, unionTypeName);
            }
            if (baseType instanceof StringType) {
                regularExpressions.addAll(this.resolveRegExpressionsFromTypedef(unionSubtype));
            }
        }
    }

    private Type findGenTO(String searchedTypeName, SchemaNode parentNode) {
        Map<Date, Map<String, Type>> modulesByDate;
        Map<String, Type> genTOs;
        Module typeModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
        if (typeModule != null && typeModule.getName() != null && (genTOs = (modulesByDate = this.genTypeDefsContextMap.get(typeModule.getName())).get(typeModule.getRevision())) != null) {
            return genTOs.get(searchedTypeName);
        }
        return null;
    }

    private void storeGenTO(TypeDefinition<?> newTypeDef, GeneratedTOBuilder genTOBuilder, SchemaNode parentNode) {
        Module parentModule;
        if (!(newTypeDef instanceof UnionType) && (parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode)) != null && parentModule.getName() != null) {
            Map<Date, Map<String, Type>> modulesByDate = this.genTypeDefsContextMap.get(parentModule.getName());
            Map<String, Type> genTOsMap = modulesByDate.get(parentModule.getRevision());
            genTOsMap.put(newTypeDef.getQName().getLocalName(), (Type)genTOBuilder.toInstance());
        }
    }

    private void updateUnionTypeAsProperty(GeneratedTOBuilder unionGenTransObject, Type type, String propertyName) {
        if (unionGenTransObject != null && type != null && !unionGenTransObject.containsProperty(propertyName)) {
            GeneratedPropertyBuilder propBuilder = unionGenTransObject.addProperty(BindingGeneratorUtil.parseToValidParamName((String)propertyName));
            propBuilder.setReturnType(type);
            unionGenTransObject.addEqualsIdentity(propBuilder);
            unionGenTransObject.addHashIdentity(propBuilder);
            unionGenTransObject.addToStringProperty(propBuilder);
        }
    }

    private GeneratedTOBuilder typedefToTransferObject(String basePackageName, TypeDefinition<?> typedef) {
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)typedef.getPath());
        String typeDefTOName = typedef.getQName().getLocalName();
        if (packageName != null && typedef != null && typeDefTOName != null) {
            String genTOName = BindingGeneratorUtil.parseToClassName((String)typeDefTOName);
            GeneratedTOBuilderImpl newType = new GeneratedTOBuilderImpl(packageName, genTOName);
            newType.addComment(typedef.getDescription());
            return newType;
        }
        return null;
    }

    public GeneratedTOBuilder provideGeneratedTOBuilderForBitsTypeDefinition(String basePackageName, TypeDefinition<?> typeDef, String typeDefName) {
        Preconditions.checkArgument((typeDef != null ? 1 : 0) != 0, (Object)"typeDef cannot be NULL!");
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"Base Package Name cannot be NULL!");
        if (typeDef instanceof BitsTypeDefinition) {
            BitsTypeDefinition bitsTypeDefinition = (BitsTypeDefinition)typeDef;
            String typeName = BindingGeneratorUtil.parseToClassName((String)typeDefName);
            GeneratedTOBuilderImpl genTOBuilder = new GeneratedTOBuilderImpl(basePackageName, typeName);
            List bitList = bitsTypeDefinition.getBits();
            for (BitsTypeDefinition.Bit bit : bitList) {
                String name = bit.getName();
                GeneratedPropertyBuilder genPropertyBuilder = genTOBuilder.addProperty(BindingGeneratorUtil.parseToValidParamName((String)name));
                genPropertyBuilder.setReadOnly(true);
                genPropertyBuilder.setReturnType(BaseYangTypes.BOOLEAN_TYPE);
                genTOBuilder.addEqualsIdentity(genPropertyBuilder);
                genTOBuilder.addHashIdentity(genPropertyBuilder);
                genTOBuilder.addToStringProperty(genPropertyBuilder);
            }
            return genTOBuilder;
        }
        return null;
    }

    private List<String> resolveRegExpressionsFromTypedef(ExtendedType typedef) {
        List patternConstraints;
        ArrayList<String> regExps = new ArrayList<String>();
        Preconditions.checkArgument((typedef != null ? 1 : 0) != 0, (Object)"typedef can't be null");
        TypeDefinition<?> strTypeDef = this.baseTypeDefForExtendedType((TypeDefinition<?>)typedef);
        if (strTypeDef instanceof StringType && !(patternConstraints = typedef.getPatternConstraints()).isEmpty()) {
            for (PatternConstraint patternConstraint : patternConstraints) {
                String regEx = patternConstraint.getRegularExpression();
                String modifiedRegEx = StringEscapeUtils.escapeJava((String)regEx);
                regExps.add(modifiedRegEx);
            }
        }
        return regExps;
    }

    private void addStringRegExAsConstant(GeneratedTOBuilder genTOBuilder, List<String> regularExpressions) {
        if (genTOBuilder == null) {
            throw new IllegalArgumentException("Generated transfer object builder can't be null");
        }
        if (regularExpressions == null) {
            throw new IllegalArgumentException("List of regular expressions can't be null");
        }
        if (!regularExpressions.isEmpty()) {
            genTOBuilder.addConstant((Type)Types.listTypeFor((Type)BaseYangTypes.STRING_TYPE), "PATTERN_CONSTANTS", regularExpressions);
        }
    }

    private GeneratedTransferObject provideGeneratedTOFromExtendedType(TypeDefinition<?> typedef, ExtendedType innerExtendedType, String basePackageName) {
        Type type;
        Preconditions.checkArgument((innerExtendedType != null ? 1 : 0) != 0, (Object)"Extended type cannot be NULL!");
        Preconditions.checkArgument((basePackageName != null ? 1 : 0) != 0, (Object)"String with base package name cannot be NULL!");
        String typedefName = typedef.getQName().getLocalName();
        String classTypedefName = BindingGeneratorUtil.parseToClassName((String)typedefName);
        String innerTypeDef = innerExtendedType.getQName().getLocalName();
        GeneratedTOBuilderImpl genTOBuilder = new GeneratedTOBuilderImpl(basePackageName, classTypedefName);
        genTOBuilder.setTypedef(true);
        Restrictions r = BindingGeneratorUtil.getRestrictions(typedef);
        genTOBuilder.setRestrictions(r);
        if (this.baseTypeDefForExtendedType((TypeDefinition<?>)innerExtendedType) instanceof UnionTypeDefinition) {
            genTOBuilder.setIsUnion(true);
        }
        Map<Date, Map<String, Type>> modulesByDate = null;
        Map<String, Type> typeMap = null;
        Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)innerExtendedType);
        if (parentModule != null) {
            modulesByDate = this.genTypeDefsContextMap.get(parentModule.getName());
            typeMap = modulesByDate.get(parentModule.getRevision());
        }
        if (typeMap != null && (type = (Type)typeMap.get(innerTypeDef)) instanceof GeneratedTransferObject) {
            genTOBuilder.setExtendsType((GeneratedTransferObject)type);
        }
        this.addUnitsToGenTO((GeneratedTOBuilder)genTOBuilder, typedef.getUnits());
        return genTOBuilder.toInstance();
    }

    private List<TypeDefinition<?>> sortTypeDefinitionAccordingDepth(Collection<TypeDefinition<?>> unsortedTypeDefinitions) {
        ArrayList sortedTypeDefinition = new ArrayList();
        TreeMap typeDefinitionsDepths = new TreeMap();
        for (TypeDefinition<?> unsortedTypeDefinition : unsortedTypeDefinitions) {
            int depth = this.getTypeDefinitionDepth(unsortedTypeDefinition);
            ArrayList typeDefinitionsConcreteDepth = (ArrayList)typeDefinitionsDepths.get(depth);
            if (typeDefinitionsConcreteDepth == null) {
                typeDefinitionsConcreteDepth = new ArrayList();
                typeDefinitionsDepths.put(depth, typeDefinitionsConcreteDepth);
            }
            typeDefinitionsConcreteDepth.add(unsortedTypeDefinition);
        }
        Set depths = typeDefinitionsDepths.keySet();
        for (Integer depth : depths) {
            sortedTypeDefinition.addAll((Collection)typeDefinitionsDepths.get(depth));
        }
        return sortedTypeDefinition;
    }

    private int getTypeDefinitionDepth(TypeDefinition<?> typeDefinition) {
        if (typeDefinition == null) {
            return 1;
        }
        int depth = 1;
        TypeDefinition baseType = typeDefinition.getBaseType();
        if (baseType instanceof ExtendedType) {
            depth += this.getTypeDefinitionDepth(typeDefinition.getBaseType());
        } else if (baseType instanceof UnionType) {
            List childTypeDefinitions = ((UnionType)baseType).getTypes();
            int maxChildDepth = 0;
            int childDepth = 1;
            for (TypeDefinition childTypeDefinition : childTypeDefinitions) {
                if ((childDepth += this.getTypeDefinitionDepth(childTypeDefinition)) <= maxChildDepth) continue;
                maxChildDepth = childDepth;
            }
            return maxChildDepth;
        }
        return depth;
    }

    private String provideAvailableNameForGenTOBuilder(String name) {
        Pattern searchedPattern = Pattern.compile("[0-9]+\\z");
        Matcher mtch = searchedPattern.matcher(name);
        if (mtch.find()) {
            int newSuffix = Integer.valueOf(name.substring(mtch.start())) + 1;
            return name.substring(0, mtch.start()) + newSuffix;
        }
        return name + 1;
    }

    public void addUnitsToGenTO(GeneratedTOBuilder to, String units) {
        if (units != null && !units.isEmpty()) {
            to.addConstant((Type)Types.STRING, "_UNITS", (Object)("\"" + units + "\""));
            GeneratedPropertyBuilderImpl prop = new GeneratedPropertyBuilderImpl("UNITS");
            prop.setReturnType((Type)Types.STRING);
            to.addToStringProperty((GeneratedPropertyBuilder)prop);
        }
    }

    public String getTypeDefaultConstruction(LeafSchemaNode node) {
        return this.getTypeDefaultConstruction(node, node.getDefault());
    }

    public String getTypeDefaultConstruction(LeafSchemaNode node, String defaultValue) {
        String className;
        TypeDefinition type = node.getType();
        QName typeQName = type.getQName();
        TypeDefinition<?> base = this.baseTypeDefForExtendedType(type);
        Preconditions.checkNotNull((Object)type, (Object)("Cannot provide default construction for null type of " + node));
        Preconditions.checkNotNull((Object)defaultValue, (Object)("Cannot provide default construction for null default statement of " + node));
        StringBuilder sb = new StringBuilder();
        String result = null;
        if (base instanceof BinaryTypeDefinition) {
            result = this.binaryToDef(defaultValue);
        } else if (base instanceof BitsTypeDefinition) {
            String className2;
            String parentName;
            SchemaPath nodePath = node.getPath();
            Module parent = this.getParentModule((SchemaNode)node);
            if (nodePath.getPath().size() == 1) {
                parentName = BindingMapping.getClassName((String)parent.getName()) + "Data";
                String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)parent);
                className2 = basePackageName + "." + parentName + "." + BindingMapping.getClassName((QName)node.getQName());
            } else {
                String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)parent);
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)type.getPath());
                parentName = BindingMapping.getClassName((QName)((SchemaNode)parent).getQName());
                className2 = packageName + "." + parentName + "." + BindingMapping.getClassName((QName)node.getQName());
            }
            result = this.bitsToDef((BitsTypeDefinition)base, className2, defaultValue, type instanceof ExtendedType);
        } else if (base instanceof BooleanTypeDefinition) {
            result = this.typeToDef(Boolean.class, defaultValue);
        } else if (base instanceof DecimalTypeDefinition) {
            result = this.typeToDef(BigDecimal.class, defaultValue);
        } else if (base instanceof EmptyTypeDefinition) {
            result = this.typeToDef(Boolean.class, defaultValue);
        } else if (base instanceof EnumTypeDefinition) {
            char first;
            char[] defValArray = defaultValue.toCharArray();
            defValArray[0] = first = Character.toUpperCase(defaultValue.charAt(0));
            String newDefVal = new String(defValArray);
            if (type instanceof ExtendedType) {
                Module m = this.getParentModule((SchemaNode)type);
                String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)m);
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)type.getPath());
                className = packageName + "." + BindingMapping.getClassName((QName)typeQName);
            } else {
                Module parentModule = this.getParentModule((SchemaNode)node);
                String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)parentModule);
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)node.getPath());
                className = packageName + "." + BindingMapping.getClassName((QName)node.getQName());
            }
            result = className + "." + newDefVal;
        } else {
            if (base instanceof IdentityrefTypeDefinition) {
                throw new UnsupportedOperationException("Cannot get default construction for identityref type");
            }
            if (base instanceof InstanceIdentifierTypeDefinition) {
                throw new UnsupportedOperationException("Cannot get default construction for instance-identifier type");
            }
            result = base instanceof Int8 ? this.typeToDef(Byte.class, defaultValue) : (base instanceof Int16 ? this.typeToDef(Short.class, defaultValue) : (base instanceof Int32 ? this.typeToDef(Integer.class, defaultValue) : (base instanceof Int64 ? this.typeToDef(Long.class, defaultValue) : (base instanceof LeafrefTypeDefinition ? this.leafrefToDef(node, (LeafrefTypeDefinition)base) : (base instanceof StringTypeDefinition ? "\"" + defaultValue + "\"" : (base instanceof Uint8 ? this.typeToDef(Short.class, defaultValue) : (base instanceof Uint16 ? this.typeToDef(Integer.class, defaultValue) : (base instanceof Uint32 ? this.typeToDef(Long.class, defaultValue) : (base instanceof Uint64 ? this.typeToDef(BigInteger.class, defaultValue) : (base instanceof UnionTypeDefinition ? this.unionToDef(node) : ""))))))))));
        }
        sb.append(result);
        if (type instanceof ExtendedType && !(base instanceof LeafrefTypeDefinition) && !(base instanceof EnumerationType) && !(base instanceof UnionTypeDefinition)) {
            Module m = this.getParentModule((SchemaNode)type);
            String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)m);
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)type.getPath());
            className = packageName + "." + BindingMapping.getClassName((QName)typeQName);
            sb.insert(0, "new " + className + "(");
            sb.insert(sb.length(), ")");
        }
        return sb.toString();
    }

    private String typeToDef(Class<?> clazz, String defaultValue) {
        return "new " + clazz.getName() + "(\"" + defaultValue + "\")";
    }

    private String binaryToDef(String defaultValue) {
        StringBuilder sb = new StringBuilder();
        BaseEncoding en = BaseEncoding.base64();
        byte[] encoded = en.decode((CharSequence)defaultValue);
        sb.append("new byte[] {");
        for (int i = 0; i < encoded.length; ++i) {
            sb.append(encoded[i]);
            if (i == encoded.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private String bitsToDef(BitsTypeDefinition type, String className, String defaultValue, boolean isExt) {
        ArrayList bits = new ArrayList(type.getBits());
        Collections.sort(bits, new Comparator<BitsTypeDefinition.Bit>(){

            @Override
            public int compare(BitsTypeDefinition.Bit o1, BitsTypeDefinition.Bit o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append(isExt ? "" : "new " + className + "(");
        for (int i = 0; i < bits.size(); ++i) {
            if (((BitsTypeDefinition.Bit)bits.get(i)).getName().equals(defaultValue)) {
                sb.append(true);
            } else {
                sb.append(false);
            }
            if (i == bits.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(isExt ? "" : ")");
        return sb.toString();
    }

    private Module getParentModule(SchemaNode node) {
        QName qname = (QName)node.getPath().getPath().get(0);
        URI namespace = qname.getNamespace();
        Date revision = qname.getRevision();
        return this.schemaContext.findModuleByNamespaceAndRevision(namespace, revision);
    }

    private String leafrefToDef(LeafSchemaNode parentNode, LeafrefTypeDefinition leafrefType) {
        Preconditions.checkArgument((leafrefType != null ? 1 : 0) != 0, (Object)"Leafref Type Definition reference cannot be NULL!");
        Preconditions.checkArgument((leafrefType.getPathStatement() != null ? 1 : 0) != 0, (Object)"The Path Statement for Leafref Type Definition cannot be NULL!");
        RevisionAwareXPath xpath = leafrefType.getPathStatement();
        String strXPath = xpath.toString();
        if (strXPath != null) {
            if (strXPath.contains("[")) {
                return "new java.lang.Object()";
            }
            Module module = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)parentNode);
            if (module != null) {
                SchemaNode dataNode = xpath.isAbsolute() ? SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (Module)module, (RevisionAwareXPath)xpath) : SchemaContextUtil.findDataSchemaNodeForRelativeXPath((SchemaContext)this.schemaContext, (Module)module, (SchemaNode)parentNode, (RevisionAwareXPath)xpath);
                String result = this.getTypeDefaultConstruction((LeafSchemaNode)dataNode, parentNode.getDefault());
                return result;
            }
        }
        return null;
    }

    private String unionToDef(LeafSchemaNode node) {
        String className;
        if (node.getType() instanceof ExtendedType) {
            ExtendedType type = (ExtendedType)node.getType();
            QName typeQName = type.getQName();
            Module module = null;
            Set modules = this.schemaContext.findModuleByNamespace(typeQName.getNamespace());
            if (modules.size() > 1) {
                for (Module m : modules) {
                    if (!m.getRevision().equals(typeQName.getRevision())) continue;
                    module = m;
                    break;
                }
                if (module == null) {
                    ArrayList modulesList = new ArrayList(modules);
                    Collections.sort(modulesList, new Comparator<Module>(){

                        @Override
                        public int compare(Module o1, Module o2) {
                            return o1.getRevision().compareTo(o2.getRevision());
                        }
                    });
                    module = (Module)modulesList.get(0);
                }
            } else {
                module = (Module)modules.iterator().next();
            }
            String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
            className = basePackageName + "." + BindingMapping.getClassName((QName)typeQName);
        } else {
            SchemaPath nodePath = node.getPath();
            if (nodePath.getPath().size() == 1) {
                QName first = (QName)nodePath.getPath().get(0);
                URI namespace = first.getNamespace();
                Date revision = first.getRevision();
                Module parent = this.schemaContext.findModuleByNamespaceAndRevision(namespace, revision);
                String parentName = BindingMapping.getClassName((String)parent.getName()) + "Data";
                String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)parent);
                className = basePackageName + "." + parentName + "." + BindingMapping.getClassName((QName)node.getQName());
            } else {
                QName first = (QName)node.getPath().getPath().get(0);
                URI namespace = first.getNamespace();
                Date revision = first.getRevision();
                Module parentModule = this.schemaContext.findModuleByNamespaceAndRevision(namespace, revision);
                String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)parentModule);
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)node.getType().getPath());
                className = packageName + "." + BindingMapping.getClassName((QName)node.getQName());
            }
        }
        return this.union(className, node.getDefault(), node);
    }

    private String union(String className, String defaultValue, LeafSchemaNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("new " + className + "(");
        sb.append("\"");
        sb.append(defaultValue);
        sb.append("\"");
        sb.append(".toCharArray()");
        sb.append(")");
        return sb.toString();
    }

    public String getConstructorPropertyName(SchemaNode node) {
        if (node instanceof TypeDefinition) {
            return "value";
        }
        return "";
    }

    public String getParamNameFromType(TypeDefinition<?> type) {
        return BindingGeneratorUtil.parseToValidParamName((String)type.getQName().getLocalName());
    }
}

