/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.yang.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;

public final class BaseYangTypes {
    private static Map<String, Type> typeMap = new HashMap<String, Type>();
    public static final Type BOOLEAN_TYPE = Types.typeForClass(Boolean.class);
    public static final Type EMPTY_TYPE = Types.typeForClass(Boolean.class);
    public static final Type ENUM_TYPE = Types.typeForClass(Enum.class);
    public static final Type INT8_TYPE = Types.typeForClass(Byte.class);
    public static final Type INT16_TYPE = Types.typeForClass(Short.class);
    public static final Type INT32_TYPE = Types.typeForClass(Integer.class);
    public static final Type INT64_TYPE = Types.typeForClass(Long.class);
    public static final Type STRING_TYPE = Types.typeForClass(String.class);
    public static final Type DECIMAL64_TYPE = Types.typeForClass(BigDecimal.class);
    public static final Type UINT8_TYPE = Types.typeForClass(Short.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0, 255));
    public static final Type UINT16_TYPE = Types.typeForClass(Integer.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0, 65535));
    public static final Type UINT32_TYPE = Types.typeForClass(Long.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0, 0xFFFFFFFFL));
    public static final Type UINT64_TYPE = Types.typeForClass(BigInteger.class, (Restrictions)BaseYangTypes.singleRangeRestrictions(0, new BigInteger("18446744073709551615")));
    public static final Type UNION_TYPE = new UnionType();
    public static final Type BINARY_TYPE = Types.primitiveType((String)"byte[]", null);
    public static final Type INSTANCE_IDENTIFIER = Types.parameterizedTypeFor((Type)Types.typeForClass(InstanceIdentifier.class), (Type[])new Type[0]);
    public static final TypeProvider BASE_YANG_TYPES_PROVIDER;

    private BaseYangTypes() {
    }

    private static Restrictions singleRangeRestrictions(final Number min, final Number max) {
        return new Restrictions(){

            public boolean isEmpty() {
                return false;
            }

            public List<RangeConstraint> getRangeConstraints() {
                return Collections.singletonList(BaseConstraints.rangeConstraint((Number)min, (Number)max, null, null));
            }

            public List<PatternConstraint> getPatternConstraints() {
                return Collections.emptyList();
            }

            public List<LengthConstraint> getLengthConstraints() {
                return Collections.emptyList();
            }
        };
    }

    static {
        typeMap.put("boolean", BOOLEAN_TYPE);
        typeMap.put("empty", EMPTY_TYPE);
        typeMap.put("enumeration", ENUM_TYPE);
        typeMap.put("int8", INT8_TYPE);
        typeMap.put("int16", INT16_TYPE);
        typeMap.put("int32", INT32_TYPE);
        typeMap.put("int64", INT64_TYPE);
        typeMap.put("string", STRING_TYPE);
        typeMap.put("decimal64", DECIMAL64_TYPE);
        typeMap.put("uint8", UINT8_TYPE);
        typeMap.put("uint16", UINT16_TYPE);
        typeMap.put("uint32", UINT32_TYPE);
        typeMap.put("uint64", UINT64_TYPE);
        typeMap.put("union", UNION_TYPE);
        typeMap.put("binary", BINARY_TYPE);
        typeMap.put("instance-identifier", INSTANCE_IDENTIFIER);
        BASE_YANG_TYPES_PROVIDER = new TypeProvider(){

            public Type javaTypeForYangType(String type) {
                return (Type)typeMap.get(type);
            }

            public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode) {
                if (type != null) {
                    return (Type)typeMap.get(type.getQName().getLocalName());
                }
                return null;
            }

            public Type javaTypeForSchemaDefinitionType(TypeDefinition<?> type, SchemaNode parentNode, Restrictions restrictions) {
                String typeName;
                switch (typeName = type.getQName().getLocalName()) {
                    case "binary": {
                        return Types.primitiveType((String)"byte[]", (Restrictions)restrictions);
                    }
                    case "decimal64": {
                        return Types.typeForClass(BigDecimal.class, (Restrictions)restrictions);
                    }
                    case "enumeration": {
                        return Types.typeForClass(Enum.class, (Restrictions)restrictions);
                    }
                    case "int8": {
                        return Types.typeForClass(Byte.class, (Restrictions)restrictions);
                    }
                    case "int16": {
                        return Types.typeForClass(Short.class, (Restrictions)restrictions);
                    }
                    case "int32": {
                        return Types.typeForClass(Integer.class, (Restrictions)restrictions);
                    }
                    case "int64": {
                        return Types.typeForClass(Long.class, (Restrictions)restrictions);
                    }
                    case "string": {
                        return Types.typeForClass(String.class, (Restrictions)restrictions);
                    }
                    case "uint8": {
                        return Types.typeForClass(Short.class, (Restrictions)restrictions);
                    }
                    case "uint16": {
                        return Types.typeForClass(Integer.class, (Restrictions)restrictions);
                    }
                    case "uint32": {
                        return Types.typeForClass(Long.class, (Restrictions)restrictions);
                    }
                    case "uint64": {
                        return Types.typeForClass(BigInteger.class, (Restrictions)restrictions);
                    }
                    case "union": {
                        return UNION_TYPE;
                    }
                }
                return this.javaTypeForSchemaDefinitionType(type, parentNode);
            }

            public String getTypeDefaultConstruction(LeafSchemaNode node) {
                return null;
            }

            public String getConstructorPropertyName(SchemaNode node) {
                return null;
            }

            public String getParamNameFromType(TypeDefinition<?> type) {
                return "_" + BindingGeneratorUtil.parseToValidParamName((String)type.getQName().getLocalName());
            }
        };
    }

    public static final class UnionType
    implements Type {
        public String getPackageName() {
            return null;
        }

        public String getName() {
            return "Union";
        }

        public String getFullyQualifiedName() {
            return "Union";
        }
    }
}

