/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.statistics.manager;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.md.sal.common.api.data.DataChangeEvent;
import org.opendaylight.controller.md.statistics.manager.StatisticsProvider;
import org.opendaylight.controller.sal.binding.api.data.DataChangeListener;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.FlowCapableNodeConnectorQueueStatisticsData;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsUpdateHandler
implements DataChangeListener {
    public static final Logger suhLogger = LoggerFactory.getLogger(StatisticsUpdateHandler.class);
    private final StatisticsProvider statisticsManager;

    public StatisticsUpdateHandler(StatisticsProvider manager) {
        this.statisticsManager = manager;
    }

    public StatisticsProvider getStatisticsManager() {
        return this.statisticsManager;
    }

    public void onDataChanged(DataChangeEvent<InstanceIdentifier<?>, DataObject> change) {
        Map nodeAdditions = change.getCreatedOperationalData();
        for (InstanceIdentifier dataObjectInstance : nodeAdditions.keySet()) {
            Node node;
            DataObject dataObject = (DataObject)nodeAdditions.get(dataObjectInstance);
            if (!(dataObject instanceof Node) || (node = (Node)dataObject).getAugmentation(FlowCapableNode.class) == null) continue;
            this.statisticsManager.sendStatisticsRequestsToNode(node);
        }
        Map additions = change.getCreatedConfigurationData();
        for (InstanceIdentifier dataObjectInstance : additions.keySet()) {
            DataObject dataObject = (DataObject)additions.get(dataObjectInstance);
            InstanceIdentifier nodeII = dataObjectInstance.firstIdentifierOf(Node.class);
            NodeRef nodeRef = new NodeRef(nodeII);
            if (dataObject instanceof Flow) {
                Flow flow = (Flow)dataObject;
                try {
                    this.statisticsManager.sendFlowStatsFromTableRequest(nodeRef, flow);
                }
                catch (InterruptedException | ExecutionException e) {
                    suhLogger.warn("Following exception occured while sending flow statistics request newly added flow: {}", (Throwable)e);
                }
            }
            if (dataObject instanceof Meter) {
                try {
                    this.statisticsManager.sendMeterConfigStatisticsRequest(nodeRef);
                }
                catch (InterruptedException | ExecutionException e) {
                    suhLogger.warn("Following exception occured while sending meter statistics request for newly added meter: {}", (Throwable)e);
                }
            }
            if (dataObject instanceof Group) {
                try {
                    this.statisticsManager.sendGroupDescriptionRequest(nodeRef);
                }
                catch (InterruptedException | ExecutionException e) {
                    suhLogger.warn("Following exception occured while sending group description request for newly added group: {}", (Throwable)e);
                }
            }
            if (!(dataObject instanceof Queue)) continue;
            Queue queue = (Queue)dataObject;
            InstanceIdentifier nodeConnectorII = dataObjectInstance.firstIdentifierOf(NodeConnector.class);
            NodeConnectorKey nodeConnectorKey = (NodeConnectorKey)InstanceIdentifier.keyOf((InstanceIdentifier)nodeConnectorII);
            try {
                this.statisticsManager.sendQueueStatsFromGivenNodeConnector(nodeRef, nodeConnectorKey.getId(), queue.getQueueId());
            }
            catch (InterruptedException | ExecutionException e) {
                suhLogger.warn("Following exception occured while sending queue statistics request for newly added group: {}", (Throwable)e);
            }
        }
        Set removals = change.getRemovedConfigurationData();
        for (InstanceIdentifier dataObjectInstance : removals) {
            DataObject dataObject = (DataObject)change.getOriginalConfigurationData().get(dataObjectInstance);
            if (dataObject instanceof Flow) {
                InstanceIdentifier flowII = dataObjectInstance;
                InstanceIdentifier flowAugmentation = (InstanceIdentifier)InstanceIdentifier.builder((InstanceIdentifier)flowII).augmentation(FlowStatisticsData.class).toInstance();
                this.removeAugmentedOperationalData((InstanceIdentifier<? extends DataObject>)flowAugmentation);
            }
            if (dataObject instanceof Meter) {
                InstanceIdentifier meterII = dataObjectInstance;
                InstanceIdentifier nodeMeterConfigStatsAugmentation = (InstanceIdentifier)InstanceIdentifier.builder((InstanceIdentifier)meterII).augmentation(NodeMeterConfigStats.class).toInstance();
                this.removeAugmentedOperationalData((InstanceIdentifier<? extends DataObject>)nodeMeterConfigStatsAugmentation);
                InstanceIdentifier nodeMeterStatisticsAugmentation = (InstanceIdentifier)InstanceIdentifier.builder((InstanceIdentifier)meterII).augmentation(NodeMeterStatistics.class).toInstance();
                this.removeAugmentedOperationalData((InstanceIdentifier<? extends DataObject>)nodeMeterStatisticsAugmentation);
            }
            if (dataObject instanceof Group) {
                InstanceIdentifier groupII = dataObjectInstance;
                InstanceIdentifier nodeGroupDescStatsAugmentation = (InstanceIdentifier)InstanceIdentifier.builder((InstanceIdentifier)groupII).augmentation(NodeGroupDescStats.class).toInstance();
                this.removeAugmentedOperationalData((InstanceIdentifier<? extends DataObject>)nodeGroupDescStatsAugmentation);
                InstanceIdentifier nodeGroupStatisticsAugmentation = (InstanceIdentifier)InstanceIdentifier.builder((InstanceIdentifier)groupII).augmentation(NodeGroupStatistics.class).toInstance();
                this.removeAugmentedOperationalData((InstanceIdentifier<? extends DataObject>)nodeGroupStatisticsAugmentation);
            }
            if (!(dataObject instanceof Queue)) continue;
            InstanceIdentifier queueII = dataObjectInstance;
            InstanceIdentifier nodeConnectorQueueStatisticsDataAugmentation = (InstanceIdentifier)InstanceIdentifier.builder((InstanceIdentifier)queueII).augmentation(FlowCapableNodeConnectorQueueStatisticsData.class).toInstance();
            this.removeAugmentedOperationalData((InstanceIdentifier<? extends DataObject>)nodeConnectorQueueStatisticsDataAugmentation);
        }
    }

    private void removeAugmentedOperationalData(InstanceIdentifier<? extends DataObject> dataObjectInstance) {
        if (dataObjectInstance != null) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            it.removeOperationalData(dataObjectInstance);
            it.commit();
        }
    }
}

