/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.statistics.manager;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.md.statistics.manager.MultipartMessageManager;
import org.opendaylight.controller.md.statistics.manager.NodeStatisticsAger;
import org.opendaylight.controller.md.statistics.manager.StatisticsProvider;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.FlowKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.AggregateFlowStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowsStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.aggregate.flow.statistics.AggregateFlowStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.and.statistics.map.list.FlowAndStatisticsMapListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.flow.statistics.FlowStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.FlowTableStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.and.statistics.map.FlowTableAndStatisticsMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.statistics.FlowTableStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.QueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.QueueKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupDescStatsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupFeaturesUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GroupStatisticsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupDescStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.desc.GroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.features.GroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.statistics.GroupStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.desc.stats.reply.GroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.statistics.reply.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.GroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.GroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterConfigStatsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterFeaturesUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.MeterStatisticsUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterConfigStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.MeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterConfigStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.config.stats.reply.MeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.reply.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.layer._3.match.Ipv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.FlowCapableNodeConnectorStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.FlowCapableNodeConnectorStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.NodeConnectorStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.flow.capable.node.connector.statistics.FlowCapableNodeConnectorStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.node.connector.statistics.and.port.number.map.NodeConnectorStatisticsAndPortNumberMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.FlowCapableNodeConnectorQueueStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.FlowCapableNodeConnectorQueueStatisticsDataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.QueueStatisticsUpdate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.flow.capable.node.connector.queue.statistics.FlowCapableNodeConnectorQueueStatisticsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.queue.id.and.statistics.map.QueueIdAndStatisticsMap;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsUpdateCommiter
implements OpendaylightGroupStatisticsListener,
OpendaylightMeterStatisticsListener,
OpendaylightFlowStatisticsListener,
OpendaylightPortStatisticsListener,
OpendaylightFlowTableStatisticsListener,
OpendaylightQueueStatisticsListener {
    public static final Logger sucLogger = LoggerFactory.getLogger(StatisticsUpdateCommiter.class);
    private final StatisticsProvider statisticsManager;
    private final MultipartMessageManager messageManager;
    private int unaccountedFlowsCounter = 1;

    public StatisticsUpdateCommiter(StatisticsProvider manager) {
        this.statisticsManager = manager;
        this.messageManager = this.statisticsManager.getMultipartMessageManager();
    }

    public StatisticsProvider getStatisticsManager() {
        return this.statisticsManager;
    }

    public void onMeterConfigStatsUpdated(MeterConfigStatsUpdated notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        ConcurrentMap<NodeId, NodeStatisticsAger> cache = this.statisticsManager.getStatisticsCache();
        if (!cache.containsKey(notification.getId())) {
            cache.put(notification.getId(), new NodeStatisticsAger(this.statisticsManager, key));
        }
        ((NodeStatisticsAger)cache.get(notification.getId())).updateMeterConfigStats(notification.getMeterConfigStats());
        List meterConfigStatsList = notification.getMeterConfigStats();
        for (MeterConfigStats meterConfigStats : meterConfigStatsList) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            MeterBuilder meterBuilder = new MeterBuilder();
            MeterKey meterKey = new MeterKey(meterConfigStats.getMeterId());
            meterBuilder.setKey(meterKey);
            InstanceIdentifier meterRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Meter.class, (Identifier)meterKey).toInstance();
            NodeMeterConfigStatsBuilder meterConfig = new NodeMeterConfigStatsBuilder();
            MeterConfigStatsBuilder stats = new MeterConfigStatsBuilder();
            stats.fieldsFrom((DataObject)meterConfigStats);
            meterConfig.setMeterConfigStats(stats.build());
            meterBuilder.addAugmentation(NodeMeterConfigStats.class, (Augmentation)meterConfig.build());
            it.putOperationalData((Object)meterRef, (Object)meterBuilder.build());
            it.commit();
        }
    }

    public void onMeterStatisticsUpdated(MeterStatisticsUpdated notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        List meterStatsList = notification.getMeterStats();
        for (MeterStats meterStats : meterStatsList) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            MeterBuilder meterBuilder = new MeterBuilder();
            MeterKey meterKey = new MeterKey(meterStats.getMeterId());
            meterBuilder.setKey(meterKey);
            InstanceIdentifier meterRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Meter.class, (Identifier)meterKey).toInstance();
            NodeMeterStatisticsBuilder meterStatsBuilder = new NodeMeterStatisticsBuilder();
            MeterStatisticsBuilder stats = new MeterStatisticsBuilder();
            stats.fieldsFrom((DataObject)meterStats);
            meterStatsBuilder.setMeterStatistics(stats.build());
            meterBuilder.addAugmentation(NodeMeterStatistics.class, (Augmentation)meterStatsBuilder.build());
            it.putOperationalData((Object)meterRef, (Object)meterBuilder.build());
            it.commit();
        }
    }

    public void onGroupDescStatsUpdated(GroupDescStatsUpdated notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        ConcurrentMap<NodeId, NodeStatisticsAger> cache = this.statisticsManager.getStatisticsCache();
        if (!cache.containsKey(notification.getId())) {
            cache.put(notification.getId(), new NodeStatisticsAger(this.statisticsManager, key));
        }
        ((NodeStatisticsAger)cache.get(notification.getId())).updateGroupDescStats(notification.getGroupDescStats());
        List groupDescStatsList = notification.getGroupDescStats();
        for (GroupDescStats groupDescStats : groupDescStatsList) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            GroupBuilder groupBuilder = new GroupBuilder();
            GroupKey groupKey = new GroupKey(groupDescStats.getGroupId());
            groupBuilder.setKey(groupKey);
            InstanceIdentifier groupRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Group.class, (Identifier)groupKey).toInstance();
            NodeGroupDescStatsBuilder groupDesc = new NodeGroupDescStatsBuilder();
            GroupDescBuilder stats = new GroupDescBuilder();
            stats.fieldsFrom((DataObject)groupDescStats);
            groupDesc.setGroupDesc(stats.build());
            groupBuilder.addAugmentation(NodeGroupDescStats.class, (Augmentation)groupDesc.build());
            it.putOperationalData((Object)groupRef, (Object)groupBuilder.build());
            it.commit();
        }
    }

    public void onGroupStatisticsUpdated(GroupStatisticsUpdated notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        List groupStatsList = notification.getGroupStats();
        for (GroupStats groupStats : groupStatsList) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            GroupBuilder groupBuilder = new GroupBuilder();
            GroupKey groupKey = new GroupKey(groupStats.getGroupId());
            groupBuilder.setKey(groupKey);
            InstanceIdentifier groupRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Group.class, (Identifier)groupKey).toInstance();
            NodeGroupStatisticsBuilder groupStatisticsBuilder = new NodeGroupStatisticsBuilder();
            GroupStatisticsBuilder stats = new GroupStatisticsBuilder();
            stats.fieldsFrom((DataObject)groupStats);
            groupStatisticsBuilder.setGroupStatistics(stats.build());
            groupBuilder.addAugmentation(NodeGroupStatistics.class, (Augmentation)groupStatisticsBuilder.build());
            it.putOperationalData((Object)groupRef, (Object)groupBuilder.build());
            it.commit();
        }
    }

    public void onMeterFeaturesUpdated(MeterFeaturesUpdated notification) {
        MeterFeaturesBuilder meterFeature = new MeterFeaturesBuilder();
        meterFeature.setMeterBandSupported(notification.getMeterBandSupported());
        meterFeature.setMeterCapabilitiesSupported(notification.getMeterCapabilitiesSupported());
        meterFeature.setMaxBands(notification.getMaxBands());
        meterFeature.setMaxColor(notification.getMaxColor());
        meterFeature.setMaxMeter(notification.getMaxMeter());
        DataModificationTransaction it = this.statisticsManager.startChange();
        NodeKey key = new NodeKey(notification.getId());
        NodeRef ref = this.getNodeRef(key);
        NodeBuilder nodeData = new NodeBuilder();
        nodeData.setKey(key);
        NodeMeterFeaturesBuilder nodeMeterFeatures = new NodeMeterFeaturesBuilder();
        nodeMeterFeatures.setMeterFeatures(meterFeature.build());
        nodeData.addAugmentation(NodeMeterFeatures.class, (Augmentation)nodeMeterFeatures.build());
        InstanceIdentifier refValue = ref.getValue();
        it.putOperationalData((Object)refValue, (Object)nodeData.build());
        it.commit();
    }

    public void onGroupFeaturesUpdated(GroupFeaturesUpdated notification) {
        GroupFeaturesBuilder groupFeatures = new GroupFeaturesBuilder();
        groupFeatures.setActions(notification.getActions());
        groupFeatures.setGroupCapabilitiesSupported(notification.getGroupCapabilitiesSupported());
        groupFeatures.setGroupTypesSupported(notification.getGroupTypesSupported());
        groupFeatures.setMaxGroups(notification.getMaxGroups());
        DataModificationTransaction it = this.statisticsManager.startChange();
        NodeKey key = new NodeKey(notification.getId());
        NodeRef ref = this.getNodeRef(key);
        NodeBuilder nodeData = new NodeBuilder();
        nodeData.setKey(key);
        NodeGroupFeaturesBuilder nodeGroupFeatures = new NodeGroupFeaturesBuilder();
        nodeGroupFeatures.setGroupFeatures(groupFeatures.build());
        nodeData.addAugmentation(NodeGroupFeatures.class, (Augmentation)nodeGroupFeatures.build());
        InstanceIdentifier refValue = ref.getValue();
        it.putOperationalData((Object)refValue, (Object)nodeData.build());
        it.commit();
    }

    public void onFlowsStatisticsUpdate(FlowsStatisticsUpdate notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        sucLogger.debug("Received flow stats update : {}", (Object)notification.toString());
        for (FlowAndStatisticsMapList map : notification.getFlowAndStatisticsMapList()) {
            NodeStatisticsAger nsa;
            short tableId = map.getTableId();
            DataModificationTransaction it = this.statisticsManager.startChange();
            boolean foundOriginalFlow = false;
            FlowBuilder flowBuilder = new FlowBuilder();
            FlowStatisticsDataBuilder flowStatisticsData = new FlowStatisticsDataBuilder();
            FlowBuilder flow = new FlowBuilder();
            flow.setContainerName(map.getContainerName());
            flow.setBufferId(map.getBufferId());
            flow.setCookie(map.getCookie());
            flow.setCookieMask(map.getCookieMask());
            flow.setFlags(map.getFlags());
            flow.setFlowName(map.getFlowName());
            flow.setHardTimeout(map.getHardTimeout());
            if (map.getFlowId() != null) {
                flow.setId(new FlowId(map.getFlowId().getValue()));
            }
            flow.setIdleTimeout(map.getIdleTimeout());
            flow.setInstallHw(map.isInstallHw());
            flow.setInstructions(map.getInstructions());
            if (map.getFlowId() != null) {
                flow.setKey(new FlowKey(new FlowId(map.getKey().getFlowId().getValue())));
            }
            flow.setMatch(map.getMatch());
            flow.setOutGroup(map.getOutGroup());
            flow.setOutPort(map.getOutPort());
            flow.setPriority(map.getPriority());
            flow.setStrict(map.isStrict());
            flow.setTableId(Short.valueOf(tableId));
            Flow flowRule = flow.build();
            FlowAndStatisticsMapListBuilder stats = new FlowAndStatisticsMapListBuilder();
            stats.setByteCount(map.getByteCount());
            stats.setPacketCount(map.getPacketCount());
            stats.setDuration(map.getDuration());
            FlowAndStatisticsMapList flowStats = stats.build();
            ConcurrentMap<NodeId, NodeStatisticsAger> cache = this.statisticsManager.getStatisticsCache();
            if (!cache.containsKey(notification.getId())) {
                cache.put(notification.getId(), new NodeStatisticsAger(this.statisticsManager, key));
            }
            NodeStatisticsAger nodeStatisticsAger = nsa = (NodeStatisticsAger)cache.get(notification.getId());
            nodeStatisticsAger.getClass();
            NodeStatisticsAger.FlowEntry flowStatsEntry = nodeStatisticsAger.new NodeStatisticsAger.FlowEntry(tableId, flowRule);
            ((NodeStatisticsAger)cache.get(notification.getId())).updateFlowStats(flowStatsEntry);
            FlowStatisticsBuilder flowStatistics = new FlowStatisticsBuilder();
            flowStatistics.setByteCount(flowStats.getByteCount());
            flowStatistics.setPacketCount(flowStats.getPacketCount());
            flowStatistics.setDuration(flowStats.getDuration());
            flowStatistics.setContainerName(map.getContainerName());
            flowStatistics.setBufferId(map.getBufferId());
            flowStatistics.setCookie(map.getCookie());
            flowStatistics.setCookieMask(map.getCookieMask());
            flowStatistics.setFlags(map.getFlags());
            flowStatistics.setFlowName(map.getFlowName());
            flowStatistics.setHardTimeout(map.getHardTimeout());
            flowStatistics.setIdleTimeout(map.getIdleTimeout());
            flowStatistics.setInstallHw(map.isInstallHw());
            flowStatistics.setInstructions(map.getInstructions());
            flowStatistics.setMatch(map.getMatch());
            flowStatistics.setOutGroup(map.getOutGroup());
            flowStatistics.setOutPort(map.getOutPort());
            flowStatistics.setPriority(map.getPriority());
            flowStatistics.setStrict(map.isStrict());
            flowStatistics.setTableId(Short.valueOf(tableId));
            flowStatisticsData.setFlowStatistics(flowStatistics.build());
            sucLogger.debug("Flow : {}", (Object)flowRule.toString());
            sucLogger.debug("Statistics to augment : {}", (Object)flowStatistics.build().toString());
            InstanceIdentifier tableRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(Short.valueOf(tableId))).toInstance();
            Table table = (Table)it.readConfigurationData((Object)tableRef);
            if (table != null) {
                for (Flow existingFlow : table.getFlow()) {
                    sucLogger.debug("Existing flow in data store : {}", (Object)existingFlow.toString());
                    if (!this.flowEquals(flowRule, existingFlow)) continue;
                    it = this.statisticsManager.startChange();
                    InstanceIdentifier flowRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(Short.valueOf(tableId))).child(Flow.class, (Identifier)existingFlow.getKey()).toInstance();
                    flowBuilder.setKey(existingFlow.getKey());
                    flowBuilder.addAugmentation(FlowStatisticsData.class, (Augmentation)flowStatisticsData.build());
                    sucLogger.debug("Found matching flow in the datastore, augmenting statistics");
                    foundOriginalFlow = true;
                    it.putOperationalData((Object)flowRef, (Object)flowBuilder.build());
                    it.commit();
                }
            }
            table = (Table)it.readOperationalData((Object)tableRef);
            if (!foundOriginalFlow && table != null) {
                for (Flow existingFlow : table.getFlow()) {
                    FlowStatisticsData augmentedflowStatisticsData = (FlowStatisticsData)existingFlow.getAugmentation(FlowStatisticsData.class);
                    if (augmentedflowStatisticsData == null) continue;
                    FlowBuilder existingOperationalFlow = new FlowBuilder();
                    existingOperationalFlow.fieldsFrom((DataObject)augmentedflowStatisticsData.getFlowStatistics());
                    sucLogger.debug("Existing unaccounted flow in operational data store : {}", (Object)existingFlow.toString());
                    if (!this.flowEquals(flowRule, existingOperationalFlow.build())) continue;
                    InstanceIdentifier flowRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(Short.valueOf(tableId))).child(Flow.class, (Identifier)existingFlow.getKey()).toInstance();
                    flowBuilder.setKey(existingFlow.getKey());
                    flowBuilder.addAugmentation(FlowStatisticsData.class, (Augmentation)flowStatisticsData.build());
                    sucLogger.debug("Found matching unaccounted flow in the operational datastore, augmenting statistics");
                    foundOriginalFlow = true;
                    it.putOperationalData((Object)flowRef, (Object)flowBuilder.build());
                    it.commit();
                    break;
                }
            }
            if (foundOriginalFlow) continue;
            long flowKey = Long.parseLong(new String("1" + Short.toString(tableId) + "0" + Integer.toString(this.unaccountedFlowsCounter)));
            ++this.unaccountedFlowsCounter;
            FlowKey newFlowKey = new FlowKey(new FlowId(Long.toString(flowKey)));
            InstanceIdentifier flowRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(Short.valueOf(tableId))).child(Flow.class, (Identifier)newFlowKey).toInstance();
            flowBuilder.setKey(newFlowKey);
            flowBuilder.addAugmentation(FlowStatisticsData.class, (Augmentation)flowStatisticsData.build());
            sucLogger.debug("Flow {} is not present in config data store, augmenting statistics as an unaccounted flow", (Object)flowBuilder.build());
            it.putOperationalData((Object)flowRef, (Object)flowBuilder.build());
            it.commit();
        }
    }

    public void onAggregateFlowStatisticsUpdate(AggregateFlowStatisticsUpdate notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        Short tableId = this.messageManager.getTableIdForTxId(notification.getId(), notification.getTransactionId());
        if (tableId != null) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            InstanceIdentifier tableRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(tableId)).toInstance();
            AggregateFlowStatisticsDataBuilder aggregateFlowStatisticsDataBuilder = new AggregateFlowStatisticsDataBuilder();
            AggregateFlowStatisticsBuilder aggregateFlowStatisticsBuilder = new AggregateFlowStatisticsBuilder();
            aggregateFlowStatisticsBuilder.setByteCount(notification.getByteCount());
            aggregateFlowStatisticsBuilder.setFlowCount(notification.getFlowCount());
            aggregateFlowStatisticsBuilder.setPacketCount(notification.getPacketCount());
            aggregateFlowStatisticsDataBuilder.setAggregateFlowStatistics(aggregateFlowStatisticsBuilder.build());
            sucLogger.debug("Augment aggregate statistics: {} for table {} on Node {}", new Object[]{aggregateFlowStatisticsBuilder.build().toString(), tableId, key});
            TableBuilder tableBuilder = new TableBuilder();
            tableBuilder.setKey(new TableKey(tableId));
            tableBuilder.addAugmentation(AggregateFlowStatisticsData.class, (Augmentation)aggregateFlowStatisticsDataBuilder.build());
            it.putOperationalData((Object)tableRef, (Object)tableBuilder.build());
            it.commit();
        }
    }

    public void onNodeConnectorStatisticsUpdate(NodeConnectorStatisticsUpdate notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        List portsStats = notification.getNodeConnectorStatisticsAndPortNumberMap();
        for (NodeConnectorStatisticsAndPortNumberMap portStats : portsStats) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            FlowCapableNodeConnectorStatisticsBuilder statisticsBuilder = new FlowCapableNodeConnectorStatisticsBuilder();
            statisticsBuilder.setBytes(portStats.getBytes());
            statisticsBuilder.setCollisionCount(portStats.getCollisionCount());
            statisticsBuilder.setDuration(portStats.getDuration());
            statisticsBuilder.setPackets(portStats.getPackets());
            statisticsBuilder.setReceiveCrcError(portStats.getReceiveCrcError());
            statisticsBuilder.setReceiveDrops(portStats.getReceiveDrops());
            statisticsBuilder.setReceiveErrors(portStats.getReceiveErrors());
            statisticsBuilder.setReceiveFrameError(portStats.getReceiveFrameError());
            statisticsBuilder.setReceiveOverRunError(portStats.getReceiveOverRunError());
            statisticsBuilder.setTransmitDrops(portStats.getTransmitDrops());
            statisticsBuilder.setTransmitErrors(portStats.getTransmitErrors());
            FlowCapableNodeConnectorStatisticsDataBuilder statisticsDataBuilder = new FlowCapableNodeConnectorStatisticsDataBuilder();
            statisticsDataBuilder.setFlowCapableNodeConnectorStatistics(statisticsBuilder.build());
            InstanceIdentifier nodeConnectorRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).child(NodeConnector.class, (Identifier)new NodeConnectorKey(portStats.getNodeConnectorId())).toInstance();
            NodeConnector nodeConnector = (NodeConnector)it.readOperationalData((Object)nodeConnectorRef);
            if (nodeConnector == null) continue;
            sucLogger.debug("Augmenting port statistics {} to port {}", (Object)statisticsDataBuilder.build().toString(), (Object)nodeConnectorRef.toString());
            NodeConnectorBuilder nodeConnectorBuilder = new NodeConnectorBuilder();
            nodeConnectorBuilder.addAugmentation(FlowCapableNodeConnectorStatisticsData.class, (Augmentation)statisticsDataBuilder.build());
            it.putOperationalData((Object)nodeConnectorRef, (Object)nodeConnectorBuilder.build());
            it.commit();
        }
    }

    public void onFlowTableStatisticsUpdate(FlowTableStatisticsUpdate notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        List flowTablesStatsList = notification.getFlowTableAndStatisticsMap();
        for (FlowTableAndStatisticsMap ftStats : flowTablesStatsList) {
            DataModificationTransaction it = this.statisticsManager.startChange();
            InstanceIdentifier tableRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(ftStats.getTableId().getValue())).toInstance();
            FlowTableStatisticsDataBuilder statisticsDataBuilder = new FlowTableStatisticsDataBuilder();
            FlowTableStatisticsBuilder statisticsBuilder = new FlowTableStatisticsBuilder();
            statisticsBuilder.setActiveFlows(ftStats.getActiveFlows());
            statisticsBuilder.setPacketsLookedUp(ftStats.getPacketsLookedUp());
            statisticsBuilder.setPacketsMatched(ftStats.getPacketsMatched());
            statisticsDataBuilder.setFlowTableStatistics(statisticsBuilder.build());
            sucLogger.debug("Augment flow table statistics: {} for table {} on Node {}", new Object[]{statisticsBuilder.build().toString(), ftStats.getTableId(), key});
            TableBuilder tableBuilder = new TableBuilder();
            tableBuilder.setKey(new TableKey(ftStats.getTableId().getValue()));
            tableBuilder.addAugmentation(FlowTableStatisticsData.class, (Augmentation)statisticsDataBuilder.build());
            it.putOperationalData((Object)tableRef, (Object)tableBuilder.build());
            it.commit();
        }
    }

    public void onQueueStatisticsUpdate(QueueStatisticsUpdate notification) {
        if (!this.messageManager.isRequestTxIdExist(notification.getId(), notification.getTransactionId(), notification.isMoreReplies())) {
            return;
        }
        NodeKey key = new NodeKey(notification.getId());
        ConcurrentMap<NodeId, NodeStatisticsAger> cache = this.statisticsManager.getStatisticsCache();
        if (!cache.containsKey(notification.getId())) {
            cache.put(notification.getId(), new NodeStatisticsAger(this.statisticsManager, key));
        }
        NodeStatisticsAger nsa = (NodeStatisticsAger)cache.get(notification.getId());
        List queuesStats = notification.getQueueIdAndStatisticsMap();
        for (QueueIdAndStatisticsMap swQueueStats : queuesStats) {
            NodeStatisticsAger nodeStatisticsAger = nsa;
            nodeStatisticsAger.getClass();
            NodeStatisticsAger.QueueEntry queueEntry = nodeStatisticsAger.new NodeStatisticsAger.QueueEntry(swQueueStats.getNodeConnectorId(), swQueueStats.getQueueId());
            nsa.updateQueueStats(queueEntry);
            FlowCapableNodeConnectorQueueStatisticsDataBuilder queueStatisticsDataBuilder = new FlowCapableNodeConnectorQueueStatisticsDataBuilder();
            FlowCapableNodeConnectorQueueStatisticsBuilder queueStatisticsBuilder = new FlowCapableNodeConnectorQueueStatisticsBuilder();
            queueStatisticsBuilder.fieldsFrom((DataObject)swQueueStats);
            queueStatisticsDataBuilder.setFlowCapableNodeConnectorQueueStatistics(queueStatisticsBuilder.build());
            DataModificationTransaction it = this.statisticsManager.startChange();
            InstanceIdentifier queueRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)key).child(NodeConnector.class, (Identifier)new NodeConnectorKey(swQueueStats.getNodeConnectorId())).augmentation(FlowCapableNodeConnector.class).child(Queue.class, (Identifier)new QueueKey(swQueueStats.getQueueId())).toInstance();
            QueueBuilder queueBuilder = new QueueBuilder();
            queueBuilder.addAugmentation(FlowCapableNodeConnectorQueueStatisticsData.class, (Augmentation)queueStatisticsDataBuilder.build());
            queueBuilder.setKey(new QueueKey(swQueueStats.getQueueId()));
            sucLogger.debug("Augmenting queue statistics {} of queue {} to port {}", new Object[]{queueStatisticsDataBuilder.build().toString(), swQueueStats.getQueueId(), swQueueStats.getNodeConnectorId()});
            it.putOperationalData((Object)queueRef, (Object)queueBuilder.build());
            it.commit();
        }
    }

    private NodeRef getNodeRef(NodeKey nodeKey) {
        InstanceIdentifier.InstanceIdentifierBuilder builder = InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)nodeKey);
        return new NodeRef((InstanceIdentifier)builder.toInstance());
    }

    public boolean flowEquals(Flow statsFlow, Flow storedFlow) {
        if (statsFlow.getClass() != storedFlow.getClass()) {
            return false;
        }
        if (statsFlow.getContainerName() == null ? storedFlow.getContainerName() != null : !statsFlow.getContainerName().equals(storedFlow.getContainerName())) {
            return false;
        }
        if (statsFlow.getMatch() == null ? storedFlow.getMatch() != null : !this.matchEquals(statsFlow.getMatch(), storedFlow.getMatch())) {
            return false;
        }
        if (storedFlow.getPriority() == null ? statsFlow.getPriority() != null && statsFlow.getPriority() != 32768 : !statsFlow.getPriority().equals(storedFlow.getPriority())) {
            return false;
        }
        return !(statsFlow.getTableId() == null ? storedFlow.getTableId() != null : !statsFlow.getTableId().equals(storedFlow.getTableId()));
    }

    public boolean matchEquals(Match statsFlow, Match storedFlow) {
        if (statsFlow == storedFlow) {
            return true;
        }
        if (storedFlow.getClass() != statsFlow.getClass()) {
            return false;
        }
        if (storedFlow.getEthernetMatch() == null ? statsFlow.getEthernetMatch() != null : !storedFlow.getEthernetMatch().equals(statsFlow.getEthernetMatch())) {
            return false;
        }
        if (storedFlow.getIcmpv4Match() == null ? statsFlow.getIcmpv4Match() != null : !storedFlow.getIcmpv4Match().equals(statsFlow.getIcmpv4Match())) {
            return false;
        }
        if (storedFlow.getIcmpv6Match() == null ? statsFlow.getIcmpv6Match() != null : !storedFlow.getIcmpv6Match().equals(statsFlow.getIcmpv6Match())) {
            return false;
        }
        if (storedFlow.getInPhyPort() == null ? statsFlow.getInPhyPort() != null : !storedFlow.getInPhyPort().equals((Object)statsFlow.getInPhyPort())) {
            return false;
        }
        if (storedFlow.getInPort() == null ? statsFlow.getInPort() != null : !storedFlow.getInPort().equals((Object)statsFlow.getInPort())) {
            return false;
        }
        if (storedFlow.getIpMatch() == null ? statsFlow.getIpMatch() != null : !storedFlow.getIpMatch().equals(statsFlow.getIpMatch())) {
            return false;
        }
        if (storedFlow.getLayer3Match() == null ? statsFlow.getLayer3Match() != null : !this.layer3MatchEquals(statsFlow.getLayer3Match(), storedFlow.getLayer3Match())) {
            return false;
        }
        if (storedFlow.getLayer4Match() == null ? statsFlow.getLayer4Match() != null : !storedFlow.getLayer4Match().equals(statsFlow.getLayer4Match())) {
            return false;
        }
        if (storedFlow.getMetadata() == null ? statsFlow.getMetadata() != null : !storedFlow.getMetadata().equals(statsFlow.getMetadata())) {
            return false;
        }
        if (storedFlow.getProtocolMatchFields() == null ? statsFlow.getProtocolMatchFields() != null : !storedFlow.getProtocolMatchFields().equals(statsFlow.getProtocolMatchFields())) {
            return false;
        }
        if (storedFlow.getTunnel() == null ? statsFlow.getTunnel() != null : !storedFlow.getTunnel().equals(statsFlow.getTunnel())) {
            return false;
        }
        return !(storedFlow.getVlanMatch() == null ? statsFlow.getVlanMatch() != null : !storedFlow.getVlanMatch().equals(statsFlow.getVlanMatch()));
    }

    private boolean layer3MatchEquals(Layer3Match statsLayer3Match, Layer3Match storedLayer3Match) {
        if (statsLayer3Match instanceof Ipv4Match && storedLayer3Match instanceof Ipv4Match) {
            Ipv4Match statsIpv4Match = (Ipv4Match)statsLayer3Match;
            Ipv4Match storedIpv4Match = (Ipv4Match)storedLayer3Match;
            if (storedIpv4Match.getIpv4Destination() == null ? statsIpv4Match.getIpv4Destination() != null : !this.IpAddressEquals(statsIpv4Match.getIpv4Destination(), storedIpv4Match.getIpv4Destination())) {
                return false;
            }
            return !(storedIpv4Match.getIpv4Source() == null ? statsIpv4Match.getIpv4Source() != null : !this.IpAddressEquals(statsIpv4Match.getIpv4Source(), storedIpv4Match.getIpv4Source()));
        }
        return storedLayer3Match.equals(statsLayer3Match);
    }

    private boolean IpAddressEquals(Ipv4Prefix statsIpAddress, Ipv4Prefix storedIpAddress) {
        IntegerIpAddress storedIpAddressInt;
        IntegerIpAddress statsIpAddressInt = this.StrIpToIntIp(statsIpAddress.getValue());
        if (this.IpAndMaskBasedMatch(statsIpAddressInt, storedIpAddressInt = this.StrIpToIntIp(storedIpAddress.getValue()))) {
            return true;
        }
        return this.IpBasedMatch(statsIpAddressInt, storedIpAddressInt);
    }

    private boolean IpAndMaskBasedMatch(IntegerIpAddress statsIpAddressInt, IntegerIpAddress storedIpAddressInt) {
        return (statsIpAddressInt.getIp() & statsIpAddressInt.getMask()) == (storedIpAddressInt.getIp() & storedIpAddressInt.getMask());
    }

    private boolean IpBasedMatch(IntegerIpAddress statsIpAddressInt, IntegerIpAddress storedIpAddressInt) {
        return statsIpAddressInt.getIp() == storedIpAddressInt.getIp();
    }

    private IntegerIpAddress StrIpToIntIp(String ipAddresss) {
        String[] parts = ipAddresss.split("/");
        String ip = parts[0];
        int prefix = parts.length < 2 ? 32 : Integer.parseInt(parts[1]);
        Inet4Address addr = null;
        try {
            addr = (Inet4Address)InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        byte[] addrBytes = addr.getAddress();
        int ipInt = (addrBytes[0] & 0xFF) << 24 | (addrBytes[1] & 0xFF) << 16 | (addrBytes[2] & 0xFF) << 8 | (addrBytes[3] & 0xFF) << 0;
        int mask = -1 << 32 - prefix;
        return new IntegerIpAddress(ipInt, mask);
    }

    class IntegerIpAddress {
        int ip;
        int mask;

        public IntegerIpAddress(int ip, int mask) {
            this.ip = ip;
            this.mask = mask;
        }

        public int getIp() {
            return this.ip;
        }

        public int getMask() {
            return this.mask;
        }
    }
}

