/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.statistics.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.controller.md.statistics.manager.MultipartMessageManager;
import org.opendaylight.controller.md.statistics.manager.NodeStatisticsAger;
import org.opendaylight.controller.md.statistics.manager.StatisticsManagerActivator;
import org.opendaylight.controller.md.statistics.manager.StatisticsUpdateCommiter;
import org.opendaylight.controller.md.statistics.manager.StatisticsUpdateHandler;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataChangeListener;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetAllFlowsStatisticsFromAllFlowTablesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.GetFlowStatisticsFromFlowTableOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.OpendaylightFlowStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.GetFlowTablesStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.OpendaylightFlowTableStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetAllGroupStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.GetGroupDescriptionOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.OpendaylightGroupStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterConfigStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.GetAllMeterStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.OpendaylightMeterStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.GetAllNodeConnectorsStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.OpendaylightPortStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetAllQueuesStatisticsFromAllPortsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetQueueStatisticsFromGivenPortInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.GetQueueStatisticsFromGivenPortOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.OpendaylightQueueStatisticsService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.table.types.rev131026.TableId;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsProvider
implements AutoCloseable {
    public static final Logger spLogger = LoggerFactory.getLogger(StatisticsProvider.class);
    private DataProviderService dps;
    private DataBrokerService dbs;
    private NotificationProviderService nps;
    private OpendaylightGroupStatisticsService groupStatsService;
    private OpendaylightMeterStatisticsService meterStatsService;
    private OpendaylightFlowStatisticsService flowStatsService;
    private OpendaylightPortStatisticsService portStatsService;
    private OpendaylightFlowTableStatisticsService flowTableStatsService;
    private OpendaylightQueueStatisticsService queueStatsService;
    private final MultipartMessageManager multipartMessageManager = new MultipartMessageManager();
    private StatisticsUpdateHandler statsUpdateHandler;
    private Thread statisticsRequesterThread;
    private Thread statisticsAgerThread;
    private final InstanceIdentifier<Nodes> nodesIdentifier = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).toInstance();
    public static final int STATS_THREAD_EXECUTION_TIME = 15000;
    private final ConcurrentMap<NodeId, NodeStatisticsAger> statisticsCache = new ConcurrentHashMap<NodeId, NodeStatisticsAger>();
    private final StatisticsUpdateCommiter updateCommiter = new StatisticsUpdateCommiter(this);
    private Registration<NotificationListener> listenerRegistration;

    public DataProviderService getDataService() {
        return this.dps;
    }

    public void setDataService(DataProviderService dataService) {
        this.dps = dataService;
    }

    public DataBrokerService getDataBrokerService() {
        return this.dbs;
    }

    public void setDataBrokerService(DataBrokerService dataBrokerService) {
        this.dbs = dataBrokerService;
    }

    public NotificationProviderService getNotificationService() {
        return this.nps;
    }

    public void setNotificationService(NotificationProviderService notificationService) {
        this.nps = notificationService;
    }

    public MultipartMessageManager getMultipartMessageManager() {
        return this.multipartMessageManager;
    }

    public void start() {
        Registration registerNotificationListener;
        NotificationProviderService nps = this.getNotificationService();
        this.listenerRegistration = registerNotificationListener = nps.registerNotificationListener((NotificationListener)this.updateCommiter);
        this.statsUpdateHandler = new StatisticsUpdateHandler(this);
        this.registerDataStoreUpdateListener(this.getDataBrokerService());
        this.groupStatsService = (OpendaylightGroupStatisticsService)StatisticsManagerActivator.getProviderContext().getRpcService(OpendaylightGroupStatisticsService.class);
        this.meterStatsService = (OpendaylightMeterStatisticsService)StatisticsManagerActivator.getProviderContext().getRpcService(OpendaylightMeterStatisticsService.class);
        this.flowStatsService = (OpendaylightFlowStatisticsService)StatisticsManagerActivator.getProviderContext().getRpcService(OpendaylightFlowStatisticsService.class);
        this.portStatsService = (OpendaylightPortStatisticsService)StatisticsManagerActivator.getProviderContext().getRpcService(OpendaylightPortStatisticsService.class);
        this.flowTableStatsService = (OpendaylightFlowTableStatisticsService)StatisticsManagerActivator.getProviderContext().getRpcService(OpendaylightFlowTableStatisticsService.class);
        this.queueStatsService = (OpendaylightQueueStatisticsService)StatisticsManagerActivator.getProviderContext().getRpcService(OpendaylightQueueStatisticsService.class);
        this.statisticsRequesterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            StatisticsProvider.this.statsRequestSender();
                            Thread.sleep(15000L);
                        }
                    }
                    catch (Exception e) {
                        spLogger.error("Exception occurred while sending stats request : {}", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        spLogger.debug("Statistics requester thread started with timer interval : {}", (Object)15000);
        this.statisticsRequesterThread.start();
        this.statisticsAgerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            for (NodeStatisticsAger nodeStatisticsAger : StatisticsProvider.this.statisticsCache.values()) {
                                nodeStatisticsAger.cleanStaleStatistics();
                            }
                            StatisticsProvider.this.multipartMessageManager.cleanStaleTransactionIds();
                            Thread.sleep(15000L);
                        }
                    }
                    catch (Exception e) {
                        spLogger.error("Exception occurred while sending stats request : {}", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        spLogger.debug("Statistics ager thread started with timer interval : {}", (Object)15000);
        this.statisticsAgerThread.start();
        spLogger.info("Statistics Provider started.");
    }

    private void registerDataStoreUpdateListener(DataBrokerService dbs) {
        InstanceIdentifier pathNode = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class).toInstance();
        dbs.registerDataChangeListener(pathNode, (DataChangeListener)this.statsUpdateHandler);
        InstanceIdentifier pathFlow = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Table.class).child(Flow.class).toInstance();
        dbs.registerDataChangeListener(pathFlow, (DataChangeListener)this.statsUpdateHandler);
        InstanceIdentifier pathMeter = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Meter.class).toInstance();
        dbs.registerDataChangeListener(pathMeter, (DataChangeListener)this.statsUpdateHandler);
        InstanceIdentifier pathGroup = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class).augmentation(FlowCapableNode.class).child(Group.class).toInstance();
        dbs.registerDataChangeListener(pathGroup, (DataChangeListener)this.statsUpdateHandler);
        InstanceIdentifier pathQueue = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class).child(NodeConnector.class).augmentation(FlowCapableNodeConnector.class).child(Queue.class).toInstance();
        dbs.registerDataChangeListener(pathQueue, (DataChangeListener)this.statsUpdateHandler);
    }

    protected DataModificationTransaction startChange() {
        DataProviderService dps = this.getDataService();
        return dps.beginTransaction();
    }

    private void statsRequestSender() {
        List<Node> targetNodes = this.getAllConnectedNodes();
        if (targetNodes == null) {
            return;
        }
        for (Node targetNode : targetNodes) {
            if (targetNode.getAugmentation(FlowCapableNode.class) == null) continue;
            this.sendStatisticsRequestsToNode(targetNode);
        }
    }

    public void sendStatisticsRequestsToNode(Node targetNode) {
        spLogger.debug("Send requests for statistics collection to node : {})", (Object)targetNode.getId());
        InstanceIdentifier targetInstanceId = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)targetNode.getKey()).toInstance();
        NodeRef targetNodeRef = new NodeRef(targetInstanceId);
        try {
            if (this.flowStatsService != null) {
                this.sendAggregateFlowsStatsFromAllTablesRequest(targetNode.getKey());
                this.sendAllFlowsStatsFromAllTablesRequest(targetNodeRef);
            }
            if (this.flowTableStatsService != null) {
                this.sendAllFlowTablesStatisticsRequest(targetNodeRef);
            }
            if (this.portStatsService != null) {
                this.sendAllNodeConnectorsStatisticsRequest(targetNodeRef);
            }
            if (this.groupStatsService != null) {
                this.sendAllGroupStatisticsRequest(targetNodeRef);
                this.sendGroupDescriptionRequest(targetNodeRef);
            }
            if (this.meterStatsService != null) {
                this.sendAllMeterStatisticsRequest(targetNodeRef);
                this.sendMeterConfigStatisticsRequest(targetNodeRef);
            }
            if (this.queueStatsService != null) {
                this.sendAllQueueStatsFromAllNodeConnector(targetNodeRef);
            }
        }
        catch (Exception e) {
            spLogger.error("Exception occured while sending statistics requests : {}", (Throwable)e);
        }
    }

    public void sendAllFlowTablesStatisticsRequest(NodeRef targetNodeRef) throws InterruptedException, ExecutionException {
        GetFlowTablesStatisticsInputBuilder input = new GetFlowTablesStatisticsInputBuilder();
        input.setNode(targetNodeRef);
        Future response = this.flowTableStatsService.getFlowTablesStatistics(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNodeRef), ((GetFlowTablesStatisticsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_FLOW_TABLE);
    }

    public void sendAllFlowsStatsFromAllTablesRequest(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetAllFlowsStatisticsFromAllFlowTablesInputBuilder input = new GetAllFlowsStatisticsFromAllFlowTablesInputBuilder();
        input.setNode(targetNode);
        Future response = this.flowStatsService.getAllFlowsStatisticsFromAllFlowTables(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetAllFlowsStatisticsFromAllFlowTablesOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_FLOW);
    }

    public void sendFlowStatsFromTableRequest(NodeRef targetNode, Flow flow) throws InterruptedException, ExecutionException {
        GetFlowStatisticsFromFlowTableInputBuilder input = new GetFlowStatisticsFromFlowTableInputBuilder();
        input.setNode(targetNode);
        input.fieldsFrom((DataObject)flow);
        Future response = this.flowStatsService.getFlowStatisticsFromFlowTable(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetFlowStatisticsFromFlowTableOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_FLOW);
    }

    public void sendAggregateFlowsStatsFromAllTablesRequest(NodeKey targetNodeKey) throws InterruptedException, ExecutionException {
        List<Short> tablesId = this.getTablesFromNode(targetNodeKey);
        if (tablesId.size() != 0) {
            for (Short id : tablesId) {
                this.sendAggregateFlowsStatsFromTableRequest(targetNodeKey, id);
            }
        } else {
            spLogger.debug("No details found in data store for flow tables associated with Node {}", (Object)targetNodeKey);
        }
    }

    public void sendAggregateFlowsStatsFromTableRequest(NodeKey targetNodeKey, Short tableId) throws InterruptedException, ExecutionException {
        spLogger.debug("Send aggregate stats request for flow table {} to node {}", (Object)tableId, (Object)targetNodeKey);
        GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder input = new GetAggregateFlowStatisticsFromFlowTableForAllFlowsInputBuilder();
        input.setNode(new NodeRef((InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)targetNodeKey).toInstance()));
        input.setTableId(new TableId(tableId));
        Future response = this.flowStatsService.getAggregateFlowStatisticsFromFlowTableForAllFlows(input.build());
        this.multipartMessageManager.setTxIdAndTableIdMapEntry(targetNodeKey.getId(), ((GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), tableId);
        this.multipartMessageManager.addTxIdToRequestTypeEntry(targetNodeKey.getId(), ((GetAggregateFlowStatisticsFromFlowTableForAllFlowsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.AGGR_FLOW);
    }

    public void sendAllNodeConnectorsStatisticsRequest(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetAllNodeConnectorsStatisticsInputBuilder input = new GetAllNodeConnectorsStatisticsInputBuilder();
        input.setNode(targetNode);
        Future response = this.portStatsService.getAllNodeConnectorsStatistics(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetAllNodeConnectorsStatisticsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_PORT);
    }

    public void sendAllGroupStatisticsRequest(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetAllGroupStatisticsInputBuilder input = new GetAllGroupStatisticsInputBuilder();
        input.setNode(targetNode);
        Future response = this.groupStatsService.getAllGroupStatistics(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetAllGroupStatisticsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_GROUP);
    }

    public void sendGroupDescriptionRequest(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetGroupDescriptionInputBuilder input = new GetGroupDescriptionInputBuilder();
        input.setNode(targetNode);
        Future response = this.groupStatsService.getGroupDescription(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetGroupDescriptionOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.GROUP_DESC);
    }

    public void sendAllMeterStatisticsRequest(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetAllMeterStatisticsInputBuilder input = new GetAllMeterStatisticsInputBuilder();
        input.setNode(targetNode);
        Future response = this.meterStatsService.getAllMeterStatistics(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetAllMeterStatisticsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_METER);
    }

    public void sendMeterConfigStatisticsRequest(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetAllMeterConfigStatisticsInputBuilder input = new GetAllMeterConfigStatisticsInputBuilder();
        input.setNode(targetNode);
        Future response = this.meterStatsService.getAllMeterConfigStatistics(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetAllMeterConfigStatisticsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.METER_CONFIG);
    }

    public void sendAllQueueStatsFromAllNodeConnector(NodeRef targetNode) throws InterruptedException, ExecutionException {
        GetAllQueuesStatisticsFromAllPortsInputBuilder input = new GetAllQueuesStatisticsFromAllPortsInputBuilder();
        input.setNode(targetNode);
        Future response = this.queueStatsService.getAllQueuesStatisticsFromAllPorts(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetAllQueuesStatisticsFromAllPortsOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_QUEUE_STATS);
    }

    public void sendQueueStatsFromGivenNodeConnector(NodeRef targetNode, NodeConnectorId nodeConnectorId, QueueId queueId) throws InterruptedException, ExecutionException {
        GetQueueStatisticsFromGivenPortInputBuilder input = new GetQueueStatisticsFromGivenPortInputBuilder();
        input.setNode(targetNode);
        input.setNodeConnectorId(nodeConnectorId);
        input.setQueueId(queueId);
        Future response = this.queueStatsService.getQueueStatisticsFromGivenPort(input.build());
        this.multipartMessageManager.addTxIdToRequestTypeEntry(this.getNodeId(targetNode), ((GetQueueStatisticsFromGivenPortOutput)((RpcResult)response.get()).getResult()).getTransactionId(), MultipartMessageManager.StatsRequestType.ALL_QUEUE_STATS);
    }

    public ConcurrentMap<NodeId, NodeStatisticsAger> getStatisticsCache() {
        return this.statisticsCache;
    }

    private List<Node> getAllConnectedNodes() {
        Nodes nodes = (Nodes)this.dps.readOperationalData(this.nodesIdentifier);
        if (nodes == null) {
            return null;
        }
        spLogger.debug("Number of connected nodes : {}", (Object)nodes.getNode().size());
        return nodes.getNode();
    }

    private List<Short> getTablesFromNode(NodeKey nodeKey) {
        InstanceIdentifier nodesIdentifier = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)nodeKey).augmentation(FlowCapableNode.class).toInstance();
        FlowCapableNode node = (FlowCapableNode)this.dps.readOperationalData(nodesIdentifier);
        ArrayList<Short> tablesId = new ArrayList<Short>();
        if (node != null && node.getTable() != null) {
            spLogger.debug("Number of tables {} supported by node {}", (Object)node.getTable().size(), (Object)nodeKey);
            for (Table table : node.getTable()) {
                tablesId.add(table.getId());
            }
        }
        return tablesId;
    }

    private NodeId getNodeId(NodeRef nodeRef) {
        InstanceIdentifier nodeII = nodeRef.getValue();
        NodeKey nodeKey = (NodeKey)InstanceIdentifier.keyOf((InstanceIdentifier)nodeII);
        return nodeKey.getId();
    }

    @Override
    public void close() {
        try {
            spLogger.info("Statistics Provider stopped.");
            if (this.listenerRegistration != null) {
                this.listenerRegistration.close();
                this.statisticsRequesterThread.destroy();
                this.statisticsAgerThread.destroy();
            }
        }
        catch (Throwable e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

