/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.statistics.manager;

import org.opendaylight.controller.md.statistics.manager.StatisticsProvider;
import org.opendaylight.controller.sal.binding.api.AbstractBindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.osgi.framework.BundleContext;

public class StatisticsManagerActivator
extends AbstractBindingAwareProvider {
    private static BindingAwareBroker.ProviderContext pSession;
    private static StatisticsProvider statsProvider;

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        pSession = session;
        DataProviderService dps = (DataProviderService)session.getSALService(DataProviderService.class);
        statsProvider.setDataService(dps);
        DataBrokerService dbs = (DataBrokerService)session.getSALService(DataBrokerService.class);
        statsProvider.setDataBrokerService(dbs);
        NotificationProviderService nps = (NotificationProviderService)session.getSALService(NotificationProviderService.class);
        statsProvider.setNotificationService(nps);
        statsProvider.start();
    }

    protected void stopImpl(BundleContext context) {
        statsProvider.close();
    }

    public static BindingAwareBroker.ProviderContext getProviderContext() {
        return pSession;
    }

    static {
        statsProvider = new StatisticsProvider();
    }
}

