/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.statistics.manager;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.statistics.manager.StatisticsProvider;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.meters.MeterKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.TableKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.table.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.statistics.rev130819.FlowStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.QueueKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.NodeGroupStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.group.desc.stats.reply.GroupDescStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.GroupKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.NodeMeterStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.config.stats.reply.MeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.queue.statistics.rev131216.FlowCapableNodeConnectorQueueStatisticsData;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class NodeStatisticsAger {
    private final int NUMBER_OF_WAIT_CYCLES = 2;
    private final StatisticsProvider statisticsProvider;
    private final NodeKey targetNodeKey;
    private final Map<GroupDescStats, Date> groupDescStatsUpdate = new ConcurrentHashMap<GroupDescStats, Date>();
    private final Map<MeterConfigStats, Date> meterConfigStatsUpdate = new ConcurrentHashMap<MeterConfigStats, Date>();
    private final Map<FlowEntry, Date> flowStatsUpdate = new ConcurrentHashMap<FlowEntry, Date>();
    private final Map<QueueEntry, Date> queuesStatsUpdate = new ConcurrentHashMap<QueueEntry, Date>();

    public NodeStatisticsAger(StatisticsProvider statisticsProvider, NodeKey nodeKey) {
        this.targetNodeKey = nodeKey;
        this.statisticsProvider = statisticsProvider;
    }

    public NodeKey getTargetNodeKey() {
        return this.targetNodeKey;
    }

    public Map<GroupDescStats, Date> getGroupDescStatsUpdate() {
        return this.groupDescStatsUpdate;
    }

    public Map<MeterConfigStats, Date> getMeterConfigStatsUpdate() {
        return this.meterConfigStatsUpdate;
    }

    public Map<FlowEntry, Date> getFlowStatsUpdate() {
        return this.flowStatsUpdate;
    }

    public Map<QueueEntry, Date> getQueuesStatsUpdate() {
        return this.queuesStatsUpdate;
    }

    public void updateGroupDescStats(List<GroupDescStats> list) {
        Date expiryTime = this.getExpiryTime();
        for (GroupDescStats groupDescStats : list) {
            this.groupDescStatsUpdate.put(groupDescStats, expiryTime);
        }
    }

    public void updateMeterConfigStats(List<MeterConfigStats> list) {
        Date expiryTime = this.getExpiryTime();
        for (MeterConfigStats meterConfigStats : list) {
            this.meterConfigStatsUpdate.put(meterConfigStats, expiryTime);
        }
    }

    public void updateFlowStats(FlowEntry flowEntry) {
        this.flowStatsUpdate.put(flowEntry, this.getExpiryTime());
    }

    public void updateQueueStats(QueueEntry queueEntry) {
        this.queuesStatsUpdate.put(queueEntry, this.getExpiryTime());
    }

    private Date getExpiryTime() {
        Date expires = new Date();
        expires.setTime(expires.getTime() + 30000L);
        return expires;
    }

    public void cleanStaleStatistics() {
        Date expiryTime;
        Date now;
        Iterator<Object> it = this.groupDescStatsUpdate.keySet().iterator();
        while (it.hasNext()) {
            now = new Date();
            GroupDescStats groupDescStats = it.next();
            expiryTime = this.groupDescStatsUpdate.get(groupDescStats);
            if (!now.after(expiryTime)) continue;
            this.cleanGroupStatsFromDataStore(groupDescStats);
            it.remove();
        }
        it = this.meterConfigStatsUpdate.keySet().iterator();
        while (it.hasNext()) {
            now = new Date();
            MeterConfigStats meterConfigStats = (MeterConfigStats)it.next();
            expiryTime = this.meterConfigStatsUpdate.get(meterConfigStats);
            if (!now.after(expiryTime)) continue;
            this.cleanMeterStatsFromDataStore(meterConfigStats);
            it.remove();
        }
        it = this.flowStatsUpdate.keySet().iterator();
        while (it.hasNext()) {
            now = new Date();
            FlowEntry flowEntry = (FlowEntry)it.next();
            expiryTime = this.flowStatsUpdate.get(flowEntry);
            if (!now.after(expiryTime)) continue;
            this.cleanFlowStatsFromDataStore(flowEntry);
            it.remove();
        }
        it = this.queuesStatsUpdate.keySet().iterator();
        while (it.hasNext()) {
            now = new Date();
            QueueEntry queueEntry = (QueueEntry)it.next();
            expiryTime = this.queuesStatsUpdate.get(queueEntry);
            if (!now.after(expiryTime)) continue;
            this.cleanQueueStatsFromDataStore(queueEntry);
            it.remove();
        }
    }

    private void cleanQueueStatsFromDataStore(QueueEntry queueEntry) {
        InstanceIdentifier queueRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)this.targetNodeKey).child(NodeConnector.class, (Identifier)new NodeConnectorKey(queueEntry.getNodeConnectorId())).augmentation(FlowCapableNodeConnector.class).child(Queue.class, (Identifier)new QueueKey(queueEntry.getQueueId())).augmentation(FlowCapableNodeConnectorQueueStatisticsData.class).toInstance();
        this.cleanStaleStatisticsFromDataStore((InstanceIdentifier<? extends DataObject>)queueRef);
    }

    private void cleanFlowStatsFromDataStore(FlowEntry flowEntry) {
        InstanceIdentifier flowRef = (InstanceIdentifier)InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)this.targetNodeKey).augmentation(FlowCapableNode.class).child(Table.class, (Identifier)new TableKey(flowEntry.getTableId())).child(Flow.class, (Identifier)flowEntry.getFlow().getKey()).augmentation(FlowStatisticsData.class).toInstance();
        this.cleanStaleStatisticsFromDataStore((InstanceIdentifier<? extends DataObject>)flowRef);
    }

    private void cleanMeterStatsFromDataStore(MeterConfigStats meterConfigStats) {
        InstanceIdentifier.InstanceIdentifierBuilder meterRef = InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)this.targetNodeKey).augmentation(FlowCapableNode.class).child(Meter.class, (Identifier)new MeterKey(meterConfigStats.getMeterId()));
        InstanceIdentifier nodeMeterConfigStatsAugmentation = (InstanceIdentifier)meterRef.augmentation(NodeMeterConfigStats.class).toInstance();
        this.cleanStaleStatisticsFromDataStore((InstanceIdentifier<? extends DataObject>)nodeMeterConfigStatsAugmentation);
        InstanceIdentifier nodeMeterStatisticsAugmentation = (InstanceIdentifier)meterRef.augmentation(NodeMeterStatistics.class).toInstance();
        this.cleanStaleStatisticsFromDataStore((InstanceIdentifier<? extends DataObject>)nodeMeterStatisticsAugmentation);
    }

    private void cleanGroupStatsFromDataStore(GroupDescStats groupDescStats) {
        InstanceIdentifier.InstanceIdentifierBuilder groupRef = InstanceIdentifier.builder(Nodes.class).child(Node.class, (Identifier)this.targetNodeKey).augmentation(FlowCapableNode.class).child(Group.class, (Identifier)new GroupKey(groupDescStats.getGroupId()));
        InstanceIdentifier nodeGroupDescStatsAugmentation = (InstanceIdentifier)groupRef.augmentation(NodeGroupDescStats.class).toInstance();
        this.cleanStaleStatisticsFromDataStore((InstanceIdentifier<? extends DataObject>)nodeGroupDescStatsAugmentation);
        InstanceIdentifier nodeGroupStatisticsAugmentation = (InstanceIdentifier)groupRef.augmentation(NodeGroupStatistics.class).toInstance();
        this.cleanStaleStatisticsFromDataStore((InstanceIdentifier<? extends DataObject>)nodeGroupStatisticsAugmentation);
    }

    private void cleanStaleStatisticsFromDataStore(InstanceIdentifier<? extends DataObject> ii) {
        if (ii != null) {
            DataModificationTransaction it = this.statisticsProvider.startChange();
            it.removeOperationalData(ii);
            it.commit();
        }
    }

    public class QueueEntry {
        private final NodeConnectorId nodeConnectorId;
        private final QueueId queueId;

        public QueueEntry(NodeConnectorId ncId, QueueId queueId) {
            this.nodeConnectorId = ncId;
            this.queueId = queueId;
        }

        public NodeConnectorId getNodeConnectorId() {
            return this.nodeConnectorId;
        }

        public QueueId getQueueId() {
            return this.queueId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nodeConnectorId == null ? 0 : this.nodeConnectorId.hashCode());
            result = 31 * result + (this.queueId == null ? 0 : this.queueId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof QueueEntry)) {
                return false;
            }
            QueueEntry other = (QueueEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.nodeConnectorId == null ? other.nodeConnectorId != null : !this.nodeConnectorId.equals((Object)other.nodeConnectorId)) {
                return false;
            }
            return !(this.queueId == null ? other.queueId != null : !this.queueId.equals((Object)other.queueId));
        }

        private NodeStatisticsAger getOuterType() {
            return NodeStatisticsAger.this;
        }
    }

    public class FlowEntry {
        private final Short tableId;
        private final Flow flow;

        public FlowEntry(Short tableId, Flow flow) {
            this.tableId = tableId;
            this.flow = flow;
        }

        public Short getTableId() {
            return this.tableId;
        }

        public Flow getFlow() {
            return this.flow;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.flow == null ? 0 : this.flow.hashCode());
            result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowEntry other = (FlowEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.flow == null ? other.flow != null : !this.flow.equals(other.flow)) {
                return false;
            }
            return !(this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId));
        }

        private NodeStatisticsAger getOuterType() {
            return NodeStatisticsAger.this;
        }
    }
}

