/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.statistics.manager;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.transaction.rev131103.TransactionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;

public class MultipartMessageManager {
    private static Map<TxIdEntry, Date> txIdToRequestTypeMap = new ConcurrentHashMap<TxIdEntry, Date>();
    private static Map<TxIdEntry, Short> txIdTotableIdMap = new ConcurrentHashMap<TxIdEntry, Short>();
    private final int NUMBER_OF_WAIT_CYCLES = 2;

    public Short getTableIdForTxId(NodeId nodeId, TransactionId id) {
        return txIdTotableIdMap.get(new TxIdEntry(nodeId, id, null));
    }

    public void setTxIdAndTableIdMapEntry(NodeId nodeId, TransactionId id, Short tableId) {
        if (id == null) {
            return;
        }
        txIdTotableIdMap.put(new TxIdEntry(nodeId, id, null), tableId);
    }

    public boolean isRequestTxIdExist(NodeId nodeId, TransactionId id, Boolean moreRepliesToFollow) {
        TxIdEntry entry = new TxIdEntry(nodeId, id, null);
        if (moreRepliesToFollow.booleanValue()) {
            return txIdToRequestTypeMap.containsKey(entry);
        }
        return txIdToRequestTypeMap.remove(entry) != null;
    }

    public void addTxIdToRequestTypeEntry(NodeId nodeId, TransactionId id, StatsRequestType type) {
        if (id == null) {
            return;
        }
        TxIdEntry entry = new TxIdEntry(nodeId, id, type);
        txIdToRequestTypeMap.put(entry, this.getExpiryTime());
    }

    public boolean removeTxId(NodeId nodeId, TransactionId id) {
        TxIdEntry entry = new TxIdEntry(nodeId, id, null);
        return txIdToRequestTypeMap.remove(entry) != null;
    }

    private Date getExpiryTime() {
        Date expires = new Date();
        expires.setTime(expires.getTime() + 30000L);
        return expires;
    }

    public void cleanStaleTransactionIds() {
        Iterator<TxIdEntry> it = txIdToRequestTypeMap.keySet().iterator();
        while (it.hasNext()) {
            Date now = new Date();
            TxIdEntry txIdEntry = it.next();
            Date expiryTime = txIdToRequestTypeMap.get(txIdEntry);
            if (!now.after(expiryTime)) continue;
            it.remove();
            txIdTotableIdMap.remove(txIdEntry);
        }
    }

    public static enum StatsRequestType {
        ALL_FLOW,
        AGGR_FLOW,
        ALL_PORT,
        ALL_FLOW_TABLE,
        ALL_QUEUE_STATS,
        ALL_GROUP,
        ALL_METER,
        GROUP_DESC,
        METER_CONFIG;

    }

    class TxIdEntry {
        private final TransactionId txId;
        private final NodeId nodeId;
        private final StatsRequestType requestType;

        public TxIdEntry(NodeId nodeId, TransactionId txId, StatsRequestType requestType) {
            this.txId = txId;
            this.nodeId = nodeId;
            this.requestType = requestType;
        }

        public TransactionId getTxId() {
            return this.txId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public StatsRequestType getRequestType() {
            return this.requestType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
            result = 31 * result + (this.txId == null ? 0 : this.txId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TxIdEntry)) {
                return false;
            }
            TxIdEntry other = (TxIdEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals((Object)other.nodeId)) {
                return false;
            }
            return !(this.txId == null ? other.txId != null : !this.txId.equals((Object)other.txId));
        }

        private MultipartMessageManager getOuterType() {
            return MultipartMessageManager.this;
        }

        public String toString() {
            return "TxIdEntry [txId=" + this.txId + ", nodeId=" + this.nodeId + ", requestType=" + (Object)((Object)this.requestType) + "]";
        }
    }
}

