/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.management.beans.impl;

import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.management.beans.BundleMXBean;
import org.ow2.chameleon.management.beans.OSGiPlatformMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OSGiPlatformMXBeanImpl
extends NotificationBroadcasterSupport
implements OSGiPlatformMXBean {
    private ArrayList<BundleMXBean> bundles = new ArrayList();
    private BundleContext ctx;
    private static int sequenceNumber;

    public OSGiPlatformMXBeanImpl(BundleContext ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleMXBean(BundleMXBean bean) {
        ArrayList<BundleMXBean> arrayList = this.bundles;
        synchronized (arrayList) {
            this.bundles.add(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleMXBean(BundleMXBean bean) {
        ArrayList<BundleMXBean> arrayList = this.bundles;
        synchronized (arrayList) {
            this.bundles.remove(bean);
        }
    }

    @Override
    public List<BundleMXBean> getBundles() {
        return this.bundles;
    }

    @Override
    public BundleMXBean getBundle(long bundleID) {
        for (BundleMXBean bundleBean : this.bundles) {
            if (bundleBean.getBundleId() != bundleID) continue;
            return bundleBean;
        }
        return null;
    }

    @Override
    public String getFrameworkVersion() {
        return this.ctx.getProperty("org.osgi.framework.version");
    }

    @Override
    public String getFrameworkVendor() {
        return this.ctx.getProperty("org.osgi.framework.vendor");
    }

    @Override
    public String getFrameworkLanguage() {
        return this.ctx.getProperty("org.osgi.framework.language");
    }

    @Override
    public void installBundle(String location) throws Exception {
        this.ctx.installBundle(location);
    }

    synchronized void sendNotification(long bundleId) {
        try {
            Notification n = new Notification("Bundle-Changed", new ObjectName("osgijmx:type=bundle,id=" + bundleId), sequenceNumber++);
            n.setUserData(bundleId);
            this.sendNotification(n);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    synchronized void sendNotification(long bundleId, long serviceId) {
        try {
            Notification n = new Notification("Service-Changed", new ObjectName("osgijmx:type=bundle,id=" + bundleId), sequenceNumber++);
            n.setUserData(bundleId);
            this.sendNotification(n);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

