/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.management.beans.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.management.beans.BundleMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleMXBeanImpl
implements BundleMXBean {
    private Bundle bundle;

    public BundleMXBeanImpl(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public long getBundleId() {
        return this.bundle.getBundleId();
    }

    @Override
    public int getState() {
        return this.bundle.getState();
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public String getLocation() {
        return this.bundle.getLocation();
    }

    @Override
    public void start() throws Exception {
        this.bundle.start();
    }

    @Override
    public void stop() throws Exception {
        this.bundle.stop();
    }

    @Override
    public void update() throws Exception {
        this.bundle.update();
    }

    @Override
    public void uninstall() throws Exception {
        this.bundle.uninstall();
    }

    @Override
    public Map<String, String> getBundleHeaders() {
        Enumeration e = this.bundle.getHeaders().keys();
        HashMap<String, String> map = new HashMap<String, String>();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, (String)this.bundle.getHeaders().get(key));
        }
        return map;
    }

    @Override
    public Map<String, Map<String, String>> getRegisteredServices() {
        ServiceReference[] refs = this.bundle.getRegisteredServices();
        Map[] result = new Map[refs == null ? 0 : refs.length];
        TreeMap<String, Map<String, String>> hash = new TreeMap<String, Map<String, String>>();
        for (int i = 0; i < result.length; ++i) {
            hash.put(refs[i].getProperty("service.id").toString(), this.getProperties(refs[i]));
            result[i] = this.getProperties(refs[i]);
        }
        return hash;
    }

    private Map getProperties(ServiceReference ref) {
        String[] keys = ref.getPropertyKeys();
        TreeMap<String, String> hash = new TreeMap<String, String>();
        for (String key : keys) {
            Object propValue = ref.getProperty(key);
            if (propValue instanceof Object[]) {
                Object[] property = (Object[])propValue;
                StringBuilder sb = new StringBuilder();
                for (Object subproperty : property) {
                    sb.append(subproperty.toString());
                    sb.append(",");
                }
                if (sb.length() > 0) {
                    propValue = sb.substring(0, sb.length() - 1);
                }
            }
            hash.put(key, propValue == null ? "" : propValue.toString());
        }
        return hash;
    }

    @Override
    public List<String> getAllEntries() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration e = this.bundle.findEntries("/", "*", true);
            if (e != null) {
                while (e.hasMoreElements()) {
                    String path = ((URL)e.nextElement()).getPath();
                    if (path == null || path.length() <= 0 || path.endsWith("/")) continue;
                    result.add(path);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

