/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.management.beans.impl;

import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.ow2.chameleon.management.beans.impl.BundleMXBeanImpl;
import org.ow2.chameleon.management.beans.impl.OSGiPlatformMXBeanImpl;

public class Activator
implements BundleActivator,
BundleListener,
ServiceListener {
    private OSGiPlatformMXBeanImpl mxBean;
    private static final String PLATFORM_TYPE = "org.ow2.chameleon:type=framework";
    private static final String BUNDLE_TYPE = "org.ow2.chameleon:type=bundle,id=";

    public void start(BundleContext ctx) throws Exception {
        Bundle[] bundles;
        this.mxBean = new OSGiPlatformMXBeanImpl(ctx);
        ObjectName name = new ObjectName(PLATFORM_TYPE);
        ManagementFactory.getPlatformMBeanServer().registerMBean(this.mxBean, name);
        for (Bundle bundle : bundles = ctx.getBundles()) {
            this.registerBundleMXBean(bundle);
        }
        ctx.addBundleListener((BundleListener)this);
        ctx.addServiceListener((ServiceListener)this);
    }

    public void stop(BundleContext ctx) throws Exception {
        ObjectName name = new ObjectName(PLATFORM_TYPE);
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        Bundle[] bundles = ctx.getBundles();
        ctx.removeBundleListener((BundleListener)this);
        for (Bundle bundle : bundles) {
            this.unregisterBundleMXBean(bundle);
        }
    }

    private void registerBundleMXBean(Bundle bundle) {
        BundleMXBeanImpl bean = new BundleMXBeanImpl(bundle);
        try {
            ObjectName name = new ObjectName(BUNDLE_TYPE + bundle.getBundleId());
            ManagementFactory.getPlatformMBeanServer().registerMBean(bean, name);
            this.mxBean.addBundleMXBean(bean);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void unregisterBundleMXBean(Bundle bundle) {
        try {
            long bundleId = bundle.getBundleId();
            ObjectName name = new ObjectName(BUNDLE_TYPE + bundleId);
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
            this.mxBean.removeBundleMXBean(this.mxBean.getBundle(bundleId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 1) {
            this.registerBundleMXBean(event.getBundle());
            this.mxBean.sendNotification(event.getBundle().getBundleId());
        } else if (event.getType() == 16) {
            this.unregisterBundleMXBean(event.getBundle());
            this.mxBean.sendNotification(event.getBundle().getBundleId());
        } else {
            this.mxBean.sendNotification(event.getBundle().getBundleId());
        }
    }

    public void serviceChanged(ServiceEvent event) {
        Long serviceId = (Long)event.getServiceReference().getProperty("service.id");
        long bundleId = event.getServiceReference().getBundle().getBundleId();
        this.mxBean.sendNotification(bundleId, serviceId);
    }
}

