/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl.forward;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderInstance;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderService;
import org.opendaylight.controller.sal.binding.impl.RootBindingAwareBroker;
import org.opendaylight.controller.sal.binding.impl.connect.dom.BindingDomConnectorDeployer;
import org.opendaylight.controller.sal.binding.impl.connect.dom.BindingIndependentConnector;
import org.opendaylight.controller.sal.binding.impl.forward.DomForwardedBroker;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.RpcProvisionRegistry;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionInstance;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionService;
import org.opendaylight.controller.sal.core.api.notify.NotificationPublishService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;

public class DomForwardedBindingBrokerImpl
extends RootBindingAwareBroker
implements DomForwardedBroker {
    private Broker.ProviderSession domProviderContext;
    private BindingIndependentConnector connector;
    private MountProvisionService domMountService;
    private final DomMountPointForwardingManager domForwardingManager = new DomMountPointForwardingManager();
    private final BindingMountPointForwardingManager bindingForwardingManager = new BindingMountPointForwardingManager();
    private ConcurrentMap<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>, BindingIndependentConnector> connectors = new ConcurrentHashMap();
    private ConcurrentMap<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>, InstanceIdentifier> forwarded = new ConcurrentHashMap();
    private ListenerRegistration<MountProvisionService.MountProvisionListener> domListenerRegistration;
    private ListenerRegistration<MountProviderService.MountProvisionListener> baListenerRegistration;

    public DomForwardedBindingBrokerImpl(String instanceName) {
        super(instanceName);
    }

    @Override
    public BindingIndependentConnector getConnector() {
        return this.connector;
    }

    @Override
    public Broker.ProviderSession getDomProviderContext() {
        return this.domProviderContext;
    }

    @Override
    public void setConnector(BindingIndependentConnector connector) {
        this.connector = connector;
    }

    @Override
    public void setDomProviderContext(Broker.ProviderSession domProviderContext) {
        this.domProviderContext = domProviderContext;
    }

    @Override
    public void startForwarding() {
        BindingDomConnectorDeployer.startDataForwarding(this.getConnector(), this.getDataBroker(), this.getDomProviderContext());
        BindingDomConnectorDeployer.startRpcForwarding(this.getConnector(), this.getRpcProviderRegistry(), this.getDomProviderContext());
        BindingDomConnectorDeployer.startNotificationForwarding(this.getConnector(), this.getNotificationBroker(), this.getDomProviderContext());
        this.startMountpointForwarding();
    }

    private void startMountpointForwarding() {
        this.domMountService = (MountProvisionService)this.getDomProviderContext().getService(MountProvisionService.class);
        if (this.domMountService != null && this.getMountManager() != null) {
            this.domListenerRegistration = this.domMountService.registerProvisionListener((MountProvisionService.MountProvisionListener)this.domForwardingManager);
            this.baListenerRegistration = this.getMountManager().registerProvisionListener(this.bindingForwardingManager);
        }
    }

    public MountProvisionService getDomMountService() {
        return this.domMountService;
    }

    public void setDomMountService(MountProvisionService domMountService) {
        this.domMountService = domMountService;
    }

    private void tryToDeployConnector(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> baPath, InstanceIdentifier biPath) {
        InstanceIdentifier previous = this.forwarded.putIfAbsent(baPath, biPath);
        if (previous != null) {
            return;
        }
        MountProviderInstance baMountPoint = this.getMountManager().createOrGetMountPoint((org.opendaylight.yangtools.yang.binding.InstanceIdentifier)baPath);
        MountProvisionInstance domMountPoint = this.domMountService.createOrGetMountPoint(biPath);
        BindingIndependentConnector connector = this.createForwarder(baPath, baMountPoint, domMountPoint);
        this.connectors.put(baPath, connector);
    }

    private BindingIndependentConnector createForwarder(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> path, MountProviderInstance baMountPoint, MountProvisionInstance domMountPoint) {
        BindingIndependentConnector mountConnector = BindingDomConnectorDeployer.createConnector(this.getConnector());
        BindingDomConnectorDeployer.startDataForwarding(mountConnector, (org.opendaylight.controller.sal.binding.api.data.DataProviderService)baMountPoint, (DataProviderService)domMountPoint);
        BindingDomConnectorDeployer.startRpcForwarding(mountConnector, (RpcProviderRegistry)baMountPoint, (RpcProvisionRegistry)domMountPoint);
        BindingDomConnectorDeployer.startNotificationForwarding(mountConnector, (NotificationProviderService)baMountPoint, (NotificationPublishService)domMountPoint);
        return this.connector;
    }

    public synchronized void tryToDeployDomForwarder(InstanceIdentifier domPath) {
        try {
            org.opendaylight.yangtools.yang.binding.InstanceIdentifier baPath = this.connector.getMappingService().fromDataDom(domPath);
            BindingIndependentConnector potentialConnector = (BindingIndependentConnector)this.connectors.get(baPath);
            if (potentialConnector != null) {
                return;
            }
            this.tryToDeployConnector(baPath, domPath);
        }
        catch (DeserializationException deserializationException) {
            // empty catch block
        }
    }

    public synchronized void tryToDeployBindingForwarder(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> baPath) {
        BindingIndependentConnector potentialConnector = (BindingIndependentConnector)this.connectors.get(baPath);
        if (potentialConnector != null) {
            return;
        }
        InstanceIdentifier domPath = this.connector.getMappingService().toDataDom(baPath);
        this.tryToDeployConnector(baPath, domPath);
    }

    public synchronized void undeployBindingForwarder(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> baPath) {
    }

    public synchronized void undeployDomForwarder(InstanceIdentifier biPath) {
    }

    private class BindingMountPointForwardingManager
    implements MountProviderService.MountProvisionListener {
        private BindingMountPointForwardingManager() {
        }

        public void onMountPointCreated(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> path) {
            DomForwardedBindingBrokerImpl.this.tryToDeployBindingForwarder(path);
        }

        public void onMountPointRemoved(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> path) {
            DomForwardedBindingBrokerImpl.this.undeployBindingForwarder(path);
        }
    }

    private class DomMountPointForwardingManager
    implements MountProvisionService.MountProvisionListener {
        private DomMountPointForwardingManager() {
        }

        public void onMountPointCreated(InstanceIdentifier path) {
            DomForwardedBindingBrokerImpl.this.tryToDeployDomForwarder(path);
        }

        public void onMountPointRemoved(InstanceIdentifier path) {
            DomForwardedBindingBrokerImpl.this.undeployDomForwarder(path);
        }
    }
}

