/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl.connect.dom;

import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderInstance;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderService;
import org.opendaylight.controller.sal.binding.impl.connect.dom.BindingIndependentConnector;
import org.opendaylight.controller.sal.core.api.RpcProvisionRegistry;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionInstance;
import org.opendaylight.controller.sal.core.api.mount.MountProvisionService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;

public class BindingIndependentMountPointForwarder {
    private MountProvisionService domMountService;
    private MountProviderService baMountService;
    private BindingIndependentMappingService mappingService;
    private final DomMountPointForwardingManager domForwardingManager = new DomMountPointForwardingManager();
    private final BindingMountPointForwardingManager bindingForwardingManager = new BindingMountPointForwardingManager();
    private ConcurrentMap<InstanceIdentifier<?>, BindingIndependentConnector> connectors;
    private ConcurrentMap<InstanceIdentifier<?>, org.opendaylight.yangtools.yang.data.api.InstanceIdentifier> forwarded;
    private ListenerRegistration<MountProvisionService.MountProvisionListener> domListenerRegistration;
    private ListenerRegistration<MountProviderService.MountProvisionListener> baListenerRegistration;

    public MountProvisionService getDomMountService() {
        return this.domMountService;
    }

    public void setDomMountService(MountProvisionService domMountService) {
        this.domMountService = domMountService;
    }

    public void start() {
        if (this.domMountService != null && this.baMountService != null) {
            this.domListenerRegistration = this.domMountService.registerProvisionListener((MountProvisionService.MountProvisionListener)this.domForwardingManager);
            this.baListenerRegistration = this.baMountService.registerProvisionListener((MountProviderService.MountProvisionListener)this.bindingForwardingManager);
        }
    }

    private void tryToDeployConnector(InstanceIdentifier<?> baPath, org.opendaylight.yangtools.yang.data.api.InstanceIdentifier biPath) {
        org.opendaylight.yangtools.yang.data.api.InstanceIdentifier previous = this.forwarded.putIfAbsent(baPath, biPath);
        if (previous != null) {
            return;
        }
        MountProviderInstance baMountPoint = this.baMountService.getMountPoint(baPath);
        MountProvisionInstance domMountPoint = this.domMountService.getMountPoint(biPath);
        BindingIndependentConnector connector = this.createForwarder(baPath, baMountPoint, domMountPoint);
        this.connectors.put(baPath, connector);
        connector.startDataForwarding();
        connector.startRpcForwarding();
        connector.startNotificationForwarding();
    }

    private BindingIndependentConnector createForwarder(InstanceIdentifier<?> path, MountProviderInstance baMountPoint, MountProvisionInstance domMountPoint) {
        BindingIndependentConnector connector = new BindingIndependentConnector();
        connector.setBindingDataService((org.opendaylight.controller.sal.binding.api.data.DataProviderService)baMountPoint);
        connector.setBindingRpcRegistry((RpcProviderRegistry)baMountPoint);
        connector.setDomDataService((DataProviderService)domMountPoint);
        connector.setDomRpcRegistry((RpcProvisionRegistry)domMountPoint);
        return connector;
    }

    public synchronized void tryToDeployDomForwarder(org.opendaylight.yangtools.yang.data.api.InstanceIdentifier domPath) {
        try {
            InstanceIdentifier baPath = this.mappingService.fromDataDom(domPath);
            BindingIndependentConnector potentialConnector = (BindingIndependentConnector)this.connectors.get(baPath);
            if (potentialConnector != null) {
                return;
            }
            this.tryToDeployConnector(baPath, domPath);
        }
        catch (DeserializationException deserializationException) {
            // empty catch block
        }
    }

    public synchronized void tryToDeployBindingForwarder(InstanceIdentifier<?> baPath) {
        BindingIndependentConnector potentialConnector = (BindingIndependentConnector)this.connectors.get(baPath);
        if (potentialConnector != null) {
            return;
        }
        org.opendaylight.yangtools.yang.data.api.InstanceIdentifier domPath = this.mappingService.toDataDom(baPath);
        this.tryToDeployConnector(baPath, domPath);
    }

    public synchronized void undeployBindingForwarder(InstanceIdentifier<?> baPath) {
    }

    public synchronized void undeployDomForwarder(org.opendaylight.yangtools.yang.data.api.InstanceIdentifier biPath) {
    }

    private class BindingMountPointForwardingManager
    implements MountProviderService.MountProvisionListener {
        private BindingMountPointForwardingManager() {
        }

        public void onMountPointCreated(InstanceIdentifier<?> path) {
            BindingIndependentMountPointForwarder.this.tryToDeployBindingForwarder(path);
        }

        public void onMountPointRemoved(InstanceIdentifier<?> path) {
            BindingIndependentMountPointForwarder.this.undeployBindingForwarder(path);
        }
    }

    private class DomMountPointForwardingManager
    implements MountProvisionService.MountProvisionListener {
        private DomMountPointForwardingManager() {
        }

        public void onMountPointCreated(org.opendaylight.yangtools.yang.data.api.InstanceIdentifier path) {
            BindingIndependentMountPointForwarder.this.tryToDeployDomForwarder(path);
        }

        public void onMountPointRemoved(org.opendaylight.yangtools.yang.data.api.InstanceIdentifier path) {
            BindingIndependentMountPointForwarder.this.undeployDomForwarder(path);
        }
    }
}

