/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl.connect.dom;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.common.api.RegistrationListener;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandlerRegistration;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.md.sal.common.api.data.DataReader;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChange;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangePublisher;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.binding.api.data.RuntimeDataProvider;
import org.opendaylight.controller.sal.binding.api.rpc.RpcContextIdentifier;
import org.opendaylight.controller.sal.binding.api.rpc.RpcRouter;
import org.opendaylight.controller.sal.binding.impl.RpcProviderRegistryImpl;
import org.opendaylight.controller.sal.common.util.CommitHandlerTransactions;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.controller.sal.core.api.RpcImplementation;
import org.opendaylight.controller.sal.core.api.RpcProvisionRegistry;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.concepts.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.ImmutableCompositeNode;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingIndependentConnector
implements RuntimeDataProvider,
Provider,
AutoCloseable {
    private final Logger LOG = LoggerFactory.getLogger(BindingIndependentConnector.class);
    private static final org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> ROOT = (org.opendaylight.yangtools.yang.binding.InstanceIdentifier)org.opendaylight.yangtools.yang.binding.InstanceIdentifier.builder().toInstance();
    private static final InstanceIdentifier ROOT_BI = (InstanceIdentifier)InstanceIdentifier.builder().toInstance();
    private static final Method EQUALS_METHOD;
    private BindingIndependentMappingService mappingService;
    private org.opendaylight.controller.sal.core.api.data.DataProviderService biDataService;
    private DataProviderService baDataService;
    private ConcurrentMap<Object, BindingToDomTransaction> domOpenedTransactions = new ConcurrentHashMap<Object, BindingToDomTransaction>();
    private ConcurrentMap<Object, DomToBindingTransaction> bindingOpenedTransactions = new ConcurrentHashMap<Object, DomToBindingTransaction>();
    private BindingToDomCommitHandler bindingToDomCommitHandler = new BindingToDomCommitHandler();
    private DomToBindingCommitHandler domToBindingCommitHandler = new DomToBindingCommitHandler();
    private Registration<DataCommitHandler<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject>> baCommitHandlerRegistration;
    private Registration<DataCommitHandler<InstanceIdentifier, CompositeNode>> biCommitHandlerRegistration;
    private RpcProvisionRegistry biRpcRegistry;
    private RpcProviderRegistry baRpcRegistry;
    private ListenerRegistration<DomToBindingRpcForwardingManager> domToBindingRpcManager;
    private Function<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>, InstanceIdentifier> toDOMInstanceIdentifier = new Function<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>, InstanceIdentifier>(){

        public InstanceIdentifier apply(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> input) {
            return BindingIndependentConnector.this.mappingService.toDataDom(input);
        }
    };
    private Registration<DataReader<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject>> baDataReaderRegistration;
    private boolean rpcForwarding = false;
    private boolean dataForwarding = false;
    private boolean notificationForwarding = false;
    private RpcProviderRegistryImpl baRpcRegistryImpl;
    private org.opendaylight.controller.sal.dom.broker.spi.RpcRouter biRouter;

    public DataObject readOperationalData(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path) {
        try {
            InstanceIdentifier biPath = this.mappingService.toDataDom(path);
            CompositeNode result = this.biDataService.readOperationalData(biPath);
            return this.potentialAugmentationRead(path, biPath, result);
        }
        catch (DeserializationException e) {
            throw new IllegalStateException(e);
        }
    }

    private DataObject potentialAugmentationRead(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path, InstanceIdentifier biPath, CompositeNode result) throws DeserializationException {
        Class targetType = path.getTargetType();
        if (Augmentation.class.isAssignableFrom(targetType)) {
            path = this.mappingService.fromDataDom(biPath);
            Class augmentType = targetType;
            DataObject parentTo = this.mappingService.dataObjectFromDataDom(path, result);
            if (parentTo instanceof Augmentable) {
                return (DataObject)((Augmentable)parentTo).getAugmentation(augmentType);
            }
        }
        return this.mappingService.dataObjectFromDataDom(path, result);
    }

    public DataObject readConfigurationData(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path) {
        try {
            InstanceIdentifier biPath = this.mappingService.toDataDom(path);
            CompositeNode result = this.biDataService.readConfigurationData(biPath);
            return this.potentialAugmentationRead(path, biPath, result);
        }
        catch (DeserializationException e) {
            throw new IllegalStateException(e);
        }
    }

    private org.opendaylight.controller.sal.core.api.data.DataModificationTransaction createBindingToDomTransaction(DataModification<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> source) {
        Map.Entry biEntry;
        org.opendaylight.controller.sal.core.api.data.DataModificationTransaction target = this.biDataService.beginTransaction();
        this.LOG.debug("Created DOM Transaction {} for {},", target.getIdentifier(), source.getIdentifier());
        for (Map.Entry entry : source.getUpdatedConfigurationData().entrySet()) {
            biEntry = this.mappingService.toDataDom(entry);
            target.putConfigurationData(biEntry.getKey(), biEntry.getValue());
            this.LOG.debug("Update of Binding Configuration Data {} is translated to {}", entry, (Object)biEntry);
        }
        for (Map.Entry entry : source.getUpdatedOperationalData().entrySet()) {
            biEntry = this.mappingService.toDataDom(entry);
            target.putOperationalData(biEntry.getKey(), biEntry.getValue());
            this.LOG.debug("Update of Binding Operational Data {} is translated to {}", entry, (Object)biEntry);
        }
        for (org.opendaylight.yangtools.yang.binding.InstanceIdentifier instanceIdentifier : source.getRemovedConfigurationData()) {
            biEntry = this.mappingService.toDataDom(instanceIdentifier);
            target.removeConfigurationData((Object)biEntry);
            this.LOG.debug("Delete of Binding Configuration Data {} is translated to {}", (Object)instanceIdentifier, (Object)biEntry);
        }
        for (org.opendaylight.yangtools.yang.binding.InstanceIdentifier instanceIdentifier : source.getRemovedOperationalData()) {
            biEntry = this.mappingService.toDataDom(instanceIdentifier);
            target.removeOperationalData((Object)biEntry);
            this.LOG.debug("Delete of Binding Operational Data {} is translated to {}", (Object)instanceIdentifier, (Object)biEntry);
        }
        return target;
    }

    private DataModificationTransaction createDomToBindingTransaction(DataModification<InstanceIdentifier, CompositeNode> source) {
        org.opendaylight.yangtools.yang.binding.InstanceIdentifier baEntry;
        DataObject baData;
        org.opendaylight.yangtools.yang.binding.InstanceIdentifier baKey;
        DataModificationTransaction target = this.baDataService.beginTransaction();
        for (Map.Entry entry : source.getUpdatedConfigurationData().entrySet()) {
            try {
                baKey = this.mappingService.fromDataDom((InstanceIdentifier)entry.getKey());
                baData = this.mappingService.dataObjectFromDataDom(baKey, (CompositeNode)entry.getValue());
                target.putConfigurationData((Object)baKey, (Object)baData);
            }
            catch (DeserializationException e) {
                this.LOG.error("Ommiting from BA transaction: {}.", entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry entry : source.getUpdatedOperationalData().entrySet()) {
            try {
                baKey = this.mappingService.fromDataDom((InstanceIdentifier)entry.getKey());
                baData = this.mappingService.dataObjectFromDataDom(baKey, (CompositeNode)entry.getValue());
                target.putOperationalData((Object)baKey, (Object)baData);
            }
            catch (DeserializationException e) {
                this.LOG.error("Ommiting from BA transaction: {}.", entry.getKey(), (Object)e);
            }
        }
        for (InstanceIdentifier instanceIdentifier : source.getRemovedConfigurationData()) {
            try {
                baEntry = this.mappingService.fromDataDom(instanceIdentifier);
                target.removeConfigurationData((Object)baEntry);
            }
            catch (DeserializationException e) {
                this.LOG.error("Ommiting from BA transaction: {}.", (Object)instanceIdentifier, (Object)e);
            }
        }
        for (InstanceIdentifier instanceIdentifier : source.getRemovedOperationalData()) {
            try {
                baEntry = this.mappingService.fromDataDom(instanceIdentifier);
                target.removeOperationalData((Object)baEntry);
            }
            catch (DeserializationException e) {
                this.LOG.error("Ommiting from BA transaction: {}.", (Object)instanceIdentifier, (Object)e);
            }
        }
        return target;
    }

    public org.opendaylight.controller.sal.core.api.data.DataProviderService getBiDataService() {
        return this.biDataService;
    }

    protected void setDomDataService(org.opendaylight.controller.sal.core.api.data.DataProviderService biDataService) {
        this.biDataService = biDataService;
    }

    public DataProviderService getBaDataService() {
        return this.baDataService;
    }

    protected void setBindingDataService(DataProviderService baDataService) {
        this.baDataService = baDataService;
    }

    public RpcProviderRegistry getRpcRegistry() {
        return this.baRpcRegistry;
    }

    protected void setBindingRpcRegistry(RpcProviderRegistry rpcRegistry) {
        this.baRpcRegistry = rpcRegistry;
    }

    public void startDataForwarding() {
        Preconditions.checkState((!this.dataForwarding ? 1 : 0) != 0, (Object)"Connector is already forwarding data.");
        this.baDataReaderRegistration = this.baDataService.registerDataReader(ROOT, (DataReader)this);
        this.baCommitHandlerRegistration = this.baDataService.registerCommitHandler(ROOT, (DataCommitHandler)this.bindingToDomCommitHandler);
        this.biCommitHandlerRegistration = this.biDataService.registerCommitHandler((Path)ROOT_BI, (DataCommitHandler)this.domToBindingCommitHandler);
        this.baDataService.registerCommitHandlerListener((RegistrationListener)this.domToBindingCommitHandler);
        this.dataForwarding = true;
    }

    public void startRpcForwarding() {
        if (this.baRpcRegistry != null && this.biRpcRegistry != null && this.baRpcRegistry instanceof RouteChangePublisher) {
            Preconditions.checkState((!this.rpcForwarding ? 1 : 0) != 0, (Object)"Connector is already forwarding RPCs");
            this.domToBindingRpcManager = this.baRpcRegistry.registerRouteChangeListener((RouteChangeListener)new DomToBindingRpcForwardingManager());
            if (this.baRpcRegistry instanceof RpcProviderRegistryImpl) {
                this.baRpcRegistryImpl = (RpcProviderRegistryImpl)this.baRpcRegistry;
                this.baRpcRegistryImpl.registerRouterInstantiationListener((RpcProviderRegistryImpl.RouterInstantiationListener)this.domToBindingRpcManager.getInstance());
                this.baRpcRegistryImpl.registerGlobalRpcRegistrationListener((RpcProviderRegistryImpl.GlobalRpcRegistrationListener)this.domToBindingRpcManager.getInstance());
            }
            if (this.biRpcRegistry instanceof org.opendaylight.controller.sal.dom.broker.spi.RpcRouter) {
                this.biRouter = (org.opendaylight.controller.sal.dom.broker.spi.RpcRouter)this.biRpcRegistry;
            }
            this.rpcForwarding = true;
        }
    }

    public void startNotificationForwarding() {
        Preconditions.checkState((!this.notificationForwarding ? 1 : 0) != 0, (Object)"Connector is already forwarding notifications.");
        this.notificationForwarding = true;
    }

    protected void setMappingService(BindingIndependentMappingService mappingService) {
        this.mappingService = mappingService;
    }

    public Collection<Provider.ProviderFunctionality> getProviderFunctionality() {
        return Collections.emptyList();
    }

    public void onSessionInitiated(Broker.ProviderSession session) {
        this.setDomDataService((org.opendaylight.controller.sal.core.api.data.DataProviderService)session.getService(org.opendaylight.controller.sal.core.api.data.DataProviderService.class));
        this.setDomRpcRegistry((RpcProvisionRegistry)session.getService(RpcProvisionRegistry.class));
    }

    public <T extends RpcService> void onRpcRouterCreated(Class<T> serviceType, RpcRouter<T> router) {
    }

    public void setDomRpcRegistry(RpcProvisionRegistry registry) {
        this.biRpcRegistry = registry;
    }

    @Override
    public void close() throws Exception {
        if (this.baCommitHandlerRegistration != null) {
            this.baCommitHandlerRegistration.close();
        }
        if (this.biCommitHandlerRegistration != null) {
            this.biCommitHandlerRegistration.close();
        }
    }

    public boolean isRpcForwarding() {
        return this.rpcForwarding;
    }

    public boolean isDataForwarding() {
        return this.dataForwarding;
    }

    public boolean isNotificationForwarding() {
        return this.notificationForwarding;
    }

    public BindingIndependentMappingService getMappingService() {
        return this.mappingService;
    }

    static {
        try {
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class NoOutputInvocationStrategy
    extends RpcInvocationStrategy {
        private WeakReference<Class> inputClass;

        public NoOutputInvocationStrategy(QName rpc, Method targetMethod, Class<? extends DataContainer> inputClass) {
            super(rpc, targetMethod);
            this.inputClass = new WeakReference<Class<? extends DataContainer>>(inputClass);
        }

        @Override
        public RpcResult<CompositeNode> uncheckedInvoke(RpcService rpcService, CompositeNode domInput) throws Exception {
            DataContainer bindingInput = BindingIndependentConnector.this.mappingService.dataObjectFromDataDom((Class)this.inputClass.get(), domInput);
            Future result = (Future)this.targetMethod.invoke((Object)rpcService, bindingInput);
            if (result == null) {
                return Rpcs.getRpcResult((boolean)false);
            }
            RpcResult bindingResult = (RpcResult)result.get();
            return Rpcs.getRpcResult((boolean)true);
        }

        @Override
        public Future<RpcResult<?>> forwardToDomBroker(DataObject input) {
            if (BindingIndependentConnector.this.biRouter != null) {
                CompositeNode xml = BindingIndependentConnector.this.mappingService.toDataDom(input);
                ImmutableCompositeNode wrappedXml = ImmutableCompositeNode.create((QName)this.rpc, (List)ImmutableList.of((Object)xml));
                RpcResult result = BindingIndependentConnector.this.biRouter.invokeRpc(this.rpc, (CompositeNode)wrappedXml);
                Object baResultValue = null;
                RpcResult baResult = Rpcs.getRpcResult((boolean)result.isSuccessful(), null, (Collection)result.getErrors());
                return Futures.immediateFuture((Object)baResult);
            }
            return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)false));
        }
    }

    private class NoInputNoOutputInvocationStrategy
    extends RpcInvocationStrategy {
        public NoInputNoOutputInvocationStrategy(QName rpc, Method targetMethod) {
            super(rpc, targetMethod);
        }

        @Override
        public RpcResult<CompositeNode> uncheckedInvoke(RpcService rpcService, CompositeNode domInput) throws Exception {
            Future result = (Future)this.targetMethod.invoke((Object)rpcService, new Object[0]);
            RpcResult bindingResult = (RpcResult)result.get();
            return Rpcs.getRpcResult((boolean)bindingResult.isSuccessful(), (Collection)bindingResult.getErrors());
        }

        @Override
        public Future<RpcResult<?>> forwardToDomBroker(DataObject input) {
            return Futures.immediateFuture(null);
        }
    }

    private class DefaultInvocationStrategy
    extends RpcInvocationStrategy {
        private WeakReference<Class> inputClass;
        private WeakReference<Class> outputClass;

        public DefaultInvocationStrategy(QName rpc, Method targetMethod, Class<?> outputClass, Class<? extends DataContainer> inputClass) {
            super(rpc, targetMethod);
            this.outputClass = new WeakReference(outputClass);
            this.inputClass = new WeakReference<Class<? extends DataContainer>>(inputClass);
        }

        @Override
        public RpcResult<CompositeNode> uncheckedInvoke(RpcService rpcService, CompositeNode domInput) throws Exception {
            DataContainer bindingInput = BindingIndependentConnector.this.mappingService.dataObjectFromDataDom((Class)this.inputClass.get(), domInput);
            Future result = (Future)this.targetMethod.invoke((Object)rpcService, bindingInput);
            if (result == null) {
                return Rpcs.getRpcResult((boolean)false);
            }
            RpcResult bindingResult = (RpcResult)result.get();
            return Rpcs.getRpcResult((boolean)true);
        }

        @Override
        public Future<RpcResult<?>> forwardToDomBroker(DataObject input) {
            if (BindingIndependentConnector.this.biRouter != null) {
                CompositeNode xml = BindingIndependentConnector.this.mappingService.toDataDom(input);
                ImmutableCompositeNode wrappedXml = ImmutableCompositeNode.create((QName)this.rpc, (List)ImmutableList.of((Object)xml));
                RpcResult result = BindingIndependentConnector.this.biRouter.invokeRpc(this.rpc, (CompositeNode)wrappedXml);
                DataContainer baResultValue = null;
                if (result.getResult() != null) {
                    baResultValue = BindingIndependentConnector.this.mappingService.dataObjectFromDataDom((Class)this.outputClass.get(), (CompositeNode)result.getResult());
                }
                RpcResult baResult = Rpcs.getRpcResult((boolean)result.isSuccessful(), baResultValue, (Collection)result.getErrors());
                return Futures.immediateFuture((Object)baResult);
            }
            return Futures.immediateFuture((Object)Rpcs.getRpcResult((boolean)false));
        }
    }

    private abstract class RpcInvocationStrategy {
        protected final Method targetMethod;
        protected final QName rpc;

        public RpcInvocationStrategy(QName rpc, Method targetMethod) {
            this.targetMethod = targetMethod;
            this.rpc = rpc;
        }

        public abstract Future<RpcResult<?>> forwardToDomBroker(DataObject var1);

        public abstract RpcResult<CompositeNode> uncheckedInvoke(RpcService var1, CompositeNode var2) throws Exception;

        public RpcResult<CompositeNode> invokeOn(RpcService rpcService, CompositeNode domInput) throws Exception {
            return this.uncheckedInvoke(rpcService, domInput);
        }
    }

    private class DomToBindingRpcForwarder
    implements RpcImplementation,
    InvocationHandler {
        private final Set<QName> supportedRpcs;
        private final WeakReference<Class<? extends RpcService>> rpcServiceType;
        private Set<Broker.RoutedRpcRegistration> registrations;
        private Map<QName, RpcInvocationStrategy> strategiesByQName = new HashMap<QName, RpcInvocationStrategy>();
        private WeakHashMap<Method, RpcInvocationStrategy> strategiesByMethod = new WeakHashMap();

        public DomToBindingRpcForwarder(Class<? extends RpcService> service) {
            this.rpcServiceType = new WeakReference<Class<? extends RpcService>>(service);
            this.supportedRpcs = BindingIndependentConnector.this.mappingService.getRpcQNamesFor(service);
            try {
                for (QName rpc : this.supportedRpcs) {
                    RpcInvocationStrategy strategy = this.createInvocationStrategy(rpc, service);
                    this.strategiesByMethod.put(strategy.targetMethod, strategy);
                    this.strategiesByQName.put(rpc, strategy);
                    BindingIndependentConnector.this.biRpcRegistry.addRpcImplementation(rpc, (RpcImplementation)this);
                }
            }
            catch (Exception e) {
                BindingIndependentConnector.this.LOG.error("Could not forward Rpcs of type {}", (Object)service.getName(), (Object)e);
            }
            this.registrations = ImmutableSet.of();
        }

        public DomToBindingRpcForwarder(Class<? extends RpcService> service, Class<? extends BaseIdentity> context) {
            this.rpcServiceType = new WeakReference<Class<? extends RpcService>>(service);
            this.supportedRpcs = BindingIndependentConnector.this.mappingService.getRpcQNamesFor(service);
            ImmutableSet.Builder registrationsBuilder = ImmutableSet.builder();
            try {
                for (QName rpc : this.supportedRpcs) {
                    RpcInvocationStrategy strategy = this.createInvocationStrategy(rpc, service);
                    this.strategiesByMethod.put(strategy.targetMethod, strategy);
                    this.strategiesByQName.put(rpc, strategy);
                    registrationsBuilder.add((Object)BindingIndependentConnector.this.biRpcRegistry.addRoutedRpcImplementation(rpc, (RpcImplementation)this));
                }
                this.createDefaultDomForwarder();
            }
            catch (Exception e) {
                BindingIndependentConnector.this.LOG.error("Could not forward Rpcs of type {}", (Object)service.getName(), (Object)e);
            }
            this.registrations = registrationsBuilder.build();
        }

        public void registerPaths(Class<? extends BaseIdentity> context, Class<? extends RpcService> service, Set<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>> set) {
            QName ctx = BindingReflections.findQName(context);
            for (InstanceIdentifier path : FluentIterable.from(set).transform(BindingIndependentConnector.this.toDOMInstanceIdentifier)) {
                for (Broker.RoutedRpcRegistration reg : this.registrations) {
                    reg.registerPath((Object)ctx, (Object)path);
                }
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (EQUALS_METHOD.equals(method)) {
                return false;
            }
            RpcInvocationStrategy strategy = this.strategiesByMethod.get(method);
            Preconditions.checkState((strategy != null ? 1 : 0) != 0);
            Preconditions.checkArgument((args.length <= 2 ? 1 : 0) != 0);
            if (args.length == 1) {
                Preconditions.checkArgument((boolean)(args[0] instanceof DataObject));
                return strategy.forwardToDomBroker((DataObject)args[0]);
            }
            return strategy.forwardToDomBroker(null);
        }

        public void removePaths(Class<? extends BaseIdentity> context, Class<? extends RpcService> service, Set<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>> set) {
            QName ctx = BindingReflections.findQName(context);
            for (InstanceIdentifier path : FluentIterable.from(set).transform(BindingIndependentConnector.this.toDOMInstanceIdentifier)) {
                for (Broker.RoutedRpcRegistration reg : this.registrations) {
                    reg.unregisterPath((Object)ctx, (Object)path);
                }
            }
        }

        public Set<QName> getSupportedRpcs() {
            return this.supportedRpcs;
        }

        public void createDefaultDomForwarder() {
            if (BindingIndependentConnector.this.baRpcRegistryImpl != null) {
                Class cls = (Class)this.rpcServiceType.get();
                ClassLoader clsLoader = cls.getClassLoader();
                RpcService proxy = (RpcService)Proxy.newProxyInstance(clsLoader, new Class[]{cls}, (InvocationHandler)this);
                RpcRouter rpcRouter = BindingIndependentConnector.this.baRpcRegistryImpl.getRpcRouter((Class)this.rpcServiceType.get());
                rpcRouter.registerDefaultService(proxy);
            }
        }

        public RpcResult<CompositeNode> invokeRpc(QName rpc, CompositeNode domInput) {
            Preconditions.checkArgument((rpc != null ? 1 : 0) != 0);
            Preconditions.checkArgument((domInput != null ? 1 : 0) != 0);
            Class rpcType = (Class)this.rpcServiceType.get();
            Preconditions.checkState((rpcType != null ? 1 : 0) != 0);
            RpcService rpcService = BindingIndependentConnector.this.baRpcRegistry.getRpcService(rpcType);
            Preconditions.checkState((rpcService != null ? 1 : 0) != 0);
            CompositeNode domUnwrappedInput = domInput.getFirstCompositeByName(QName.create((QName)rpc, (String)"input"));
            try {
                return this.resolveInvocationStrategy(rpc).invokeOn(rpcService, domUnwrappedInput);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private RpcInvocationStrategy resolveInvocationStrategy(QName rpc) {
            return this.strategiesByQName.get(rpc);
        }

        private RpcInvocationStrategy createInvocationStrategy(final QName rpc, final Class<? extends RpcService> rpcType) throws Exception {
            return (RpcInvocationStrategy)ClassLoaderUtils.withClassLoader((ClassLoader)rpcType.getClassLoader(), (Callable)new Callable<RpcInvocationStrategy>(){

                @Override
                public RpcInvocationStrategy call() throws Exception {
                    String methodName = BindingMapping.getMethodName((QName)rpc);
                    Method targetMethod = null;
                    for (Method possibleMethod : rpcType.getMethods()) {
                        if (!possibleMethod.getName().equals(methodName) || !BindingReflections.isRpcMethod((Method)possibleMethod)) continue;
                        targetMethod = possibleMethod;
                        break;
                    }
                    Preconditions.checkState((targetMethod != null ? 1 : 0) != 0, (Object)"Rpc method not found");
                    Optional outputClass = BindingReflections.resolveRpcOutputClass(targetMethod);
                    Optional inputClass = BindingReflections.resolveRpcInputClass(targetMethod);
                    RpcInvocationStrategy strategy = null;
                    strategy = outputClass.isPresent() ? (inputClass.isPresent() ? new DefaultInvocationStrategy(rpc, targetMethod, (Class)outputClass.get(), (Class)inputClass.get()) : new NoInputNoOutputInvocationStrategy(rpc, targetMethod)) : (inputClass.isPresent() ? new NoOutputInvocationStrategy(rpc, targetMethod, (Class)inputClass.get()) : new NoInputNoOutputInvocationStrategy(rpc, targetMethod));
                    return strategy;
                }
            });
        }
    }

    private class DomToBindingRpcForwardingManager
    implements RouteChangeListener<RpcContextIdentifier, org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>>,
    RpcProviderRegistryImpl.RouterInstantiationListener,
    RpcProviderRegistryImpl.GlobalRpcRegistrationListener {
        private final Map<Class<? extends RpcService>, DomToBindingRpcForwarder> forwarders = new WeakHashMap<Class<? extends RpcService>, DomToBindingRpcForwarder>();
        private RpcProviderRegistryImpl registryImpl;

        private DomToBindingRpcForwardingManager() {
        }

        public RpcProviderRegistryImpl getRegistryImpl() {
            return this.registryImpl;
        }

        public void setRegistryImpl(RpcProviderRegistryImpl registryImpl) {
            this.registryImpl = registryImpl;
        }

        @Override
        public void onGlobalRpcRegistered(Class<? extends RpcService> cls) {
            this.getRpcForwarder(cls, null);
        }

        @Override
        public void onGlobalRpcUnregistered(Class<? extends RpcService> cls) {
        }

        @Override
        public void onRpcRouterCreated(RpcRouter<?> router) {
            Class ctx = (Class)router.getContexts().iterator().next();
            this.getRpcForwarder(router.getServiceType(), ctx);
        }

        public void onRouteChange(RouteChange<RpcContextIdentifier, org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>> change) {
            for (Map.Entry<RpcContextIdentifier, Set<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>>> entry : change.getAnnouncements().entrySet()) {
                this.bindingRoutesAdded(entry);
            }
        }

        private void bindingRoutesAdded(Map.Entry<RpcContextIdentifier, Set<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?>>> entry) {
            Class context = entry.getKey().getRoutingContext();
            Class service = entry.getKey().getRpcService();
            if (context != null) {
                this.getRpcForwarder(service, context).registerPaths(context, service, entry.getValue());
            }
        }

        private DomToBindingRpcForwarder getRpcForwarder(Class<? extends RpcService> service, Class<? extends BaseIdentity> context) {
            DomToBindingRpcForwarder potential = this.forwarders.get(service);
            if (potential != null) {
                return potential;
            }
            potential = context == null ? new DomToBindingRpcForwarder(service) : new DomToBindingRpcForwarder(service, context);
            this.forwarders.put(service, potential);
            return potential;
        }
    }

    private class DomToBindingCommitHandler
    implements RegistrationListener<DataCommitHandlerRegistration<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject>>,
    DataCommitHandler<InstanceIdentifier, CompositeNode> {
        private DomToBindingCommitHandler() {
        }

        public void onRegister(DataCommitHandlerRegistration<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> registration) {
            InstanceIdentifier domPath = BindingIndependentConnector.this.mappingService.toDataDom((org.opendaylight.yangtools.yang.binding.InstanceIdentifier)registration.getPath());
        }

        public void onUnregister(DataCommitHandlerRegistration<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> registration) {
        }

        public DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> requestCommit(DataModification<InstanceIdentifier, CompositeNode> domTransaction) {
            Object identifier = domTransaction.getIdentifier();
            if (BindingIndependentConnector.this.domOpenedTransactions.containsKey(identifier)) {
                return CommitHandlerTransactions.allwaysSuccessfulTransaction(domTransaction);
            }
            DataModificationTransaction baTransaction = BindingIndependentConnector.this.createDomToBindingTransaction((DataModification<InstanceIdentifier, CompositeNode>)domTransaction);
            DomToBindingTransaction forwardedTransaction = new DomToBindingTransaction(baTransaction, domTransaction);
            BindingIndependentConnector.this.LOG.trace("Forwarding DOM Transaction: {} as Binding Transaction: {}.", domTransaction.getIdentifier(), baTransaction.getIdentifier());
            return forwardedTransaction;
        }
    }

    private class BindingToDomCommitHandler
    implements DataCommitHandler<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> {
        private BindingToDomCommitHandler() {
        }

        public DataCommitHandler.DataCommitTransaction<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> requestCommit(DataModification<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> bindingTransaction) {
            if (BindingIndependentConnector.this.bindingOpenedTransactions.containsKey(bindingTransaction.getIdentifier())) {
                return CommitHandlerTransactions.allwaysSuccessfulTransaction(bindingTransaction);
            }
            org.opendaylight.controller.sal.core.api.data.DataModificationTransaction domTransaction = BindingIndependentConnector.this.createBindingToDomTransaction((DataModification<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject>)bindingTransaction);
            BindingToDomTransaction wrapped = new BindingToDomTransaction(domTransaction, bindingTransaction);
            BindingIndependentConnector.this.LOG.trace("Forwarding Binding Transaction: {} as DOM Transaction: {} .", bindingTransaction.getIdentifier(), domTransaction.getIdentifier());
            return wrapped;
        }
    }

    private class BindingToDomTransaction
    implements DataCommitHandler.DataCommitTransaction<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> {
        private org.opendaylight.controller.sal.core.api.data.DataModificationTransaction backing;
        private DataModification<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> modification;

        public BindingToDomTransaction(org.opendaylight.controller.sal.core.api.data.DataModificationTransaction backing, DataModification<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> modification) {
            this.backing = backing;
            this.modification = modification;
            BindingIndependentConnector.this.domOpenedTransactions.put(backing.getIdentifier(), this);
        }

        public DataModification<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> getModification() {
            return this.modification;
        }

        public RpcResult<Void> finish() throws IllegalStateException {
            Future result = this.backing.commit();
            try {
                RpcResult biResult = (RpcResult)result.get();
                RpcResult rpcResult = Rpcs.getRpcResult((boolean)biResult.isSuccessful(), null, (Collection)biResult.getErrors());
                return rpcResult;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("", e);
            }
            finally {
                BindingIndependentConnector.this.domOpenedTransactions.remove(this.backing.getIdentifier());
            }
        }

        public RpcResult<Void> rollback() throws IllegalStateException {
            BindingIndependentConnector.this.domOpenedTransactions.remove(this.backing.getIdentifier());
            return Rpcs.getRpcResult((boolean)true, null, Collections.emptySet());
        }
    }

    private class DomToBindingTransaction
    implements DataCommitHandler.DataCommitTransaction<InstanceIdentifier, CompositeNode> {
        private final DataModificationTransaction backing;
        private final DataModification<InstanceIdentifier, CompositeNode> modification;

        public DomToBindingTransaction(DataModificationTransaction backing, DataModification<InstanceIdentifier, CompositeNode> modification) {
            this.backing = backing;
            this.modification = modification;
            BindingIndependentConnector.this.bindingOpenedTransactions.put(backing.getIdentifier(), this);
        }

        public DataModification<InstanceIdentifier, CompositeNode> getModification() {
            return this.modification;
        }

        public RpcResult<Void> rollback() throws IllegalStateException {
            return Rpcs.getRpcResult((boolean)true, null, Collections.emptySet());
        }

        public RpcResult<Void> finish() throws IllegalStateException {
            Future result = this.backing.commit();
            try {
                RpcResult baResult = (RpcResult)result.get();
                return Rpcs.getRpcResult((boolean)baResult.isSuccessful(), null, (Collection)baResult.getErrors());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("", e);
            }
        }
    }
}

