/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl.connect.dom;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.impl.RootBindingAwareBroker;
import org.opendaylight.controller.sal.binding.impl.connect.dom.BindingIndependentConnector;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.RpcProvisionRegistry;
import org.opendaylight.controller.sal.core.api.data.DataProviderService;
import org.opendaylight.controller.sal.core.api.notify.NotificationPublishService;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;

public class BindingDomConnectorDeployer {
    private static BindingIndependentMappingService mappingService;

    public static BindingIndependentConnector tryToDeployConnector(RootBindingAwareBroker baBroker, Broker.ProviderSession domSession) {
        Preconditions.checkNotNull((Object)baBroker);
        Preconditions.checkNotNull((Object)domSession);
        BindingIndependentConnector connector = BindingDomConnectorDeployer.createConnector(mappingService);
        return connector;
    }

    public static BindingIndependentConnector createConnector(BindingIndependentMappingService mappingService) {
        BindingIndependentConnector connector = new BindingIndependentConnector();
        connector.setMappingService(mappingService);
        return connector;
    }

    public static BindingIndependentConnector createConnector(BindingIndependentConnector source) {
        BindingIndependentConnector connector = new BindingIndependentConnector();
        connector.setMappingService(source.getMappingService());
        return connector;
    }

    public static void startDataForwarding(BindingIndependentConnector connector, org.opendaylight.controller.sal.binding.api.data.DataProviderService baService, Broker.ProviderSession domContext) {
        BindingDomConnectorDeployer.startDataForwarding(connector, baService, (DataProviderService)domContext.getService(DataProviderService.class));
    }

    public static void startRpcForwarding(BindingIndependentConnector connector, RpcProviderRegistry rpcProviderRegistry, Broker.ProviderSession domProviderContext) {
        BindingDomConnectorDeployer.startRpcForwarding(connector, rpcProviderRegistry, (RpcProvisionRegistry)domProviderContext.getService(RpcProvisionRegistry.class));
    }

    public static void startNotificationForwarding(BindingIndependentConnector connector, NotificationProviderService provider, Broker.ProviderSession domProviderContext) {
        BindingDomConnectorDeployer.startNotificationForwarding(connector, provider, (NotificationPublishService)domProviderContext.getService(NotificationPublishService.class));
    }

    public static void startRpcForwarding(BindingIndependentConnector connector, RpcProviderRegistry baService, RpcProvisionRegistry domService) {
        if (connector.isRpcForwarding()) {
            return;
        }
        connector.setDomRpcRegistry(domService);
        connector.setBindingRpcRegistry(baService);
        connector.startRpcForwarding();
    }

    public static void startDataForwarding(BindingIndependentConnector connector, org.opendaylight.controller.sal.binding.api.data.DataProviderService baService, DataProviderService domService) {
        if (connector.isDataForwarding()) {
            return;
        }
        connector.setBindingDataService(baService);
        connector.setDomDataService(domService);
        connector.startDataForwarding();
    }

    public static void startNotificationForwarding(BindingIndependentConnector connector, NotificationProviderService baService, NotificationPublishService domService) {
        if (connector.isNotificationForwarding()) {
            return;
        }
    }
}

