/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl;

import com.google.common.base.Preconditions;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChange;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangePublisher;
import org.opendaylight.controller.md.sal.common.impl.routing.RoutingUtils;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.rpc.RpcContextIdentifier;
import org.opendaylight.controller.sal.binding.api.rpc.RpcRouter;
import org.opendaylight.controller.sal.binding.codegen.RuntimeCodeGenerator;
import org.opendaylight.controller.sal.binding.codegen.RuntimeCodeHelper;
import org.opendaylight.controller.sal.binding.codegen.impl.SingletonHolder;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcProviderRegistryImpl
implements RpcProviderRegistry,
RouteChangePublisher<RpcContextIdentifier, InstanceIdentifier<?>> {
    private RuntimeCodeGenerator rpcFactory = SingletonHolder.RPC_GENERATOR_IMPL;
    private final Map<Class<? extends RpcService>, RpcService> publicProxies = new WeakHashMap<Class<? extends RpcService>, RpcService>();
    private final Map<Class<? extends RpcService>, RpcRouter<?>> rpcRouters = new WeakHashMap();
    private final ListenerRegistry<RouteChangeListener<RpcContextIdentifier, InstanceIdentifier<?>>> routeChangeListeners = ListenerRegistry.create();
    private final ListenerRegistry<RouterInstantiationListener> routerInstantiationListener = ListenerRegistry.create();
    private static final Logger LOG = LoggerFactory.getLogger(RpcProviderRegistryImpl.class);
    private final String name;
    private ListenerRegistry<GlobalRpcRegistrationListener> globalRpcListeners = ListenerRegistry.create();

    public String getName() {
        return this.name;
    }

    public RpcProviderRegistryImpl(String name) {
        this.name = name;
    }

    public final <T extends RpcService> BindingAwareBroker.RoutedRpcRegistration<T> addRoutedRpcImplementation(Class<T> type, T implementation) throws IllegalStateException {
        return this.getRpcRouter(type).addRoutedRpcImplementation(implementation);
    }

    public final <T extends RpcService> BindingAwareBroker.RpcRegistration<T> addRpcImplementation(Class<T> type, T implementation) throws IllegalStateException {
        RpcRouter<?> potentialRouter = this.rpcRouters.get(type);
        if (potentialRouter != null) {
            Preconditions.checkState((potentialRouter.getDefaultService() == null ? 1 : 0) != 0, (Object)"Default service for routed RPC already registered.");
            return potentialRouter.registerDefaultService(implementation);
        }
        T publicProxy = this.getRpcService(type);
        Object currentDelegate = RuntimeCodeHelper.getDelegate(publicProxy);
        Preconditions.checkState((currentDelegate == null ? 1 : 0) != 0, (Object)"Rpc service is already registered");
        LOG.debug("Registering {} as global implementation of {} in {}", new Object[]{implementation, type.getSimpleName(), this});
        RuntimeCodeHelper.setDelegate(publicProxy, implementation);
        this.notifyGlobalRpcAdded(type);
        return new RpcProxyRegistration<T>(type, implementation, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends RpcService> T getRpcService(Class<T> type) {
        RpcService potentialProxy = this.publicProxies.get(type);
        if (potentialProxy != null) {
            return (T)potentialProxy;
        }
        RpcProviderRegistryImpl rpcProviderRegistryImpl = this;
        synchronized (rpcProviderRegistryImpl) {
            potentialProxy = this.publicProxies.get(type);
            if (potentialProxy != null) {
                return (T)potentialProxy;
            }
            T proxy = this.rpcFactory.getDirectProxyFor(type);
            LOG.debug("Created {} as public proxy for {} in {}", new Object[]{proxy, type.getSimpleName(), this});
            this.publicProxies.put((Class<? extends RpcService>)type, (RpcService)proxy);
            return proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends RpcService> RpcRouter<T> getRpcRouter(Class<T> type) {
        RpcRouter<?> potentialRouter = this.rpcRouters.get(type);
        if (potentialRouter != null) {
            return potentialRouter;
        }
        RpcProviderRegistryImpl rpcProviderRegistryImpl = this;
        synchronized (rpcProviderRegistryImpl) {
            potentialRouter = this.rpcRouters.get(type);
            if (potentialRouter != null) {
                return potentialRouter;
            }
            RpcRouter<T> router = this.rpcFactory.getRouterFor(type, this.name);
            router.registerRouteChangeListener(new RouteChangeForwarder<T>(type));
            LOG.debug("Registering router {} as global implementation of {} in {}", new Object[]{router, type.getSimpleName(), this});
            RuntimeCodeHelper.setDelegate(this.getRpcService(type), router.getInvocationProxy());
            this.rpcRouters.put(type, router);
            this.notifyListenersRoutedCreated(router);
            return router;
        }
    }

    private void notifyGlobalRpcAdded(Class<? extends RpcService> type) {
        for (ListenerRegistration listener : this.globalRpcListeners) {
            try {
                ((GlobalRpcRegistrationListener)listener.getInstance()).onGlobalRpcRegistered(type);
            }
            catch (Exception e) {
                LOG.error("Unhandled exception during invoking listener {}", (Throwable)e);
            }
        }
    }

    private void notifyListenersRoutedCreated(RpcRouter router) {
        for (ListenerRegistration listener : this.routerInstantiationListener) {
            try {
                ((RouterInstantiationListener)listener.getInstance()).onRpcRouterCreated(router);
            }
            catch (Exception e) {
                LOG.error("Unhandled exception during invoking listener {}", (Throwable)e);
            }
        }
    }

    public ListenerRegistration<RouterInstantiationListener> registerRouterInstantiationListener(RouterInstantiationListener listener) {
        ListenerRegistration reg = this.routerInstantiationListener.register((EventListener)listener);
        try {
            for (RpcRouter<?> router : this.rpcRouters.values()) {
                listener.onRpcRouterCreated(router);
            }
        }
        catch (Exception e) {
            LOG.error("Unhandled exception during invoking listener {}", (Throwable)e);
        }
        return reg;
    }

    public <L extends RouteChangeListener<RpcContextIdentifier, InstanceIdentifier<?>>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
        return this.routeChangeListeners.register(listener);
    }

    public RuntimeCodeGenerator getRpcFactory() {
        return this.rpcFactory;
    }

    public void setRpcFactory(RuntimeCodeGenerator rpcFactory) {
        this.rpcFactory = rpcFactory;
    }

    public ListenerRegistration<GlobalRpcRegistrationListener> registerGlobalRpcRegistrationListener(GlobalRpcRegistrationListener listener) {
        return this.globalRpcListeners.register((EventListener)listener);
    }

    public static class RpcProxyRegistration<T extends RpcService>
    extends AbstractObjectRegistration<T>
    implements BindingAwareBroker.RpcRegistration<T> {
        private final Class<T> serviceType;
        private RpcProviderRegistryImpl registry;

        public RpcProxyRegistration(Class<T> type, T service, RpcProviderRegistryImpl registry) {
            super(service);
            this.serviceType = type;
        }

        public Class<T> getServiceType() {
            return this.serviceType;
        }

        protected void removeRegistration() {
            if (this.registry != null) {
                T publicProxy = this.registry.getRpcService(this.serviceType);
                Object currentDelegate = RuntimeCodeHelper.getDelegate(publicProxy);
                if (currentDelegate == this.getInstance()) {
                    RuntimeCodeHelper.setDelegate(publicProxy, null);
                }
                this.registry = null;
            }
        }
    }

    private class RouteChangeForwarder<T extends RpcService>
    implements RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>> {
        private final Class<T> type;

        public RouteChangeForwarder(Class<T> type) {
            this.type = type;
        }

        public void onRouteChange(RouteChange<Class<? extends BaseIdentity>, InstanceIdentifier<?>> change) {
            HashMap announcements = new HashMap();
            for (Map.Entry entry : change.getAnnouncements().entrySet()) {
                RpcContextIdentifier key = RpcContextIdentifier.contextFor(this.type, (Class)((Class)entry.getKey()));
                announcements.put(key, entry.getValue());
            }
            HashMap removals = new HashMap();
            for (Map.Entry entry : change.getRemovals().entrySet()) {
                RpcContextIdentifier key = RpcContextIdentifier.contextFor(this.type, (Class)((Class)entry.getKey()));
                removals.put(key, entry.getValue());
            }
            RouteChange toPublish = RoutingUtils.change(announcements, removals);
            for (ListenerRegistration listener : RpcProviderRegistryImpl.this.routeChangeListeners) {
                try {
                    ((RouteChangeListener)listener.getInstance()).onRouteChange(toPublish);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface GlobalRpcRegistrationListener
    extends EventListener {
        public void onGlobalRpcRegistered(Class<? extends RpcService> var1);

        public void onGlobalRpcUnregistered(Class<? extends RpcService> var1);
    }

    public static interface RouterInstantiationListener
    extends EventListener {
        public void onRpcRouterCreated(RpcRouter<?> var1);
    }
}

