/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import org.opendaylight.controller.md.sal.binding.util.AbstractBindingSalProviderInstance;
import org.opendaylight.controller.md.sal.binding.util.BindingContextUtils;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareConsumer;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareService;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.NotificationService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderService;
import org.opendaylight.controller.sal.binding.api.mount.MountService;
import org.opendaylight.controller.sal.binding.api.rpc.RpcContextIdentifier;
import org.opendaylight.controller.sal.binding.impl.MountPointManagerImpl;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootBindingAwareBroker
implements Mutable,
Identifiable<String>,
BindingAwareBroker,
AutoCloseable,
RpcProviderRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RootBindingAwareBroker.class);
    RootSalInstance controllerRoot;
    private final String identifier;
    private RpcProviderRegistry rpcBroker;
    private NotificationProviderService notificationBroker;
    private DataProviderService dataBroker;
    private MountPointManagerImpl mountManager;
    private ImmutableClassToInstanceMap<BindingAwareService> supportedConsumerServices;
    private ImmutableClassToInstanceMap<BindingAwareService> supportedProviderServices;

    public MountPointManagerImpl getMountManager() {
        return this.mountManager;
    }

    public void setMountManager(MountPointManagerImpl mountManager) {
        this.mountManager = mountManager;
    }

    public RootBindingAwareBroker(String instanceName) {
        this.identifier = instanceName;
        this.mountManager = new MountPointManagerImpl();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public RootSalInstance getRoot() {
        return this.controllerRoot;
    }

    public DataProviderService getDataBroker() {
        return this.dataBroker;
    }

    public NotificationProviderService getNotificationBroker() {
        return this.notificationBroker;
    }

    public RpcProviderRegistry getRpcProviderRegistry() {
        return this.rpcBroker;
    }

    public RpcProviderRegistry getRpcBroker() {
        return this.rpcBroker;
    }

    public void setRpcBroker(RpcProviderRegistry rpcBroker) {
        this.rpcBroker = rpcBroker;
    }

    public void setNotificationBroker(NotificationProviderService notificationBroker) {
        this.notificationBroker = notificationBroker;
    }

    public void setDataBroker(DataProviderService dataBroker) {
        this.dataBroker = dataBroker;
    }

    public void start() {
        Preconditions.checkState((this.controllerRoot == null ? 1 : 0) != 0, (Object)"Binding Aware Broker was already started.");
        LOG.info("Starting Binding Aware Broker: {}", (Object)this.identifier);
        this.controllerRoot = new RootSalInstance(this.getRpcProviderRegistry(), this.getNotificationBroker(), this.getDataBroker());
        this.supportedConsumerServices = ImmutableClassToInstanceMap.builder().put(NotificationService.class, (Object)this.getRoot()).put(DataBrokerService.class, (Object)this.getRoot()).put(RpcConsumerRegistry.class, (Object)this.getRoot()).put(MountService.class, (Object)this.mountManager).build();
        this.supportedProviderServices = ImmutableClassToInstanceMap.builder().putAll(this.supportedConsumerServices).put(NotificationProviderService.class, (Object)this.getRoot()).put(DataProviderService.class, (Object)this.getRoot()).put(RpcProviderRegistry.class, (Object)this.getRoot()).put(MountProviderService.class, (Object)this.mountManager).build();
    }

    public BindingAwareBroker.ConsumerContext registerConsumer(BindingAwareConsumer consumer, BundleContext ctx) {
        Preconditions.checkState((this.supportedConsumerServices != null ? 1 : 0) != 0, (Object)"Broker is not initialized.");
        return BindingContextUtils.createConsumerContextAndInitialize((BindingAwareConsumer)consumer, this.supportedConsumerServices);
    }

    public BindingAwareBroker.ProviderContext registerProvider(BindingAwareProvider provider, BundleContext ctx) {
        Preconditions.checkState((this.supportedProviderServices != null ? 1 : 0) != 0, (Object)"Broker is not initialized.");
        return BindingContextUtils.createProviderContextAndInitialize((BindingAwareProvider)provider, this.supportedProviderServices);
    }

    @Override
    public void close() throws Exception {
    }

    public <T extends RpcService> BindingAwareBroker.RoutedRpcRegistration<T> addRoutedRpcImplementation(Class<T> type, T implementation) throws IllegalStateException {
        return this.getRoot().addRoutedRpcImplementation(type, implementation);
    }

    public <T extends RpcService> BindingAwareBroker.RpcRegistration<T> addRpcImplementation(Class<T> type, T implementation) throws IllegalStateException {
        return this.getRoot().addRpcImplementation(type, implementation);
    }

    public <T extends RpcService> T getRpcService(Class<T> module) {
        return (T)this.getRoot().getRpcService(module);
    }

    public <L extends RouteChangeListener<RpcContextIdentifier, InstanceIdentifier<?>>> ListenerRegistration<L> registerRouteChangeListener(L arg0) {
        return this.getRoot().registerRouteChangeListener(arg0);
    }

    public class RootSalInstance
    extends AbstractBindingSalProviderInstance<DataProviderService, NotificationProviderService, RpcProviderRegistry> {
        public RootSalInstance(RpcProviderRegistry rpcRegistry, NotificationProviderService notificationBroker, DataProviderService dataBroker) {
            super(rpcRegistry, notificationBroker, dataBroker);
        }
    }
}

