/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl;

import java.util.concurrent.Callable;
import org.eclipse.xtend.lib.Data;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.util.ToStringHelper;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Data
public class NotifyTask
implements Callable<Object> {
    private static Logger log = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(NotifyTask.class);
            return _logger;
        }
    }.apply();
    private final NotificationListener _listener;
    private final Notification _notification;

    public NotificationListener getListener() {
        return this._listener;
    }

    public Notification getNotification() {
        return this._notification;
    }

    @Override
    public Object call() {
        try {
            boolean _isDebugEnabled = log.isDebugEnabled();
            if (_isDebugEnabled) {
                Notification _notification = this.getNotification();
                NotificationListener _listener = this.getListener();
                log.debug("Delivering notification {} to {}", (Object)_notification, (Object)_listener);
            } else {
                Notification _notification_1 = this.getNotification();
                Class<?> _class = _notification_1.getClass();
                String _name = _class.getName();
                NotificationListener _listener_1 = this.getListener();
                log.trace("Delivering notification {} to {}", (Object)_name, (Object)_listener_1);
            }
            NotificationListener _listener_2 = this.getListener();
            Notification _notification_2 = this.getNotification();
            _listener_2.onNotification(_notification_2);
            boolean _isDebugEnabled_1 = log.isDebugEnabled();
            if (_isDebugEnabled_1) {
                Notification _notification_3 = this.getNotification();
                NotificationListener _listener_3 = this.getListener();
                log.debug("Notification delivered {} to {}", (Object)_notification_3, (Object)_listener_3);
            } else {
                Notification _notification_4 = this.getNotification();
                Class<?> _class_1 = _notification_4.getClass();
                String _name_1 = _class_1.getName();
                NotificationListener _listener_4 = this.getListener();
                log.trace("Notification delivered {} to {}", (Object)_name_1, (Object)_listener_4);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                NotificationListener _listener_5 = this.getListener();
                log.error("Unhandled exception thrown by listener: {}", (Object)_listener_5, (Object)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return null;
    }

    public NotifyTask(NotificationListener listener, Notification notification) {
        this._listener = listener;
        this._notification = notification;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._listener == null ? 0 : this._listener.hashCode());
        result = 31 * result + (this._notification == null ? 0 : this._notification.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotifyTask other = (NotifyTask)obj;
        if (this._listener == null ? other._listener != null : !this._listener.equals(other._listener)) {
            return false;
        }
        return !(this._notification == null ? other._notification != null : !this._notification.equals(other._notification));
    }

    public String toString() {
        String result = new ToStringHelper().toString((Object)this);
        return result;
    }
}

