/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.codegen.impl.SingletonHolder;
import org.opendaylight.controller.sal.binding.impl.GeneratedListenerRegistration;
import org.opendaylight.controller.sal.binding.impl.GenericNotificationRegistration;
import org.opendaylight.controller.sal.binding.impl.NotifyTask;
import org.opendaylight.controller.sal.binding.spi.NotificationInvokerFactory;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.Notification;

public class NotificationBrokerImpl
implements NotificationProviderService,
AutoCloseable {
    private final Multimap<Class<? extends Notification>, NotificationListener<? extends Object>> listeners;
    private ExecutorService _executor;

    public ExecutorService getExecutor() {
        return this._executor;
    }

    public void setExecutor(ExecutorService executor) {
        this._executor = executor;
    }

    public NotificationBrokerImpl() {
        SetMultimap _synchronizedSetMultimap;
        HashMultimap _create = HashMultimap.create();
        this.listeners = _synchronizedSetMultimap = Multimaps.synchronizedSetMultimap((SetMultimap)_create);
    }

    @Deprecated
    public NotificationBrokerImpl(ExecutorService executor) {
        SetMultimap _synchronizedSetMultimap;
        HashMultimap _create = HashMultimap.create();
        this.listeners = _synchronizedSetMultimap = Multimaps.synchronizedSetMultimap((SetMultimap)_create);
        this.setExecutor(executor);
    }

    @Deprecated
    public <T extends Notification> void addNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        this.listeners.put(notificationType, listener);
    }

    @Deprecated
    public <T extends Notification> void removeNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        this.listeners.remove(notificationType, listener);
    }

    public void notify(Notification notification) {
        this.publish(notification);
    }

    public Iterable<Class<? extends Object>> getNotificationTypes(Notification notification) {
        Class<?> _class = notification.getClass();
        Class<?>[] _interfaces = _class.getInterfaces();
        Functions.Function1<Class<? extends Object>, Boolean> _function = new Functions.Function1<Class<? extends Object>, Boolean>(){

            public Boolean apply(Class<? extends Object> it) {
                boolean _notEquals;
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal(it, Notification.class);
                if (!_notEquals) {
                    _and = false;
                } else {
                    boolean _isAssignableFrom = Notification.class.isAssignableFrom(it);
                    _and = _notEquals && _isAssignableFrom;
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray(_interfaces)), (Functions.Function1)_function);
        return _filter;
    }

    private void notifyAll(Collection<NotificationListener<? extends Object>> listeners, final Notification notification) {
        Procedures.Procedure1<NotificationListener<? extends Object>> _function = new Procedures.Procedure1<NotificationListener<? extends Object>>(){

            public void apply(NotificationListener<? extends Object> it) {
                it.onNotification(notification);
            }
        };
        IterableExtensions.forEach(listeners, (Procedures.Procedure1)_function);
    }

    @Deprecated
    public void addNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Deprecated method. Use registerNotificationListener instead.");
        throw _unsupportedOperationException;
    }

    @Deprecated
    public void removeNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Deprecated method. Use RegisterNotificationListener returned value to close registration.");
        throw _unsupportedOperationException;
    }

    @Deprecated
    public void notify(Notification notification, ExecutorService service) {
        this.publish(notification, service);
    }

    public void publish(Notification notification) {
        ExecutorService _executor = this.getExecutor();
        this.publish(notification, _executor);
    }

    public void publish(final Notification notification, ExecutorService service) {
        try {
            Iterable<Class<? extends Object>> allTypes = this.getNotificationTypes(notification);
            Iterable<Object> listenerToNotify = Collections.emptySet();
            for (Class<? extends Object> type : allTypes) {
                Collection _get = this.listeners.get(type);
                Iterable _plus = Iterables.concat(listenerToNotify, (Iterable)_get);
                listenerToNotify = _plus;
            }
            Functions.Function1<NotificationListener<? extends Object>, NotifyTask> _function = new Functions.Function1<NotificationListener<? extends Object>, NotifyTask>(){

                public NotifyTask apply(NotificationListener<? extends Object> it) {
                    NotifyTask _notifyTask = new NotifyTask(it, notification);
                    return _notifyTask;
                }
            };
            Iterable _map = IterableExtensions.map(listenerToNotify, (Functions.Function1)_function);
            Set tasks = IterableExtensions.toSet((Iterable)_map);
            ExecutorService _executor = this.getExecutor();
            _executor.invokeAll(tasks);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public <T extends Notification> Registration<NotificationListener<T>> registerNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        GenericNotificationRegistration<T> _genericNotificationRegistration;
        GenericNotificationRegistration<T> reg = _genericNotificationRegistration = new GenericNotificationRegistration<T>(notificationType, listener, this);
        this.listeners.put(notificationType, listener);
        return reg;
    }

    public Registration<org.opendaylight.yangtools.yang.binding.NotificationListener> registerNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        GeneratedListenerRegistration _generatedListenerRegistration;
        NotificationInvokerFactory.NotificationInvoker invoker = SingletonHolder.INVOKER_FACTORY.invokerFor(listener);
        Set<Class<? extends Notification>> _supportedNotifications = invoker.getSupportedNotifications();
        for (Class<? extends Notification> notifyType : _supportedNotifications) {
            NotificationListener<Notification> _invocationProxy = invoker.getInvocationProxy();
            this.listeners.put(notifyType, _invocationProxy);
        }
        GeneratedListenerRegistration registration = _generatedListenerRegistration = new GeneratedListenerRegistration(listener, invoker, this);
        return registration;
    }

    protected boolean unregisterListener(GenericNotificationRegistration<? extends Object> reg) {
        Class<? extends Object> _type = reg.getType();
        NotificationListener _instance = (NotificationListener)reg.getInstance();
        boolean _remove = this.listeners.remove(_type, (Object)_instance);
        return _remove;
    }

    protected void unregisterListener(GeneratedListenerRegistration reg) {
        NotificationInvokerFactory.NotificationInvoker _invoker = reg.getInvoker();
        Set<Class<? extends Notification>> _supportedNotifications = _invoker.getSupportedNotifications();
        for (Class<? extends Notification> notifyType : _supportedNotifications) {
            NotificationInvokerFactory.NotificationInvoker _invoker_1 = reg.getInvoker();
            NotificationListener<Notification> _invocationProxy = _invoker_1.getInvocationProxy();
            this.listeners.remove(notifyType, _invocationProxy);
        }
    }

    @Override
    public void close() {
    }
}

