/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.md.sal.binding.util.AbstractBindingSalProviderInstance;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderInstance;
import org.opendaylight.controller.sal.binding.api.mount.MountProviderService;
import org.opendaylight.controller.sal.binding.impl.DataBrokerImpl;
import org.opendaylight.controller.sal.binding.impl.NotificationBrokerImpl;
import org.opendaylight.controller.sal.binding.impl.RpcProviderRegistryImpl;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountPointManagerImpl
implements MountProviderService {
    public final Logger LOG = LoggerFactory.getLogger(MountPointManagerImpl.class);
    private final ConcurrentMap<InstanceIdentifier<?>, BindingMountPointImpl> mountPoints;
    private final ListenerRegistry<MountProviderService.MountProvisionListener> listeners = ListenerRegistry.create();
    private ListeningExecutorService notificationExecutor;
    private ListeningExecutorService dataCommitExecutor;

    public MountPointManagerImpl() {
        this.mountPoints = new ConcurrentHashMap();
    }

    public ListeningExecutorService getNotificationExecutor() {
        return this.notificationExecutor;
    }

    public void setNotificationExecutor(ListeningExecutorService notificationExecutor) {
        this.notificationExecutor = notificationExecutor;
    }

    public ListeningExecutorService getDataCommitExecutor() {
        return this.dataCommitExecutor;
    }

    public void setDataCommitExecutor(ListeningExecutorService dataCommitExecutor) {
        this.dataCommitExecutor = dataCommitExecutor;
    }

    public synchronized BindingMountPointImpl createMountPoint(InstanceIdentifier<?> path) {
        BindingMountPointImpl potential = (BindingMountPointImpl)((Object)this.mountPoints.get(path));
        if (potential != null) {
            throw new IllegalStateException("Mount point already exists.");
        }
        return this.createOrGetMountPointImpl(path);
    }

    public BindingMountPointImpl createOrGetMountPoint(InstanceIdentifier<?> path) {
        MountProviderInstance potential = this.getMountPoint((InstanceIdentifier)path);
        if (potential != null) {
            return potential;
        }
        return this.createOrGetMountPointImpl(path);
    }

    public BindingMountPointImpl getMountPoint(InstanceIdentifier<?> path) {
        return (BindingMountPointImpl)((Object)this.mountPoints.get(path));
    }

    private synchronized BindingMountPointImpl createOrGetMountPointImpl(InstanceIdentifier<?> path) {
        MountProviderInstance potential = this.getMountPoint((InstanceIdentifier)path);
        if (potential != null) {
            return potential;
        }
        RpcProviderRegistryImpl rpcRegistry = new RpcProviderRegistryImpl("mount");
        NotificationBrokerImpl notificationBroker = new NotificationBrokerImpl();
        notificationBroker.setExecutor((ExecutorService)this.getNotificationExecutor());
        DataBrokerImpl dataBroker = new DataBrokerImpl();
        dataBroker.setExecutor((ExecutorService)this.getDataCommitExecutor());
        BindingMountPointImpl mountInstance = new BindingMountPointImpl(path, rpcRegistry, notificationBroker, dataBroker);
        this.mountPoints.putIfAbsent(path, mountInstance);
        this.notifyMountPointCreated(path);
        return mountInstance;
    }

    private void notifyMountPointCreated(InstanceIdentifier<?> path) {
        for (ListenerRegistration listener : this.listeners) {
            try {
                ((MountProviderService.MountProvisionListener)listener.getInstance()).onMountPointCreated(path);
            }
            catch (Exception e) {
                this.LOG.error("Unhandled exception during invoking listener.", (Throwable)e);
            }
        }
    }

    public ListenerRegistration<MountProviderService.MountProvisionListener> registerProvisionListener(MountProviderService.MountProvisionListener listener) {
        return this.listeners.register((EventListener)listener);
    }

    public class BindingMountPointImpl
    extends AbstractBindingSalProviderInstance<DataBrokerImpl, NotificationBrokerImpl, RpcProviderRegistryImpl>
    implements MountProviderInstance {
        private InstanceIdentifier<?> identifier;

        public BindingMountPointImpl(InstanceIdentifier<?> identifier, RpcProviderRegistryImpl rpcRegistry, NotificationBrokerImpl notificationBroker, DataBrokerImpl dataBroker) {
            super((RpcProviderRegistry)rpcRegistry, (NotificationProviderService)notificationBroker, (DataProviderService)dataBroker);
            this.identifier = identifier;
        }

        public InstanceIdentifier<?> getIdentifier() {
            return this.identifier;
        }
    }
}

