/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.impl;

import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataBroker;
import org.opendaylight.controller.sal.binding.api.data.DataChangeListener;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.controller.sal.binding.impl.DataTransactionImpl;
import org.opendaylight.controller.sal.binding.impl.util.BindingAwareDataReaderRouter;
import org.opendaylight.controller.sal.common.DataStoreIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;

public class DataBrokerImpl
extends AbstractDataBroker<InstanceIdentifier<? extends DataObject>, DataObject, DataChangeListener>
implements DataProviderService,
AutoCloseable {
    private final AtomicLong nextTransaction = new AtomicLong();
    private final AtomicLong createdTransactionsCount = new AtomicLong();

    public AtomicLong getCreatedTransactionsCount() {
        return this.createdTransactionsCount;
    }

    public DataBrokerImpl() {
        this.setDataReadRouter(new BindingAwareDataReaderRouter());
    }

    public DataTransactionImpl beginTransaction() {
        String transactionId = "BA-" + this.nextTransaction.getAndIncrement();
        this.createdTransactionsCount.getAndIncrement();
        return new DataTransactionImpl(transactionId, this);
    }

    @Deprecated
    public <T extends DataRoot> T getData(DataStoreIdentifier store, Class<T> rootType) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public <T extends DataRoot> T getData(DataStoreIdentifier store, T filter) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public <T extends DataRoot> T getCandidateData(DataStoreIdentifier store, Class<T> rootType) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public <T extends DataRoot> T getCandidateData(DataStoreIdentifier store, T filter) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public RpcResult<DataRoot> editCandidateData(DataStoreIdentifier store, DataRoot changeSet) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public Future<RpcResult<Void>> commit(DataStoreIdentifier store) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public DataObject getData(InstanceIdentifier<? extends DataObject> data) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public DataObject getConfigurationData(InstanceIdentifier<?> data) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public void registerChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener changeListener) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public void unregisterChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener changeListener) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Override
    public void close() throws Exception {
    }

    protected boolean isAffectedBy(InstanceIdentifier<? extends DataObject> key, Set<InstanceIdentifier<? extends DataObject>> paths) {
        if (paths.contains(key)) {
            return true;
        }
        for (InstanceIdentifier<? extends DataObject> path : paths) {
            if (!key.containsWildcarded(path)) continue;
            return true;
        }
        return false;
    }
}

