/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.codegen.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javassist.ClassPool;
import org.opendaylight.controller.sal.binding.codegen.RuntimeCodeGenerator;
import org.opendaylight.controller.sal.binding.spi.NotificationInvokerFactory;

public class SingletonHolder {
    public static final ClassPool CLASS_POOL = new ClassPool();
    public static final org.opendaylight.controller.sal.binding.codegen.impl.RuntimeCodeGenerator RPC_GENERATOR_IMPL = new org.opendaylight.controller.sal.binding.codegen.impl.RuntimeCodeGenerator(CLASS_POOL);
    public static final RuntimeCodeGenerator RPC_GENERATOR = RPC_GENERATOR_IMPL;
    public static final NotificationInvokerFactory INVOKER_FACTORY = RPC_GENERATOR_IMPL.getInvokerFactory();
    private static ListeningExecutorService NOTIFICATION_EXECUTOR = null;
    private static ListeningExecutorService COMMIT_EXECUTOR = null;

    public static final synchronized ListeningExecutorService getDefaultNotificationExecutor() {
        if (NOTIFICATION_EXECUTOR == null) {
            NOTIFICATION_EXECUTOR = SingletonHolder.createNamedExecutor("md-sal-binding-notification-%d");
        }
        return NOTIFICATION_EXECUTOR;
    }

    public static final synchronized ListeningExecutorService getDefaultCommitExecutor() {
        if (COMMIT_EXECUTOR == null) {
            COMMIT_EXECUTOR = SingletonHolder.createNamedExecutor("md-sal-binding-commit-%d");
        }
        return COMMIT_EXECUTOR;
    }

    private static ListeningExecutorService createNamedExecutor(String format) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(format).build();
        ExecutorService executor = Executors.newCachedThreadPool(factory);
        return MoreExecutors.listeningDecorator((ExecutorService)executor);
    }
}

