/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.codegen.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangePublisher;
import org.opendaylight.controller.md.sal.common.impl.routing.RoutingUtils;
import org.opendaylight.controller.sal.binding.api.rpc.RpcRoutingTable;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcRoutingTableImpl<C extends BaseIdentity, S extends RpcService>
implements Mutable,
RpcRoutingTable<C, S>,
RouteChangePublisher<Class<? extends BaseIdentity>, InstanceIdentifier<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcRoutingTableImpl.class);
    private final String routerName;
    private final Class<S> serviceType;
    private final Class<C> contextType;
    private final ConcurrentMap<InstanceIdentifier<?>, S> routes;
    private final Map<InstanceIdentifier<?>, S> unmodifiableRoutes;
    private RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>> listener;
    private S defaultRoute;

    public RpcRoutingTableImpl(String routerName, Class<C> contextType, Class<S> serviceType) {
        this.routerName = routerName;
        this.serviceType = serviceType;
        this.contextType = contextType;
        this.routes = new ConcurrentHashMap();
        this.unmodifiableRoutes = Collections.unmodifiableMap(this.routes);
    }

    public void setDefaultRoute(S target) {
        this.defaultRoute = target;
    }

    public S getDefaultRoute() {
        return this.defaultRoute;
    }

    public <L extends RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
        return new SingletonListenerRegistration(this, listener);
    }

    public Class<C> getIdentifier() {
        return this.contextType;
    }

    public void updateRoute(InstanceIdentifier<?> path, S service) {
        RpcService previous = (RpcService)this.routes.put(path, service);
        LOGGER.debug("Route {} updated to {} in routing table {}", new Object[]{path, service, this});
        RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>> listenerCapture = this.listener;
        if (previous == null && listenerCapture != null) {
            listenerCapture.onRouteChange(RoutingUtils.announcementChange(this.contextType, path));
        }
    }

    public void removeRoute(InstanceIdentifier<?> path) {
        RpcService previous = (RpcService)this.routes.remove(path);
        LOGGER.debug("Route {} to {} removed in routing table {}", new Object[]{path, previous, this});
        RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>> listenerCapture = this.listener;
        if (previous != null && listenerCapture != null) {
            listenerCapture.onRouteChange(RoutingUtils.removalChange(this.contextType, path));
        }
    }

    public void removeRoute(InstanceIdentifier<?> path, S service) {
        RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>> listenerCapture = this.listener;
        if (this.routes.remove(path, service) && listenerCapture != null) {
            LOGGER.debug("Route {} to {} removed in routing table {}", new Object[]{path, service, this});
            listenerCapture.onRouteChange(RoutingUtils.removalChange(this.contextType, path));
        }
    }

    public S getRoute(InstanceIdentifier<?> nodeInstance) {
        RpcService route = (RpcService)this.routes.get(nodeInstance);
        if (route != null) {
            return (S)route;
        }
        return this.getDefaultRoute();
    }

    public Map<InstanceIdentifier<?>, S> getRoutes() {
        return this.unmodifiableRoutes;
    }

    protected void removeAllReferences(S service) {
    }

    public String toString() {
        return "RpcRoutingTableImpl [router=" + this.routerName + ", service=" + this.serviceType.getSimpleName() + ", context=" + this.contextType.getSimpleName() + "]";
    }

    private static class SingletonListenerRegistration<L extends RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>>>
    extends AbstractObjectRegistration<L>
    implements ListenerRegistration<L> {
        final /* synthetic */ RpcRoutingTableImpl this$0;

        public SingletonListenerRegistration(L instance) {
            this.this$0 = var1_1;
            super(instance);
            ((RpcRoutingTableImpl)var1_1).listener = instance;
        }

        protected void removeRegistration() {
            this.this$0.listener = null;
        }
    }
}

