/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.codegen.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChange;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.rpc.RpcRouter;
import org.opendaylight.controller.sal.binding.api.rpc.RpcRoutingTable;
import org.opendaylight.controller.sal.binding.codegen.RuntimeCodeHelper;
import org.opendaylight.controller.sal.binding.codegen.impl.RpcRoutingTableImpl;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcRouterCodegenInstance<T extends RpcService>
implements RpcRouter<T>,
RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RpcRouterCodegenInstance.class);
    private T defaultService;
    private final Class<T> serviceType;
    private final T invocationProxy;
    private final Set<Class<? extends BaseIdentity>> contexts;
    private final ListenerRegistry<RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>>> listeners;
    private final Map<Class<? extends BaseIdentity>, RpcRoutingTableImpl<? extends BaseIdentity, T>> routingTables;
    private final String name;

    public RpcRouterCodegenInstance(String name, Class<T> type, T routerImpl, Set<Class<? extends BaseIdentity>> contexts, Set<Class<? extends DataContainer>> inputs) {
        this.name = name;
        this.listeners = ListenerRegistry.create();
        this.serviceType = type;
        this.invocationProxy = routerImpl;
        this.contexts = ImmutableSet.copyOf(contexts);
        HashMap<Class<? extends BaseIdentity>, RpcRoutingTableImpl<? extends BaseIdentity, T>> mutableRoutingTables = new HashMap<Class<? extends BaseIdentity>, RpcRoutingTableImpl<? extends BaseIdentity, T>>();
        for (Class<? extends BaseIdentity> ctx : contexts) {
            RpcRoutingTableImpl<BaseIdentity, T> table = new RpcRoutingTableImpl<BaseIdentity, T>(name, ctx, type);
            Map<InstanceIdentifier<?>, T> invokerView = table.getRoutes();
            RuntimeCodeHelper.setRoutingTable(this.invocationProxy, ctx, invokerView);
            mutableRoutingTables.put(ctx, table);
            table.registerRouteChangeListener(this);
        }
        this.routingTables = ImmutableMap.copyOf(mutableRoutingTables);
    }

    public Class<T> getServiceType() {
        return this.serviceType;
    }

    public T getInvocationProxy() {
        return this.invocationProxy;
    }

    public <C extends BaseIdentity> RpcRoutingTable<C, T> getRoutingTable(Class<C> routeContext) {
        return this.routingTables.get(routeContext);
    }

    public T getDefaultService() {
        return this.defaultService;
    }

    public Set<Class<? extends BaseIdentity>> getContexts() {
        return this.contexts;
    }

    public <L extends RouteChangeListener<Class<? extends BaseIdentity>, InstanceIdentifier<?>>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
        return this.listeners.registerWithType(listener);
    }

    public void onRouteChange(RouteChange<Class<? extends BaseIdentity>, InstanceIdentifier<?>> change) {
        for (ListenerRegistration listener : this.listeners) {
            try {
                ((RouteChangeListener)listener.getInstance()).onRouteChange(change);
            }
            catch (Exception e) {
                LOG.error("Error occured during invoker listener {}", listener.getInstance(), (Object)e);
            }
        }
    }

    public T getService(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
        return this.routingTables.get(context).getRoute(path);
    }

    public BindingAwareBroker.RoutedRpcRegistration<T> addRoutedRpcImplementation(T service) {
        return new RoutedRpcRegistrationImpl(this, service);
    }

    public BindingAwareBroker.RpcRegistration<T> registerDefaultService(T service) {
        RuntimeCodeHelper.setDelegate(this.invocationProxy, service);
        return null;
    }

    private static class RoutedRpcRegistrationImpl
    extends AbstractObjectRegistration<T>
    implements BindingAwareBroker.RoutedRpcRegistration<T> {
        final /* synthetic */ RpcRouterCodegenInstance this$0;

        public RoutedRpcRegistrationImpl(T instance) {
            this.this$0 = var1_1;
            super(instance);
        }

        public Class<T> getServiceType() {
            return this.this$0.serviceType;
        }

        public void registerPath(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
            ((RpcRoutingTableImpl)this.this$0.routingTables.get(context)).updateRoute(path, (RpcService)this.getInstance());
        }

        public void unregisterPath(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
            ((RpcRoutingTableImpl)this.this$0.routingTables.get(context)).removeRoute(path, (RpcService)this.getInstance());
        }

        public void registerInstance(Class<? extends BaseIdentity> context, InstanceIdentifier<?> instance) {
            this.registerPath(context, instance);
        }

        public void unregisterInstance(Class<? extends BaseIdentity> context, InstanceIdentifier<?> instance) {
            this.unregisterPath(context, instance);
        }

        protected void removeRegistration() {
        }
    }
}

