/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.codegen;

import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.opendaylight.controller.sal.binding.codegen.RuntimeCodeSpecification;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;

public class RuntimeCodeHelper {
    public static <T extends RpcService> T getDelegate(RpcService proxy) {
        try {
            Class<?> _class = proxy.getClass();
            Field field = _class.getField("_delegate");
            boolean _equals = Objects.equal((Object)field, null);
            if (_equals) {
                UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Unable to get delegate from proxy");
                throw _unsupportedOperationException;
            }
            try {
                Object _get = field.get(proxy);
                return (T)((RpcService)_get);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        catch (Throwable _e_1) {
            throw Exceptions.sneakyThrow((Throwable)_e_1);
        }
    }

    public static void setDelegate(RpcService proxy, RpcService delegate) {
        try {
            Class<?> _class = proxy.getClass();
            Field field = _class.getField("_delegate");
            boolean _equals = Objects.equal((Object)field, null);
            if (_equals) {
                UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Unable to set delegate to proxy");
                throw _unsupportedOperationException;
            }
            boolean _or = false;
            boolean _equals_1 = Objects.equal((Object)delegate, null);
            if (_equals_1) {
                _or = true;
            } else {
                Class<?> _type = field.getType();
                Class<?> _class_1 = delegate.getClass();
                boolean _isAssignableFrom = _type.isAssignableFrom(_class_1);
                boolean bl = _or = _equals_1 || _isAssignableFrom;
            }
            if (!_or) {
                IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("delegate class is not assignable to proxy");
                throw _illegalArgumentException;
            }
            field.set(proxy, delegate);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void setDelegate(Object proxy, Object delegate) {
        try {
            Class<?> _class = proxy.getClass();
            Field field = _class.getField("_delegate");
            boolean _equals = Objects.equal((Object)field, null);
            if (_equals) {
                UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Unable to set delegate to proxy");
                throw _unsupportedOperationException;
            }
            boolean _or = false;
            boolean _equals_1 = Objects.equal((Object)delegate, null);
            if (_equals_1) {
                _or = true;
            } else {
                Class<?> _type = field.getType();
                Class<?> _class_1 = delegate.getClass();
                boolean _isAssignableFrom = _type.isAssignableFrom(_class_1);
                boolean bl = _or = _equals_1 || _isAssignableFrom;
            }
            if (!_or) {
                IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("delegate class is not assignable to proxy");
                throw _illegalArgumentException;
            }
            field.set(proxy, delegate);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Map<InstanceIdentifier<? extends Object>, ? extends RpcService> getRoutingTable(RpcService target, Class<? extends BaseIdentity> tableClass) {
        try {
            Class<?> _class = target.getClass();
            String _routingTableField = RuntimeCodeSpecification.getRoutingTableField(tableClass);
            Field field = _class.getField(_routingTableField);
            boolean _equals = Objects.equal((Object)field, null);
            if (_equals) {
                UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Unable to get routing table. Table field does not exists");
                throw _unsupportedOperationException;
            }
            try {
                Object _get = field.get(target);
                return (Map)_get;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        catch (Throwable _e_1) {
            throw Exceptions.sneakyThrow((Throwable)_e_1);
        }
    }

    public static void setRoutingTable(RpcService target, Class<? extends BaseIdentity> tableClass, Map<InstanceIdentifier<? extends Object>, ? extends RpcService> routingTable) {
        try {
            Class<?> _class = target.getClass();
            String _routingTableField = RuntimeCodeSpecification.getRoutingTableField(tableClass);
            Field field = _class.getField(_routingTableField);
            boolean _equals = Objects.equal((Object)field, null);
            if (_equals) {
                UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException("Unable to set routing table. Table field does not exists");
                throw _unsupportedOperationException;
            }
            field.set(target, routingTable);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

