/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.AbstractRuntimeMappingModule;
import org.opendaylight.controller.sal.binding.codegen.impl.SingletonHolder;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.sal.binding.generator.impl.RuntimeGeneratedMappingServiceImpl;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.CodecRegistry;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.opendaylight.yangtools.yang.model.api.SchemaServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class RuntimeMappingModule
extends AbstractRuntimeMappingModule {
    private BundleContext bundleContext;

    public RuntimeMappingModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public RuntimeMappingModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, RuntimeMappingModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull((Object)this.bundleContext);
    }

    @Override
    public boolean canReuseInstance(AbstractRuntimeMappingModule oldModule) {
        return true;
    }

    @Override
    public AutoCloseable createInstance() {
        RuntimeGeneratedMappingServiceProxy potential = this.tryToReuseGlobalInstance();
        if (potential != null) {
            return potential;
        }
        RuntimeGeneratedMappingServiceImpl service = new RuntimeGeneratedMappingServiceImpl();
        service.setPool(SingletonHolder.CLASS_POOL);
        service.init();
        this.bundleContext.registerService(SchemaServiceListener.class, (Object)service, new Hashtable());
        return service;
    }

    private RuntimeGeneratedMappingServiceProxy tryToReuseGlobalInstance() {
        ServiceReference serviceRef = this.getBundleContext().getServiceReference(BindingIndependentMappingService.class);
        if (serviceRef == null) {
            return null;
        }
        BindingIndependentMappingService delegate = (BindingIndependentMappingService)this.bundleContext.getService(serviceRef);
        if (delegate == null) {
            return null;
        }
        return new RuntimeGeneratedMappingServiceProxy(this.getBundleContext(), (ServiceReference<BindingIndependentMappingService>)serviceRef, delegate);
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static final class RuntimeGeneratedMappingServiceProxy
    implements BindingIndependentMappingService,
    Delegator<BindingIndependentMappingService>,
    AutoCloseable {
        private BindingIndependentMappingService delegate;
        private ServiceReference<BindingIndependentMappingService> reference;
        private BundleContext bundleContext;

        public RuntimeGeneratedMappingServiceProxy(BundleContext bundleContext, ServiceReference<BindingIndependentMappingService> serviceRef, BindingIndependentMappingService delegate) {
            this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
            this.reference = (ServiceReference)Preconditions.checkNotNull(serviceRef);
            this.delegate = (BindingIndependentMappingService)Preconditions.checkNotNull((Object)delegate);
        }

        public CodecRegistry getCodecRegistry() {
            return this.delegate.getCodecRegistry();
        }

        public CompositeNode toDataDom(DataObject data) {
            return this.delegate.toDataDom(data);
        }

        public Map.Entry<InstanceIdentifier, CompositeNode> toDataDom(Map.Entry<org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject>, DataObject> entry) {
            return this.delegate.toDataDom(entry);
        }

        public InstanceIdentifier toDataDom(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path) {
            return this.delegate.toDataDom(path);
        }

        public DataObject dataObjectFromDataDom(org.opendaylight.yangtools.yang.binding.InstanceIdentifier<? extends DataObject> path, CompositeNode result) throws DeserializationException {
            return this.delegate.dataObjectFromDataDom(path, result);
        }

        public org.opendaylight.yangtools.yang.binding.InstanceIdentifier<?> fromDataDom(InstanceIdentifier entry) throws DeserializationException {
            return this.delegate.fromDataDom(entry);
        }

        public Set<QName> getRpcQNamesFor(Class<? extends RpcService> service) {
            return this.delegate.getRpcQNamesFor(service);
        }

        public DataContainer dataObjectFromDataDom(Class<? extends DataContainer> inputClass, CompositeNode domInput) {
            return this.delegate.dataObjectFromDataDom(inputClass, domInput);
        }

        @Override
        public void close() throws Exception {
            if (this.delegate != null) {
                this.delegate = null;
                this.bundleContext.ungetService(this.reference);
                this.bundleContext = null;
                this.reference = null;
            }
        }

        public BindingIndependentMappingService getDelegate() {
            return this.delegate;
        }
    }
}

