/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.binding.impl;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.AbstractDataBrokerImplModule;
import org.opendaylight.controller.sal.binding.codegen.impl.SingletonHolder;
import org.opendaylight.controller.sal.binding.impl.RootDataBrokerImpl;
import org.opendaylight.controller.sal.binding.impl.connect.dom.BindingDomConnectorDeployer;
import org.opendaylight.controller.sal.binding.impl.connect.dom.BindingIndependentConnector;
import org.opendaylight.controller.sal.binding.impl.forward.DomForwardedDataBrokerImpl;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class DataBrokerImplModule
extends AbstractDataBrokerImplModule {
    private BundleContext bundleContext;

    public DataBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public DataBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, DataBrokerImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public AutoCloseable createInstance() {
        ListeningExecutorService listeningExecutor = SingletonHolder.getDefaultCommitExecutor();
        BindingIndependentMappingService potentialMapping = this.resolveMappingServiceDependency();
        RootDataBrokerImpl dataBindingBroker = this.getDomBrokerDependency() != null && potentialMapping != null ? this.createDomConnectedBroker((ExecutorService)listeningExecutor, potentialMapping) : this.createStandAloneBroker((ExecutorService)listeningExecutor);
        dataBindingBroker.registerRuntimeBean(this.getRootRuntimeBeanRegistratorWrapper());
        return dataBindingBroker;
    }

    private BindingIndependentMappingService resolveMappingServiceDependency() {
        if (this.getMappingService() != null) {
            return this.getMappingServiceDependency();
        }
        ServiceReference potentialMappingService = this.bundleContext.getServiceReference(BindingIndependentMappingService.class);
        if (potentialMappingService != null) {
            return (BindingIndependentMappingService)this.bundleContext.getService(potentialMappingService);
        }
        return null;
    }

    private RootDataBrokerImpl createStandAloneBroker(ExecutorService listeningExecutor) {
        RootDataBrokerImpl broker = new RootDataBrokerImpl();
        broker.setExecutor(listeningExecutor);
        return broker;
    }

    private RootDataBrokerImpl createDomConnectedBroker(ExecutorService listeningExecutor, BindingIndependentMappingService mappingService) {
        DomForwardedDataBrokerImpl forwardedBroker = new DomForwardedDataBrokerImpl();
        forwardedBroker.setExecutor(listeningExecutor);
        BindingIndependentConnector connector = BindingDomConnectorDeployer.createConnector(mappingService);
        this.getDomBrokerDependency().registerProvider((Provider)forwardedBroker, this.getBundleContext());
        Broker.ProviderSession domContext = forwardedBroker.getDomProviderContext();
        forwardedBroker.setConnector(connector);
        forwardedBroker.setDomProviderContext(domContext);
        forwardedBroker.startForwarding();
        return forwardedBroker;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext2) {
        this.bundleContext = bundleContext2;
    }
}

