/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.binding.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.AbstractBindingBrokerImplModule;
import org.opendaylight.controller.sal.binding.codegen.impl.SingletonHolder;
import org.opendaylight.controller.sal.binding.impl.RootBindingAwareBroker;
import org.opendaylight.controller.sal.binding.impl.RpcProviderRegistryImpl;
import org.opendaylight.controller.sal.binding.impl.forward.DomForwardedBindingBrokerImpl;
import org.opendaylight.controller.sal.binding.impl.forward.DomForwardingUtils;
import org.osgi.framework.BundleContext;

public final class BindingBrokerImplModule
extends AbstractBindingBrokerImplModule {
    private BundleContext bundleContext;

    public BindingBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public BindingBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, BindingBrokerImplModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public AutoCloseable createInstance() {
        RootBindingAwareBroker broker = DomForwardingUtils.isDomForwardedBroker(this.getDataBrokerDependency()) ? this.createForwardedBroker() : this.createStandaloneBroker();
        broker.start();
        return broker;
    }

    private RootBindingAwareBroker createStandaloneBroker() {
        RootBindingAwareBroker broker = new RootBindingAwareBroker(this.getIdentifier().getInstanceName());
        broker.setDataBroker(this.getDataBrokerDependency());
        broker.setNotificationBroker(this.getNotificationServiceDependency());
        broker.setRpcBroker(new RpcProviderRegistryImpl(broker.getIdentifier()));
        return broker;
    }

    private RootBindingAwareBroker createForwardedBroker() {
        DomForwardedBindingBrokerImpl broker = new DomForwardedBindingBrokerImpl(this.getIdentifier().getInstanceName());
        broker.setDataBroker(this.getDataBrokerDependency());
        broker.setNotificationBroker(this.getNotificationServiceDependency());
        broker.setRpcBroker(new RpcProviderRegistryImpl(broker.getIdentifier()));
        broker.getMountManager().setDataCommitExecutor(SingletonHolder.getDefaultCommitExecutor());
        broker.getMountManager().setNotificationExecutor(SingletonHolder.getDefaultNotificationExecutor());
        DomForwardingUtils.reuseForwardingFrom((Object)broker, broker.getDataBroker());
        broker.startForwarding();
        return broker;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

