/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.binding.impl;

import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.md.sal.binding.DataBrokerServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.DataProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.BindingIndependentMappingServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.DataBrokerImplModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.DataBrokerImplRuntimeRegistrator;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataBrokerImplModule
implements Module,
DataBrokerImplModuleMXBean,
DataBrokerServiceServiceInterface,
DataProviderServiceServiceInterface,
RuntimeBeanRegistratorAwareModule {
    protected final JmxAttribute domBrokerJmxAttribute = new JmxAttribute("DomBroker");
    private ObjectName domBroker;
    protected final JmxAttribute mappingServiceJmxAttribute = new JmxAttribute("MappingService");
    private ObjectName mappingService;
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataBrokerImplModule.class);
    private final AbstractDataBrokerImplModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private DataBrokerImplRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private Broker domBrokerDependency;
    private BindingIndependentMappingService mappingServiceDependency;

    public AbstractDataBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractDataBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractDataBrokerImplModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public ObjectName getDomBroker() {
        return this.domBroker;
    }

    @Override
    @RequireInterface(value=BrokerServiceInterface.class)
    public void setDomBroker(ObjectName domBroker) {
        this.domBroker = domBroker;
    }

    @Override
    public ObjectName getMappingService() {
        return this.mappingService;
    }

    @Override
    @RequireInterface(value=BindingIndependentMappingServiceServiceInterface.class)
    public void setMappingService(ObjectName mappingService) {
        this.mappingService = mappingService;
    }

    public DataBrokerImplRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new DataBrokerImplRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(BrokerServiceInterface.class, this.domBroker, this.domBrokerJmxAttribute);
        this.dependencyResolver.validateDependency(BindingIndependentMappingServiceServiceInterface.class, this.mappingService, this.mappingServiceJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final Broker getDomBrokerDependency() {
        return this.domBrokerDependency;
    }

    protected final BindingIndependentMappingService getMappingServiceDependency() {
        return this.mappingServiceDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.domBrokerDependency = (Broker)this.dependencyResolver.resolveInstance(Broker.class, this.domBroker, this.domBrokerJmxAttribute);
            this.mappingServiceDependency = (BindingIndependentMappingService)this.dependencyResolver.resolveInstance(BindingIndependentMappingService.class, this.mappingService, this.mappingServiceJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractDataBrokerImplModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractDataBrokerImplModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.domBrokerDependency != other.domBrokerDependency) {
            return false;
        }
        return this.mappingServiceDependency == other.mappingServiceDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataBrokerImplModule that = (AbstractDataBrokerImplModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

