/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.md.sal.binding.impl;

import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.md.sal.binding.BindingAwareBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.DataProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.NotificationProviderServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.RpcProviderRegistryServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.BindingBrokerImplModuleMXBean;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBindingBrokerImplModule
implements Module,
BindingBrokerImplModuleMXBean,
BindingAwareBrokerServiceInterface,
RpcProviderRegistryServiceInterface {
    protected final JmxAttribute notificationServiceJmxAttribute = new JmxAttribute("NotificationService");
    private ObjectName notificationService;
    protected final JmxAttribute dataBrokerJmxAttribute = new JmxAttribute("DataBroker");
    private ObjectName dataBroker;
    private static final Logger logger = LoggerFactory.getLogger(AbstractBindingBrokerImplModule.class);
    private final AbstractBindingBrokerImplModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private NotificationProviderService notificationServiceDependency;
    private DataProviderService dataBrokerDependency;

    public AbstractBindingBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractBindingBrokerImplModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractBindingBrokerImplModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public ObjectName getNotificationService() {
        return this.notificationService;
    }

    @Override
    @RequireInterface(value=NotificationProviderServiceServiceInterface.class)
    public void setNotificationService(ObjectName notificationService) {
        this.notificationService = notificationService;
    }

    @Override
    public ObjectName getDataBroker() {
        return this.dataBroker;
    }

    @Override
    @RequireInterface(value=DataProviderServiceServiceInterface.class)
    public void setDataBroker(ObjectName dataBroker) {
        this.dataBroker = dataBroker;
    }

    public void validate() {
        this.dependencyResolver.validateDependency(NotificationProviderServiceServiceInterface.class, this.notificationService, this.notificationServiceJmxAttribute);
        this.dependencyResolver.validateDependency(DataProviderServiceServiceInterface.class, this.dataBroker, this.dataBrokerJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final NotificationProviderService getNotificationServiceDependency() {
        return this.notificationServiceDependency;
    }

    protected final DataProviderService getDataBrokerDependency() {
        return this.dataBrokerDependency;
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            this.notificationServiceDependency = (NotificationProviderService)this.dependencyResolver.resolveInstance(NotificationProviderService.class, this.notificationService, this.notificationServiceJmxAttribute);
            this.dataBrokerDependency = (DataProviderService)this.dependencyResolver.resolveInstance(DataProviderService.class, this.dataBroker, this.dataBrokerJmxAttribute);
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractBindingBrokerImplModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractBindingBrokerImplModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.notificationServiceDependency != other.notificationServiceDependency) {
            return false;
        }
        return this.dataBrokerDependency == other.dataBrokerDependency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBindingBrokerImplModule that = (AbstractBindingBrokerImplModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

