/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker.northbound;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.hosttracker.northbound.HostConfig;
import org.opendaylight.controller.hosttracker.northbound.Hosts;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.switchmanager.ISwitchManager;

@Path(value="/")
public class HostTrackerNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private IfIptoHost getIfIpToHostService(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        boolean found = false;
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new ResourceNotFoundException(containerName + " " + RestMessages.NOCONTAINER.toString());
        }
        IfIptoHost hostTracker = (IfIptoHost)ServiceHelper.getInstance(IfIptoHost.class, (String)containerName, (Object)this);
        if (hostTracker == null) {
            throw new ServiceUnavailableException("Host Tracker " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return hostTracker;
    }

    private Hosts convertHosts(Set<HostNodeConnector> hostNodeConnectors) {
        if (hostNodeConnectors == null) {
            return null;
        }
        HashSet<HostConfig> hosts = new HashSet<HostConfig>();
        for (HostNodeConnector hnc : hostNodeConnectors) {
            hosts.add(HostConfig.convert(hnc));
        }
        return new Hosts(hosts);
    }

    @Path(value="/{containerName}/hosts/active")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Hosts.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public Hosts getActiveHosts(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        IfIptoHost hostTracker = this.getIfIpToHostService(containerName);
        return this.convertHosts(hostTracker.getAllHosts());
    }

    @Path(value="/{containerName}/hosts/inactive")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Hosts.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public Hosts getInactiveHosts(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        IfIptoHost hostTracker = this.getIfIpToHostService(containerName);
        return this.convertHosts(hostTracker.getInactiveStaticHosts());
    }

    @Path(value="/{containerName}/address/{networkAddress}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=HostConfig.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Invalid IP specified in networkAddress parameter"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public HostConfig getHostDetails(@PathParam(value="containerName") String containerName, @PathParam(value="networkAddress") String networkAddress) {
        InetAddress ip;
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        IfIptoHost hostTracker = this.getIfIpToHostService(containerName);
        try {
            ip = InetAddress.getByName(networkAddress);
        }
        catch (UnknownHostException e) {
            throw new BadRequestException(RestMessages.INVALIDADDRESS.toString() + " " + networkAddress);
        }
        for (HostNodeConnector host : hostTracker.getAllHosts()) {
            if (!host.getNetworkAddress().equals(ip)) continue;
            return HostConfig.convert(host);
        }
        throw new ResourceNotFoundException(RestMessages.NOHOST.toString());
    }

    @Path(value="/{containerName}/address/{networkAddress}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Static host created successfully"), @ResponseCode(code=400, condition="Invalid parameters specified, see response body for details"), @ResponseCode(code=404, condition="The container or resource is not found"), @ResponseCode(code=409, condition="Resource conflict, see response body for details"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response addHost(@Context UriInfo uriInfo, @PathParam(value="containerName") String containerName, @PathParam(value="networkAddress") String networkAddress, @TypeHint(value=HostConfig.class) HostConfig hostConfig) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("User is not authorized to perform this operation on container " + containerName)).build();
        }
        this.handleDefaultDisabled(containerName);
        IfIptoHost hostTracker = this.getIfIpToHostService(containerName);
        HostConfig hc = hostConfig;
        if (!networkAddress.equals(hc.getNetworkAddress())) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Resource name in config object doesn't match URI").build();
        }
        if (!hc.isStaticHost()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Can only add static host.").build();
        }
        Node node = this.handleNodeAvailability(containerName, hc.getNodeType(), hc.getNodeId());
        NodeConnector nc = NodeConnector.fromStringNoNode((String)hc.getNodeConnectorType(), (String)hc.getNodeConnectorId(), (Node)node);
        Status status = hostTracker.addStaticHost(networkAddress, hc.getDataLayerAddress(), nc, hc.getVlan());
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Static Host", (String)this.username, (String)"added", (String)networkAddress, (String)containerName);
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/address/{networkAddress}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=204, condition="Static host deleted successfully"), @ResponseCode(code=404, condition="The container or a specified resource was not found"), @ResponseCode(code=406, condition="Cannot operate on Default Container when other Containers are active"), @ResponseCode(code=503, condition="One or more of Controller service is unavailable")})
    public Response deleteHost(@PathParam(value="containerName") String containerName, @PathParam(value="networkAddress") String networkAddress) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("User is not authorized to perform this operation on container " + containerName)).build();
        }
        this.handleDefaultDisabled(containerName);
        IfIptoHost hostTracker = this.getIfIpToHostService(containerName);
        Status status = hostTracker.removeStaticHost(networkAddress);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Static Host", (String)this.username, (String)"removed", (String)networkAddress, (String)containerName);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    private void handleDefaultDisabled(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException(RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (containerName.equals(GlobalConstants.DEFAULT.toString()) && containerManager.hasNonDefaultContainer()) {
            throw new ResourceConflictException(RestMessages.DEFAULTDISABLED.toString());
        }
    }

    private Node handleNodeAvailability(String containerName, String nodeType, String nodeId) {
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        if (node == null) {
            throw new ResourceNotFoundException(nodeId + " : " + RestMessages.NONODE.toString());
        }
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (sm == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!sm.getNodes().contains(node)) {
            throw new ResourceNotFoundException(node.toString() + " : " + RestMessages.NONODE.toString());
        }
        return node;
    }
}

