/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.felix.service.command.Descriptor;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.osgi.framework.ServiceRegistration;

public class SwitchManagerCLI {
    private ServiceRegistration sr = null;

    public void init() {
    }

    public void destroy() {
    }

    public void start() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", "odpcontroller");
        ((Dictionary)props).put("osgi.command.function", new String[]{"showNodes", "showNodeConnectors"});
        this.sr = ServiceHelper.registerGlobalServiceWReg(SwitchManagerCLI.class, (Object)this, props);
    }

    public void stop() {
        if (this.sr != null) {
            this.sr.unregister();
            this.sr = null;
        }
    }

    @Descriptor(value="Retrieves the nodes information present in Switch Manager DB")
    public void showNodes(@Descriptor(value="Container in which to query Switch Manager") String container) {
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)container, (Object)this);
        if (sm == null) {
            System.out.println("Cannot find the switch manager instance on container: " + container);
            return;
        }
        Set nodes = sm.getNodes();
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        HashSet propertyList = new HashSet();
        for (Node node : nodes) {
            Map propList = sm.getNodeProps(node);
            propertyList.addAll(propList.keySet());
        }
        ArrayList sortedProps = new ArrayList(propertyList);
        Collections.sort(sortedProps);
        String properties = String.format("%-26s  ", "Node");
        for (String s : sortedProps) {
            properties = properties.concat(String.format("%-18s ", s));
        }
        System.out.println(properties);
        for (Node node : nodes) {
            String nodeProp = String.format("%-26s  ", node);
            Map propList = sm.getNodeProps(node);
            for (String s : sortedProps) {
                if (propList.containsKey(s)) {
                    nodeProp = nodeProp.concat(String.format("%-18s ", ((Property)propList.get(s)).getStringValue()));
                    continue;
                }
                nodeProp = nodeProp.concat(String.format("%-18s ", "null"));
            }
            System.out.println(nodeProp);
        }
        System.out.println("Total number of Nodes: " + nodes.size());
    }

    @Descriptor(value="Retrieves the node connectors information present in Switch Manager DB for the specified node")
    public void showNodeConnectors(@Descriptor(value="Container in which to query Switch Manager") String container, @Descriptor(value="String representation of the Node, this need to be consumable from Node.fromString()") String node) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (sm == null) {
            System.out.println("Cannot find the switch manager instance on container: " + containerName);
            return;
        }
        Node target = Node.fromString((String)node);
        if (target == null) {
            System.out.println("Please enter a valid node id");
            return;
        }
        Set nodeConnectorSet = sm.getNodeConnectors(target);
        if (nodeConnectorSet == null || nodeConnectorSet.isEmpty()) {
            return;
        }
        HashSet propertyList = new HashSet();
        for (NodeConnector nodeConnector : nodeConnectorSet) {
            Map propList = sm.getNodeConnectorProps(nodeConnector);
            propertyList.addAll(propList.keySet());
        }
        ArrayList sortedProps = new ArrayList(propertyList);
        Collections.sort(sortedProps);
        String properties = String.format("%-33s  ", "NodeConnector");
        for (String s : sortedProps) {
            properties = properties.concat(String.format("%-18s ", s));
        }
        System.out.println(properties);
        for (NodeConnector nodeConnector : nodeConnectorSet) {
            String ncProp = String.format("%-33s  ", nodeConnector);
            Map ncProperties = sm.getNodeConnectorProps(nodeConnector);
            for (String s : sortedProps) {
                if (ncProperties.containsKey(s)) {
                    ncProp = ncProp.concat(String.format("%-18s ", ((Property)ncProperties.get(s)).getStringValue()));
                    continue;
                }
                ncProp = ncProp.concat(String.format("%-18s ", "null"));
            }
            System.out.println(ncProp);
        }
        System.out.println("Total number of NodeConnectors: " + nodeConnectorSet.size());
    }
}

