/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.dm.Component;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.sal.core.Bandwidth;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.ForwardingMode;
import org.opendaylight.controller.sal.core.MacAddress;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.Tier;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.inventory.IInventoryService;
import org.opendaylight.controller.sal.inventory.IListenInventoryUpdates;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.statisticsmanager.IStatisticsManager;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISpanAware;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.ISwitchManagerAware;
import org.opendaylight.controller.switchmanager.SpanConfig;
import org.opendaylight.controller.switchmanager.Subnet;
import org.opendaylight.controller.switchmanager.SubnetConfig;
import org.opendaylight.controller.switchmanager.Switch;
import org.opendaylight.controller.switchmanager.SwitchConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchManager
implements ISwitchManager,
IConfigurationContainerAware,
IObjectReader,
IListenInventoryUpdates,
CommandProvider {
    private static Logger log = LoggerFactory.getLogger(SwitchManager.class);
    private static final String SUBNETS_FILE_NAME = "subnets.conf";
    private static final String SPAN_FILE_NAME = "spanPorts.conf";
    private static final String SWITCH_CONFIG_FILE_NAME = "switchConfig.conf";
    private final List<NodeConnector> spanNodeConnectors = new CopyOnWriteArrayList<NodeConnector>();
    private ConcurrentMap<InetAddress, Subnet> subnets;
    private ConcurrentMap<String, SubnetConfig> subnetsConfigList;
    private ConcurrentMap<SpanConfig, SpanConfig> spanConfigList;
    private ConcurrentMap<String, SwitchConfig> nodeConfigList;
    private ConcurrentMap<Node, Map<String, Property>> nodeProps;
    private ConcurrentMap<NodeConnector, Map<String, Property>> nodeConnectorProps;
    private ConcurrentMap<Node, Map<String, NodeConnector>> nodeConnectorNames;
    private ConcurrentMap<String, Property> controllerProps;
    private IInventoryService inventoryService;
    private IStatisticsManager statisticsManager;
    private IConfigurationContainerService configurationService;
    private final Set<ISwitchManagerAware> switchManagerAware = Collections.synchronizedSet(new HashSet());
    private final Set<IInventoryListener> inventoryListeners = Collections.synchronizedSet(new HashSet());
    private final Set<ISpanAware> spanAware = Collections.synchronizedSet(new HashSet());
    private IClusterContainerServices clusterContainerService = null;
    private String containerName = null;
    private boolean isDefaultContainer = true;
    private static final int REPLACE_RETRY = 1;
    protected static final SubnetConfig DEFAULT_SUBNETCONFIG = new SubnetConfig("default (cannot be modifed)", "0.0.0.0/0", new ArrayList());
    protected static final Subnet DEFAULT_SUBNET = new Subnet(DEFAULT_SUBNETCONFIG);
    protected static final String DEFAULT_SUBNET_NAME = "default (cannot be modifed)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySubnetChange(Subnet sub, boolean add) {
        Set<ISwitchManagerAware> set = this.switchManagerAware;
        synchronized (set) {
            for (ISwitchManagerAware subAware : this.switchManagerAware) {
                try {
                    subAware.subnetNotify(sub, add);
                }
                catch (Exception e) {
                    log.error("Failed to notify Subnet change {}", (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySpanPortChange(Node node, List<NodeConnector> ports, boolean add) {
        Set<ISpanAware> set = this.spanAware;
        synchronized (set) {
            for (ISpanAware sa : this.spanAware) {
                try {
                    sa.spanUpdate(node, ports, add);
                }
                catch (Exception e) {
                    log.error("Failed to notify Span Interface change {}", (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyModeChange(Node node, boolean proactive) {
        Set<ISwitchManagerAware> set = this.switchManagerAware;
        synchronized (set) {
            for (ISwitchManagerAware service : this.switchManagerAware) {
                try {
                    service.modeChangeNotify(node, proactive);
                }
                catch (Exception e) {
                    log.error("Failed to notify Subnet change {}", (Object)e.getMessage());
                }
            }
        }
    }

    public void startUp() {
        Property existing;
        byte[] controllerMac;
        this.allocateCaches();
        this.retrieveCaches();
        if (!this.controllerProps.containsKey("macAddress") && (controllerMac = this.getHardwareMAC()) != null && (existing = this.controllerProps.putIfAbsent("macAddress", (Property)new MacAddress(controllerMac))) == null && log.isTraceEnabled()) {
            log.trace("Container {}: Setting controller MAC address in the cluster: {}", (Object)this.getContainerName(), (Object)HexEncode.bytesToHexStringFormat((byte[])controllerMac));
        }
    }

    public void shutDown() {
    }

    private void allocateCaches() {
        if (this.clusterContainerService == null) {
            this.nonClusterObjectCreate();
            log.warn("un-initialized clusterContainerService, can't create cache");
            return;
        }
        try {
            this.clusterContainerService.createCache("switchmanager.subnetsConfigList", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.spanConfigList", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.nodeConfigList", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.subnets", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.nodeProps", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.nodeConnectorProps", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.nodeConnectorNames", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("switchmanager.controllerProps", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            log.error("\nCache configuration invalid - check cache mode");
        }
        catch (CacheExistException ce) {
            log.error("\nCache already exits - destroy and recreate if needed");
        }
    }

    private void retrieveCaches() {
        if (this.clusterContainerService == null) {
            log.warn("un-initialized clusterContainerService, can't create cache");
            return;
        }
        this.subnetsConfigList = this.clusterContainerService.getCache("switchmanager.subnetsConfigList");
        if (this.subnetsConfigList == null) {
            log.error("\nFailed to get cache for subnetsConfigList");
        }
        this.spanConfigList = this.clusterContainerService.getCache("switchmanager.spanConfigList");
        if (this.spanConfigList == null) {
            log.error("\nFailed to get cache for spanConfigList");
        }
        this.nodeConfigList = this.clusterContainerService.getCache("switchmanager.nodeConfigList");
        if (this.nodeConfigList == null) {
            log.error("\nFailed to get cache for nodeConfigList");
        }
        this.subnets = this.clusterContainerService.getCache("switchmanager.subnets");
        if (this.subnets == null) {
            log.error("\nFailed to get cache for subnets");
        }
        this.nodeProps = this.clusterContainerService.getCache("switchmanager.nodeProps");
        if (this.nodeProps == null) {
            log.error("\nFailed to get cache for nodeProps");
        }
        this.nodeConnectorProps = this.clusterContainerService.getCache("switchmanager.nodeConnectorProps");
        if (this.nodeConnectorProps == null) {
            log.error("\nFailed to get cache for nodeConnectorProps");
        }
        this.nodeConnectorNames = this.clusterContainerService.getCache("switchmanager.nodeConnectorNames");
        if (this.nodeConnectorNames == null) {
            log.error("\nFailed to get cache for nodeConnectorNames");
        }
        this.controllerProps = this.clusterContainerService.getCache("switchmanager.controllerProps");
        if (this.controllerProps == null) {
            log.error("\nFailed to get cache for controllerProps");
        }
    }

    private void nonClusterObjectCreate() {
        this.subnetsConfigList = new ConcurrentHashMap<String, SubnetConfig>();
        this.spanConfigList = new ConcurrentHashMap<SpanConfig, SpanConfig>();
        this.nodeConfigList = new ConcurrentHashMap<String, SwitchConfig>();
        this.subnets = new ConcurrentHashMap<InetAddress, Subnet>();
        this.nodeProps = new ConcurrentHashMap<Node, Map<String, Property>>();
        this.nodeConnectorProps = new ConcurrentHashMap<NodeConnector, Map<String, Property>>();
        this.nodeConnectorNames = new ConcurrentHashMap<Node, Map<String, NodeConnector>>();
        this.controllerProps = new ConcurrentHashMap<String, Property>();
    }

    public List<SubnetConfig> getSubnetsConfigList() {
        if (this.subnetsConfigList.size() == 0) {
            return Collections.singletonList(DEFAULT_SUBNETCONFIG);
        }
        return new ArrayList<SubnetConfig>(this.subnetsConfigList.values());
    }

    public SubnetConfig getSubnetConfig(String subnet) {
        if (this.subnetsConfigList.isEmpty() && subnet.equalsIgnoreCase(DEFAULT_SUBNET_NAME)) {
            return DEFAULT_SUBNETCONFIG;
        }
        return (SubnetConfig)this.subnetsConfigList.get(subnet);
    }

    private List<SpanConfig> getSpanConfigList(Node node) {
        ArrayList<SpanConfig> confList = new ArrayList<SpanConfig>();
        String nodeId = node.toString();
        for (SpanConfig conf : this.spanConfigList.values()) {
            if (!conf.matchNode(nodeId)) continue;
            confList.add(conf);
        }
        return confList;
    }

    public List<SwitchConfig> getNodeConfigList() {
        return new ArrayList<SwitchConfig>(this.nodeConfigList.values());
    }

    public SwitchConfig getSwitchConfig(String switchId) {
        return (SwitchConfig)this.nodeConfigList.get(switchId);
    }

    public Switch getSwitchByNode(Node node) {
        Switch sw = new Switch(node);
        sw.setNode(node);
        MacAddress mac = (MacAddress)this.getNodeProp(node, "macAddress");
        if (mac != null) {
            sw.setDataLayerAddress(mac.getMacAddress());
        }
        Set<NodeConnector> ncSet = this.getPhysicalNodeConnectors(node);
        sw.setNodeConnectors(ncSet);
        ArrayList<NodeConnector> ncList = new ArrayList<NodeConnector>();
        for (NodeConnector nodeConnector : ncSet) {
            if (!this.spanNodeConnectors.contains(nodeConnector)) continue;
            ncList.add(nodeConnector);
        }
        sw.addSpanPorts(ncList);
        return sw;
    }

    public List<Switch> getNetworkDevices() {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        for (Node node : this.getNodes()) {
            swList.add(this.getSwitchByNode(node));
        }
        return swList;
    }

    private Status updateConfig(SubnetConfig conf, boolean add) {
        if (add) {
            if (this.subnetsConfigList.putIfAbsent(conf.getName(), conf) != null) {
                String msg = "Cluster conflict: Subnet with name " + conf.getName() + "already exists.";
                return new Status(StatusCode.CONFLICT, msg);
            }
        } else {
            this.subnetsConfigList.remove(conf.getName());
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status updateDatabase(SubnetConfig conf, boolean add) {
        if (add) {
            Subnet subnetCurr = (Subnet)this.subnets.get(conf.getIPAddress());
            Subnet subnet = subnetCurr == null ? new Subnet(conf) : subnetCurr.clone();
            if (!conf.isGlobal()) {
                subnet.addNodeConnectors(conf.getNodeConnectors());
            }
            boolean putNewSubnet = false;
            if (subnetCurr == null) {
                if (this.subnets.putIfAbsent(conf.getIPAddress(), subnet) == null) {
                    putNewSubnet = true;
                }
            } else {
                putNewSubnet = this.subnets.replace(conf.getIPAddress(), subnetCurr, subnet);
            }
            if (!putNewSubnet) {
                String msg = "Cluster conflict: Conflict while adding the subnet " + conf.getIPAddress();
                return new Status(StatusCode.CONFLICT, msg);
            }
        } else {
            this.subnets.remove(conf.getIPAddress());
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status semanticCheck(SubnetConfig conf) {
        Set IPs = this.subnets.keySet();
        if (IPs == null) {
            return new Status(StatusCode.SUCCESS);
        }
        Subnet newSubnet = new Subnet(conf);
        for (InetAddress i : IPs) {
            Subnet existingSubnet = (Subnet)this.subnets.get(i);
            if (existingSubnet == null || existingSubnet.isMutualExclusive(newSubnet)) continue;
            return new Status(StatusCode.CONFLICT, "This subnet conflicts with an existing one.");
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status addRemoveSubnet(SubnetConfig conf, boolean isAdding) {
        Status status = conf.validate();
        if (!status.isSuccess()) {
            log.warn(status.getDescription());
            return status;
        }
        if (isAdding) {
            if (this.subnetsConfigList.containsKey(conf.getName())) {
                return new Status(StatusCode.CONFLICT, "Subnet with the specified name already exists.");
            }
            status = this.semanticCheck(conf);
            if (!status.isSuccess()) {
                return status;
            }
        } else if (conf.getName().equalsIgnoreCase(DEFAULT_SUBNET_NAME)) {
            return new Status(StatusCode.NOTALLOWED, "The specified subnet gateway cannot be removed");
        }
        if ((status = this.updateDatabase(conf, isAdding)).isSuccess()) {
            status = this.updateConfig(conf, isAdding);
            if (!status.isSuccess()) {
                this.updateDatabase(conf, !isAdding);
            } else {
                Subnet subnetCurr = (Subnet)this.subnets.get(conf.getIPAddress());
                Subnet subnet = subnetCurr == null ? new Subnet(conf) : subnetCurr.clone();
                this.notifySubnetChange(subnet, isAdding);
            }
        }
        return status;
    }

    public Status addSubnet(SubnetConfig conf) {
        return this.addRemoveSubnet(conf, true);
    }

    public Status removeSubnet(SubnetConfig conf) {
        return this.addRemoveSubnet(conf, false);
    }

    public Status removeSubnet(String name) {
        if (name.equalsIgnoreCase(DEFAULT_SUBNET_NAME)) {
            return new Status(StatusCode.NOTALLOWED, "The specified subnet gateway cannot be removed");
        }
        SubnetConfig conf = (SubnetConfig)this.subnetsConfigList.get(name);
        if (conf == null) {
            return new Status(StatusCode.SUCCESS, "Subnet not present");
        }
        return this.addRemoveSubnet(conf, false);
    }

    public Status modifySubnet(SubnetConfig conf) {
        if (conf == null) {
            return new Status(StatusCode.BADREQUEST, "Invalid Subnet configuration: null");
        }
        Status status = conf.validate();
        if (!status.isSuccess()) {
            log.warn(status.getDescription());
            return status;
        }
        SubnetConfig target = (SubnetConfig)this.subnetsConfigList.get(conf.getName());
        if (target == null) {
            return this.addSubnet(conf);
        }
        if (target.equals((Object)conf)) {
            return new Status(StatusCode.SUCCESS);
        }
        if (!target.getSubnet().equals(conf.getSubnet())) {
            return new Status(StatusCode.BADREQUEST, "IP address change is not allowed");
        }
        Set toRemove = target.getNodeConnectors();
        toRemove.removeAll(conf.getNodeConnectors());
        ArrayList<String> nodeConnectorStrings = null;
        if (!toRemove.isEmpty()) {
            nodeConnectorStrings = new ArrayList<String>();
            for (NodeConnector nc : toRemove) {
                nodeConnectorStrings.add(nc.toString());
            }
            status = this.removePortsFromSubnet(conf.getName(), nodeConnectorStrings);
            if (!status.isSuccess()) {
                return status;
            }
        }
        Set toAdd = conf.getNodeConnectors();
        toAdd.removeAll(target.getNodeConnectors());
        if (!toAdd.isEmpty()) {
            ArrayList<String> nodeConnectorStringRemoved = nodeConnectorStrings;
            nodeConnectorStrings = new ArrayList();
            for (NodeConnector nc : toAdd) {
                nodeConnectorStrings.add(nc.toString());
            }
            status = this.addPortsToSubnet(conf.getName(), nodeConnectorStrings);
            if (!status.isSuccess()) {
                if (!toRemove.isEmpty()) {
                    this.addPortsToSubnet(conf.getName(), nodeConnectorStringRemoved);
                }
                return status;
            }
        }
        this.subnetsConfigList.put(conf.getName(), conf);
        return new Status(StatusCode.SUCCESS);
    }

    public Status addPortsToSubnet(String name, List<String> switchPorts) {
        if (name == null) {
            return new Status(StatusCode.BADREQUEST, "Null subnet name");
        }
        SubnetConfig confCurr = (SubnetConfig)this.subnetsConfigList.get(name);
        if (confCurr == null) {
            return new Status(StatusCode.NOTFOUND, "Subnet does not exist");
        }
        if (switchPorts == null || switchPorts.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Null or empty port set");
        }
        Subnet subCurr = (Subnet)this.subnets.get(confCurr.getIPAddress());
        if (subCurr == null) {
            log.debug("Cluster conflict: Subnet entry {} is not present in the subnets cache.", (Object)confCurr.getIPAddress());
            return new Status(StatusCode.NOTFOUND, "Subnet does not exist");
        }
        Subnet sub = subCurr.clone();
        Set sp = NodeConnector.fromString(switchPorts);
        sub.addNodeConnectors(sp);
        boolean subnetsReplaced = this.subnets.replace(confCurr.getIPAddress(), subCurr, sub);
        if (!subnetsReplaced) {
            String msg = "Cluster conflict: Conflict while adding ports to the subnet " + name;
            return new Status(StatusCode.CONFLICT, msg);
        }
        SubnetConfig conf = confCurr.clone();
        conf.addNodeConnectors(switchPorts);
        boolean configReplaced = this.subnetsConfigList.replace(name, confCurr, conf);
        if (!configReplaced) {
            String msg = "Cluster conflict: Conflict while adding ports to the subnet " + name;
            return new Status(StatusCode.CONFLICT, msg);
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removePortsFromSubnet(String name, List<String> switchPorts) {
        if (name == null) {
            return new Status(StatusCode.BADREQUEST, "Null subnet name");
        }
        SubnetConfig confCurr = (SubnetConfig)this.subnetsConfigList.get(name);
        if (confCurr == null) {
            return new Status(StatusCode.NOTFOUND, "Subnet does not exist");
        }
        if (switchPorts == null || switchPorts.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Null or empty port set");
        }
        Subnet subCurr = (Subnet)this.subnets.get(confCurr.getIPAddress());
        if (subCurr == null) {
            log.debug("Cluster conflict: Subnet entry {} is not present in the subnets cache.", (Object)confCurr.getIPAddress());
            return new Status(StatusCode.NOTFOUND, "Subnet does not exist");
        }
        Status status = SubnetConfig.validatePorts(switchPorts);
        if (!status.isSuccess()) {
            return status;
        }
        Subnet sub = subCurr.clone();
        Set sp = NodeConnector.fromString(switchPorts);
        sub.deleteNodeConnectors(sp);
        boolean subnetsReplace = this.subnets.replace(confCurr.getIPAddress(), subCurr, sub);
        if (!subnetsReplace) {
            String msg = "Cluster conflict: Conflict while removing ports from the subnet " + name;
            return new Status(StatusCode.CONFLICT, msg);
        }
        SubnetConfig conf = confCurr.clone();
        conf.removeNodeConnectors(switchPorts);
        boolean result = this.subnetsConfigList.replace(name, confCurr, conf);
        if (!result) {
            String msg = "Cluster conflict: Conflict while removing ports from " + conf;
            return new Status(StatusCode.CONFLICT, msg);
        }
        return new Status(StatusCode.SUCCESS);
    }

    public String getContainerName() {
        if (this.containerName == null) {
            return GlobalConstants.DEFAULT.toString();
        }
        return this.containerName;
    }

    public Subnet getSubnetByNetworkAddress(InetAddress networkAddress) {
        if (this.subnets.size() == 0) {
            return DEFAULT_SUBNET;
        }
        for (Map.Entry subnetEntry : this.subnets.entrySet()) {
            if (!((Subnet)subnetEntry.getValue()).isSubnetOf(networkAddress)) continue;
            return (Subnet)subnetEntry.getValue();
        }
        return null;
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    private void loadSubnetConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, SUBNETS_FILE_NAME)) {
            this.addSubnet((SubnetConfig)conf);
        }
    }

    private void loadSpanConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, SPAN_FILE_NAME)) {
            this.addSpanConfig((SpanConfig)conf);
        }
    }

    private void loadSwitchConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, SWITCH_CONFIG_FILE_NAME)) {
            this.updateNodeConfig((SwitchConfig)conf);
        }
    }

    public void updateSwitchConfig(SwitchConfig cfgObject) {
        String nodeId;
        Node node;
        Map propMapCurr;
        if (!this.isDefaultContainer) {
            return;
        }
        SwitchConfig sc = (SwitchConfig)this.nodeConfigList.get(cfgObject.getNodeId());
        if (sc == null ? this.nodeConfigList.putIfAbsent(cfgObject.getNodeId(), cfgObject) != null : !this.nodeConfigList.replace(cfgObject.getNodeId(), sc, cfgObject)) {
            return;
        }
        boolean modeChange = false;
        if (sc == null || !cfgObject.getMode().equals(sc.getMode())) {
            modeChange = true;
        }
        if ((propMapCurr = (Map)this.nodeProps.get(node = Node.fromString((String)(nodeId = cfgObject.getNodeId())))) == null) {
            return;
        }
        HashMap<String, Object> propMap = new HashMap<String, Object>(propMapCurr);
        Description desc = new Description(cfgObject.getNodeDescription());
        propMap.put(desc.getName(), desc);
        Tier tier = new Tier(Integer.parseInt(cfgObject.getTier()));
        propMap.put(tier.getName(), tier);
        if (!this.nodeProps.replace(node, propMapCurr, propMap)) {
            return;
        }
        log.trace("Set Node {}'s Mode to {}", (Object)nodeId, (Object)cfgObject.getMode());
        if (modeChange) {
            this.notifyModeChange(node, cfgObject.isProactive());
        }
    }

    public Status updateNodeConfig(SwitchConfig switchConfig) {
        Map propMapCurr;
        String advertisedDesc;
        Status status = switchConfig.validate();
        if (!status.isSuccess()) {
            return status;
        }
        Map updateProperties = switchConfig.getNodeProperties();
        ForwardingMode mode = (ForwardingMode)updateProperties.get("forwarding");
        if (mode != null) {
            if (this.isDefaultContainer) {
                if (!mode.isValid()) {
                    return new Status(StatusCode.BADREQUEST, "Invalid Forwarding Mode Value");
                }
            } else {
                return new Status(StatusCode.NOTACCEPTABLE, "Forwarding Mode modification is allowed only in default container");
            }
        }
        Description description = (Description)switchConfig.getProperty("description");
        String nodeId = switchConfig.getNodeId();
        Node node = Node.fromString((String)nodeId);
        NodeDescription nodeDesc = this.statisticsManager == null ? null : this.statisticsManager.getNodeDescription(node);
        String string = advertisedDesc = nodeDesc == null ? "" : nodeDesc.getDescription();
        if (description != null && description.getValue() != null) {
            if (description.getValue().isEmpty() || description.getValue().equals(advertisedDesc)) {
                updateProperties.remove("description");
                switchConfig = new SwitchConfig(nodeId, updateProperties);
            } else {
                for (Map.Entry entry : this.nodeProps.entrySet()) {
                    String advDesc;
                    Node n = (Node)entry.getKey();
                    Description desc = (Description)this.getNodeProp(n, "description");
                    NodeDescription nDesc = this.statisticsManager == null ? null : this.statisticsManager.getNodeDescription(n);
                    String string2 = advDesc = nDesc == null ? "" : nDesc.getDescription();
                    if (!description.equals((Object)desc) && !description.getValue().equals(advDesc) || node.equals((Object)n)) continue;
                    return new Status(StatusCode.CONFLICT, "Node name already in use");
                }
            }
        }
        boolean modeChange = false;
        SwitchConfig sc = (SwitchConfig)this.nodeConfigList.get(nodeId);
        HashMap prevNodeProperties = new HashMap();
        if (sc == null) {
            if (mode != null && mode.isProactive()) {
                modeChange = true;
            }
            if (!updateProperties.isEmpty() && this.nodeConfigList.putIfAbsent(nodeId, switchConfig) != null) {
                return new Status(StatusCode.CONFLICT, "Cluster conflict: Unable to update node configuration");
            }
        } else {
            prevNodeProperties = new HashMap(sc.getNodeProperties());
            ForwardingMode prevMode = (ForwardingMode)sc.getProperty("forwarding");
            if (mode == null) {
                if (prevMode != null && prevMode.isProactive()) {
                    modeChange = true;
                }
            } else if (prevMode != null && prevMode.getValue() != mode.getValue() || prevMode == null && mode.isProactive()) {
                modeChange = true;
            }
            if (updateProperties.isEmpty()) {
                this.nodeConfigList.remove(nodeId);
            } else if (!this.nodeConfigList.replace(nodeId, sc, switchConfig)) {
                return new Status(StatusCode.CONFLICT, "Cluster conflict: Unable to update node configuration");
            }
        }
        if ((propMapCurr = (Map)this.nodeProps.get(node)) == null) {
            return new Status(StatusCode.SUCCESS);
        }
        HashMap<String, Object> propMap = new HashMap<String, Object>(propMapCurr);
        for (Map.Entry entry : prevNodeProperties.entrySet()) {
            String prop = (String)entry.getKey();
            if (updateProperties.containsKey(prop)) continue;
            if (prop.equals("description")) {
                if (advertisedDesc.isEmpty()) continue;
                Description desc = new Description(advertisedDesc);
                propMap.put("description", desc);
                continue;
            }
            if (prop.equals("forwarding")) {
                ForwardingMode defaultMode = new ForwardingMode(0);
                propMap.put("forwarding", defaultMode);
                continue;
            }
            propMap.remove(prop);
        }
        propMap.putAll(updateProperties);
        if (!this.nodeProps.replace(node, propMapCurr, propMap)) {
            return new Status(StatusCode.CONFLICT, "Cluster conflict: Unable to update node configuration");
        }
        if (modeChange) {
            this.notifyModeChange(node, mode == null ? false : mode.isProactive());
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeNodeConfig(String nodeId) {
        if (nodeId == null || nodeId.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "nodeId cannot be empty.");
        }
        Map nodeProperties = this.getSwitchConfig(nodeId).getNodeProperties();
        Node node = Node.fromString((String)nodeId);
        Map propMapCurr = (Map)this.nodeProps.get(node);
        if (propMapCurr != null && nodeProperties != null && !nodeProperties.isEmpty()) {
            HashMap propMap = new HashMap(propMapCurr);
            for (Map.Entry entry : nodeProperties.entrySet()) {
                ConcurrentMap nodeProp;
                String prop = (String)entry.getKey();
                if (prop.equals("description") && (nodeProp = this.inventoryService.getNodeProps()).get(node) != null) {
                    propMap.put("description", ((Map)nodeProp.get(node)).get("description"));
                    continue;
                }
                propMap.remove(prop);
            }
            if (!this.nodeProps.replace(node, propMapCurr, propMap)) {
                return new Status(StatusCode.CONFLICT, "Cluster conflict: Unable to update node configuration.");
            }
        }
        if (this.nodeConfigList != null) {
            this.nodeConfigList.remove(nodeId);
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status saveSwitchConfig() {
        return this.saveSwitchConfigInternal();
    }

    public Status saveSwitchConfigInternal() {
        int number = 0;
        Status status = this.configurationService.persistConfiguration(new ArrayList(this.subnetsConfigList.values()), SUBNETS_FILE_NAME);
        if (status.isSuccess()) {
            number = (short)(number + 1);
        } else {
            log.warn("Failed to save subnet gateway configurations: " + status.getDescription());
        }
        status = this.configurationService.persistConfiguration(new ArrayList(this.spanConfigList.values()), SPAN_FILE_NAME);
        if (status.isSuccess()) {
            number = (short)(number + 1);
        } else {
            log.warn("Failed to save span port configurations: " + status.getDescription());
        }
        status = this.configurationService.persistConfiguration(new ArrayList(this.nodeConfigList.values()), SWITCH_CONFIG_FILE_NAME);
        if (status.isSuccess()) {
            number = (short)(number + 1);
        } else {
            log.warn("Failed to save node configurations: " + status.getDescription());
        }
        if (number == 0) {
            return new Status(StatusCode.INTERNALERROR, "Save failed");
        }
        if (number < 3) {
            return new Status(StatusCode.INTERNALERROR, "Partial save failure");
        }
        return status;
    }

    public List<SpanConfig> getSpanConfigList() {
        return new ArrayList<SpanConfig>(this.spanConfigList.values());
    }

    public Status addSpanConfig(SpanConfig conf) {
        if (!conf.isValidConfig()) {
            String msg = "Invalid Span configuration";
            log.warn(msg);
            return new Status(StatusCode.BADREQUEST, msg);
        }
        if (this.spanConfigList.containsKey(conf)) {
            return new Status(StatusCode.CONFLICT, "Same span config exists");
        }
        if (this.spanConfigList.putIfAbsent(conf, conf) == null) {
            this.addSpanPorts(conf.getNode(), conf.getPortArrayList());
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeSpanConfig(SpanConfig conf) {
        this.removeSpanPorts(conf.getNode(), conf.getPortArrayList());
        this.spanConfigList.remove(conf);
        return new Status(StatusCode.SUCCESS);
    }

    public List<NodeConnector> getSpanPorts(Node node) {
        ArrayList<NodeConnector> ncList = new ArrayList<NodeConnector>();
        for (NodeConnector nodeConnector : this.spanNodeConnectors) {
            if (!nodeConnector.getNode().equals((Object)node)) continue;
            ncList.add(nodeConnector);
        }
        return ncList;
    }

    private void addNode(Node node, Set<Property> props) {
        String nodeId;
        SwitchConfig conf;
        HashMap<String, Property> propMap;
        log.trace("{} added, props: {}", (Object)node, props);
        if (this.nodeProps == null) {
            return;
        }
        Map propMapCurr = (Map)this.nodeProps.get(node);
        HashMap<String, Object> hashMap = propMap = propMapCurr == null ? new HashMap<String, Property>() : new HashMap(propMapCurr);
        if (props != null) {
            for (Property prop : props) {
                propMap.put(prop.getName(), prop);
            }
        }
        boolean proactiveForwarding = false;
        if (this.nodeConfigList != null && (conf = (SwitchConfig)this.nodeConfigList.get(nodeId = node.toString())) != null && conf.getNodeProperties() != null) {
            Map nodeProperties = conf.getNodeProperties();
            propMap.putAll(nodeProperties);
            if (nodeProperties.get("forwarding") != null) {
                ForwardingMode mode = (ForwardingMode)nodeProperties.get("forwarding");
                proactiveForwarding = mode.isProactive();
            }
        }
        if (!propMap.containsKey("forwarding")) {
            ForwardingMode defaultMode = new ForwardingMode(0);
            propMap.put("forwarding", (Property)defaultMode);
        }
        boolean result = false;
        if (propMapCurr == null) {
            if (this.nodeProps.putIfAbsent(node, propMap) == null) {
                result = true;
            }
        } else {
            result = this.nodeProps.replace(node, propMapCurr, propMap);
        }
        if (!result) {
            log.debug("Cluster conflict: Conflict while adding the node properties. Node: {}  Properties: {}", node.getID(), props);
            this.addNodeProps(node, propMap);
        }
        this.addSpanPorts(node);
        this.notifyNode(node, UpdateType.ADDED, propMap);
        if (proactiveForwarding) {
            this.notifyModeChange(node, true);
        }
    }

    private void removeNode(Node node) {
        log.trace("{} removed", (Object)node);
        if (this.nodeProps == null) {
            return;
        }
        this.nodeProps.remove(node);
        this.nodeConnectorNames.remove(node);
        HashSet<NodeConnector> removeNodeConnectorSet = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.nodeConnectorProps.entrySet()) {
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            if (!nodeConnector.getNode().equals((Object)node)) continue;
            removeNodeConnectorSet.add(nodeConnector);
        }
        for (NodeConnector nc : removeNodeConnectorSet) {
            this.nodeConnectorProps.remove(nc);
        }
        this.removeSpanPorts(node);
        this.notifyNode(node, UpdateType.REMOVED, null);
    }

    private void updateNode(Node node, Set<Property> props) {
        log.trace("{} updated, props: {}", (Object)node, props);
        if (this.nodeProps == null || props == null) {
            return;
        }
        Map propMapCurr = (Map)this.nodeProps.get(node);
        HashMap<String, Property> propMap = propMapCurr == null ? new HashMap<String, Property>() : new HashMap(propMapCurr);
        String nodeId = node.toString();
        for (Property prop : props) {
            SwitchConfig conf;
            if (this.nodeConfigList != null && (conf = (SwitchConfig)this.nodeConfigList.get(nodeId)) != null && conf.getNodeProperties() != null && conf.getNodeProperties().containsKey(prop.getName())) continue;
            propMap.put(prop.getName(), prop);
        }
        if (propMapCurr == null) {
            if (this.nodeProps.putIfAbsent(node, propMap) != null) {
                log.debug("Cluster conflict: Conflict while updating the node. Node: {}  Properties: {}", node.getID(), props);
                this.addNodeProps(node, propMap);
            }
        } else if (!this.nodeProps.replace(node, propMapCurr, propMap)) {
            log.debug("Cluster conflict: Conflict while updating the node. Node: {}  Properties: {}", node.getID(), props);
            this.addNodeProps(node, propMap);
        }
        this.notifyNode(node, UpdateType.CHANGED, propMap);
    }

    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        log.debug("updateNode: {} type {} props {} for container {}", new Object[]{node, type, props, this.containerName});
        switch (type) {
            case ADDED: {
                this.addNode(node, props);
                break;
            }
            case CHANGED: {
                this.updateNode(node, props);
                break;
            }
            case REMOVED: {
                this.removeNode(node);
                break;
            }
        }
    }

    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>();
        boolean update = true;
        log.debug("updateNodeConnector: {} type {} props {} for container {}", new Object[]{nodeConnector, type, props, this.containerName});
        if (this.nodeConnectorProps == null) {
            return;
        }
        switch (type) {
            case ADDED: {
                if (props != null) {
                    for (Property prop : props) {
                        this.addNodeConnectorProp(nodeConnector, prop);
                        propMap.put(prop.getName(), prop);
                    }
                } else {
                    this.addNodeConnectorProp(nodeConnector, null);
                }
                this.addSpanPort(nodeConnector);
                break;
            }
            case CHANGED: {
                if (!this.nodeConnectorProps.containsKey(nodeConnector) || props == null) {
                    update = false;
                    break;
                }
                for (Property prop : props) {
                    this.addNodeConnectorProp(nodeConnector, prop);
                    propMap.put(prop.getName(), prop);
                }
                break;
            }
            case REMOVED: {
                if (!this.nodeConnectorProps.containsKey(nodeConnector)) {
                    update = false;
                }
                this.removeNodeConnectorAllProps(nodeConnector);
                this.removeSpanPort(nodeConnector);
                break;
            }
            default: {
                update = false;
            }
        }
        if (update) {
            this.notifyNodeConnector(nodeConnector, type, propMap);
        }
    }

    public Set<Node> getNodes() {
        return this.nodeProps != null ? new HashSet(this.nodeProps.keySet()) : new HashSet();
    }

    public Map<String, Property> getControllerProperties() {
        return new HashMap<String, Property>(this.controllerProps);
    }

    public Property getControllerProperty(String propertyName) {
        if (propertyName != null) {
            HashMap<String, Property> propertyMap = new HashMap<String, Property>(this.controllerProps);
            return propertyMap.get(propertyName);
        }
        return null;
    }

    public Status setControllerProperty(Property property) {
        if (property != null) {
            this.controllerProps.put(property.getName(), property);
            return new Status(StatusCode.SUCCESS);
        }
        return new Status(StatusCode.BADREQUEST, "Invalid property provided when setting property");
    }

    public Status removeControllerProperty(String propertyName) {
        if (propertyName != null) {
            if (this.controllerProps.containsKey(propertyName)) {
                this.controllerProps.remove(propertyName);
                if (!this.controllerProps.containsKey(propertyName)) {
                    return new Status(StatusCode.SUCCESS);
                }
            }
            String msg = "Unable to remove property " + propertyName + " from Controller";
            return new Status(StatusCode.BADREQUEST, msg);
        }
        String msg = "Invalid property provided when removing property from Controller";
        return new Status(StatusCode.BADREQUEST, msg);
    }

    public Map<String, Property> getNodeProps(Node node) {
        Map<String, Object> rv = new HashMap<String, Property>();
        if (this.nodeProps != null && (rv = (Map)this.nodeProps.get(node)) != null) {
            rv = new HashMap<String, Property>(rv);
        }
        return rv;
    }

    public Property getNodeProp(Node node, String propName) {
        Map<String, Property> propMap = this.getNodeProps(node);
        return propMap != null ? propMap.get(propName) : null;
    }

    public void setNodeProp(Node node, Property prop) {
        for (int i = 0; i <= 1; ++i) {
            Map<String, Property> propMapCurr = this.getNodeProps(node);
            if (propMapCurr == null) {
                return;
            }
            HashMap<String, Property> propMap = new HashMap<String, Property>(propMapCurr);
            propMap.put(prop.getName(), prop);
            if (!this.nodeProps.replace(node, propMapCurr, propMap)) continue;
            return;
        }
        log.warn("Cluster conflict: Unable to add property {} to node {}.", (Object)prop.getName(), node.getID());
    }

    public Status removeNodeProp(Node node, String propName) {
        for (int i = 0; i <= 1; ++i) {
            Map<String, Property> propMapCurr = this.getNodeProps(node);
            if (propMapCurr != null) {
                if (!propMapCurr.containsKey(propName)) {
                    return new Status(StatusCode.SUCCESS);
                }
                HashMap<String, Property> propMap = new HashMap<String, Property>(propMapCurr);
                propMap.remove(propName);
                if (!this.nodeProps.replace(node, propMapCurr, propMap)) continue;
                return new Status(StatusCode.SUCCESS);
            }
            return new Status(StatusCode.SUCCESS);
        }
        String msg = "Cluster conflict: Unable to remove property " + propName + " for node " + node.getID();
        return new Status(StatusCode.CONFLICT, msg);
    }

    public Status removeNodeAllProps(Node node) {
        this.nodeProps.remove(node);
        return new Status(StatusCode.SUCCESS);
    }

    public Set<NodeConnector> getUpNodeConnectors(Node node) {
        if (this.nodeConnectorProps == null) {
            return null;
        }
        HashSet<NodeConnector> nodeConnectorSet = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.nodeConnectorProps.entrySet()) {
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            if (!nodeConnector.getNode().equals((Object)node) || !this.isNodeConnectorEnabled(nodeConnector).booleanValue()) continue;
            nodeConnectorSet.add(nodeConnector);
        }
        return nodeConnectorSet;
    }

    public Set<NodeConnector> getNodeConnectors(Node node) {
        if (this.nodeConnectorProps == null) {
            return null;
        }
        HashSet<NodeConnector> nodeConnectorSet = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.nodeConnectorProps.entrySet()) {
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            if (!nodeConnector.getNode().equals((Object)node)) continue;
            nodeConnectorSet.add(nodeConnector);
        }
        return nodeConnectorSet;
    }

    public Set<NodeConnector> getPhysicalNodeConnectors(Node node) {
        if (this.nodeConnectorProps == null) {
            return null;
        }
        HashSet<NodeConnector> nodeConnectorSet = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.nodeConnectorProps.entrySet()) {
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            if (!nodeConnector.getNode().equals((Object)node) || this.isSpecial(nodeConnector)) continue;
            nodeConnectorSet.add(nodeConnector);
        }
        return nodeConnectorSet;
    }

    public Map<String, Property> getNodeConnectorProps(NodeConnector nodeConnector) {
        Map<String, Object> rv = new HashMap<String, Property>();
        if (this.nodeConnectorProps != null && (rv = (Map)this.nodeConnectorProps.get(nodeConnector)) != null) {
            rv = new HashMap<String, Property>(rv);
        }
        return rv;
    }

    public Property getNodeConnectorProp(NodeConnector nodeConnector, String propName) {
        Map<String, Property> propMap = this.getNodeConnectorProps(nodeConnector);
        return propMap != null ? propMap.get(propName) : null;
    }

    private byte[] getHardwareMAC() {
        Enumeration<NetworkInterface> nis;
        byte[] macAddress = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error("Failed to acquire controller MAC: ", (Throwable)e);
            return macAddress;
        }
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            try {
                macAddress = ni.getHardwareAddress();
            }
            catch (SocketException e) {
                log.error("Failed to acquire controller MAC: ", (Throwable)e);
            }
            if (macAddress == null) continue;
            break;
        }
        if (macAddress == null) {
            log.warn("Failed to acquire controller MAC: No physical interface found");
        }
        return macAddress;
    }

    public byte[] getControllerMAC() {
        MacAddress macProperty = (MacAddress)this.controllerProps.get("macAddress");
        return macProperty == null ? null : macProperty.getMacAddress();
    }

    public NodeConnector getNodeConnector(Node node, String nodeConnectorName) {
        if (this.nodeConnectorNames == null) {
            return null;
        }
        Map map = (Map)this.nodeConnectorNames.get(node);
        if (map == null) {
            return null;
        }
        return (NodeConnector)map.get(nodeConnectorName);
    }

    public Status addNodeConnectorProp(NodeConnector nodeConnector, Property prop) {
        Map<String, Property> propMapCurr = this.getNodeConnectorProps(nodeConnector);
        HashMap<String, Property> propMap = propMapCurr == null ? new HashMap<String, Property>() : new HashMap<String, Property>(propMapCurr);
        String msg = "Cluster conflict: Unable to add NodeConnector Property.";
        if (prop == null) {
            if (propMapCurr == null ? this.nodeConnectorProps.putIfAbsent(nodeConnector, propMap) != null : !this.nodeConnectorProps.replace(nodeConnector, propMapCurr, propMap)) {
                return new Status(StatusCode.CONFLICT, msg);
            }
            return new Status(StatusCode.SUCCESS);
        }
        propMap.put(prop.getName(), prop);
        if (propMapCurr == null ? this.nodeConnectorProps.putIfAbsent(nodeConnector, propMap) != null : !this.nodeConnectorProps.replace(nodeConnector, propMapCurr, propMap)) {
            return new Status(StatusCode.CONFLICT, msg);
        }
        if (prop.getName().equals("name") && this.nodeConnectorNames != null) {
            Node node = nodeConnector.getNode();
            Map mapCurr = (Map)this.nodeConnectorNames.get(node);
            HashMap<String, NodeConnector> map = new HashMap<String, NodeConnector>();
            if (mapCurr != null) {
                for (Map.Entry entry : mapCurr.entrySet()) {
                    String s = (String)entry.getKey();
                    try {
                        map.put(s, new NodeConnector((NodeConnector)entry.getValue()));
                    }
                    catch (ConstructionException e) {
                        log.error("An error occured", (Throwable)e);
                    }
                }
            }
            map.put(((Name)prop).getValue(), nodeConnector);
            if (mapCurr == null ? this.nodeConnectorNames.putIfAbsent(node, map) != null : !this.nodeConnectorNames.replace(node, mapCurr, map)) {
                return new Status(StatusCode.CONFLICT, msg);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeNodeConnectorProp(NodeConnector nodeConnector, String propName) {
        Node node;
        Map mapCurr;
        Name name;
        Map<String, Property> propMapCurr = this.getNodeConnectorProps(nodeConnector);
        if (propMapCurr == null) {
            return new Status(StatusCode.SUCCESS);
        }
        HashMap<String, Property> propMap = new HashMap<String, Property>(propMapCurr);
        propMap.remove(propName);
        boolean result = this.nodeConnectorProps.replace(nodeConnector, propMapCurr, propMap);
        String msg = "Cluster conflict: Unable to remove NodeConnector property.";
        if (!result) {
            return new Status(StatusCode.CONFLICT, msg);
        }
        if (propName.equals("name") && this.nodeConnectorNames != null && (name = (Name)this.getNodeConnectorProp(nodeConnector, "name")) != null && (mapCurr = (Map)this.nodeConnectorNames.get(node = nodeConnector.getNode())) != null) {
            HashMap<String, NodeConnector> map = new HashMap<String, NodeConnector>();
            for (Map.Entry entry : mapCurr.entrySet()) {
                String s = (String)entry.getKey();
                try {
                    map.put(s, new NodeConnector((NodeConnector)entry.getValue()));
                }
                catch (ConstructionException e) {
                    log.error("An error occured", (Throwable)e);
                }
            }
            map.remove(name.getValue());
            if (!this.nodeConnectorNames.replace(node, mapCurr, map)) {
                return new Status(StatusCode.CONFLICT, msg);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Status removeNodeConnectorAllProps(NodeConnector nodeConnector) {
        Node node;
        Map mapCurr;
        Name name;
        if (this.nodeConnectorNames != null && (name = (Name)this.getNodeConnectorProp(nodeConnector, "name")) != null && (mapCurr = (Map)this.nodeConnectorNames.get(node = nodeConnector.getNode())) != null) {
            HashMap<String, NodeConnector> map = new HashMap<String, NodeConnector>();
            for (Map.Entry entry : mapCurr.entrySet()) {
                String s = (String)entry.getKey();
                try {
                    map.put(s, new NodeConnector((NodeConnector)entry.getValue()));
                }
                catch (ConstructionException e) {
                    log.error("An error occured", (Throwable)e);
                }
            }
            map.remove(name.getValue());
            if (map.isEmpty()) {
                this.nodeConnectorNames.remove(node);
            } else if (!this.nodeConnectorNames.replace(node, mapCurr, map)) {
                log.warn("Cluster conflict: Unable remove Name property of nodeconnector {}, skip.", nodeConnector.getID());
            }
        }
        this.nodeConnectorProps.remove(nodeConnector);
        return new Status(StatusCode.SUCCESS);
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            log.trace("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        this.isDefaultContainer = this.containerName.equals(GlobalConstants.DEFAULT.toString());
    }

    void destroy() {
        this.shutDown();
    }

    void start() {
        this.startUp();
        this.loadSubnetConfiguration();
        this.loadSpanConfiguration();
        this.loadSwitchConfiguration();
        this.registerWithOSGIConsole();
    }

    void started() {
        this.getInventories();
    }

    void stop() {
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service set request {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service UNset request");
        this.configurationService = null;
    }

    public void setInventoryService(IInventoryService service) {
        log.trace("Got inventory service set request {}", (Object)service);
        this.inventoryService = service;
        this.getInventories();
    }

    public void unsetInventoryService(IInventoryService service) {
        log.trace("Got a service UNset request");
        this.inventoryService = null;
        this.clearInventories();
    }

    public void setStatisticsManager(IStatisticsManager statisticsManager) {
        log.trace("Got statistics manager set request {}", (Object)statisticsManager);
        this.statisticsManager = statisticsManager;
    }

    public void unsetStatisticsManager(IStatisticsManager statisticsManager) {
        log.trace("Got statistics manager UNset request");
        this.statisticsManager = null;
    }

    public void setSwitchManagerAware(ISwitchManagerAware service) {
        log.trace("Got inventory service set request {}", (Object)service);
        if (this.switchManagerAware != null) {
            this.switchManagerAware.add(service);
        }
        this.switchManagerAwareNotify(service);
    }

    public void unsetSwitchManagerAware(ISwitchManagerAware service) {
        log.trace("Got a service UNset request");
        if (this.switchManagerAware != null) {
            this.switchManagerAware.remove(service);
        }
    }

    public void setInventoryListener(IInventoryListener service) {
        log.trace("Got inventory listener set request {}", (Object)service);
        if (this.inventoryListeners != null) {
            this.inventoryListeners.add(service);
        }
        this.bulkUpdateService(service);
    }

    public void unsetInventoryListener(IInventoryListener service) {
        log.trace("Got a service UNset request");
        if (this.inventoryListeners != null) {
            this.inventoryListeners.remove(service);
        }
    }

    public void setSpanAware(ISpanAware service) {
        log.trace("Got SpanAware set request {}", (Object)service);
        if (this.spanAware != null) {
            this.spanAware.add(service);
        }
        this.spanAwareNotify(service);
    }

    public void unsetSpanAware(ISpanAware service) {
        log.trace("Got a service UNset request");
        if (this.spanAware != null) {
            this.spanAware.remove(service);
        }
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.trace("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.trace("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    private void getInventories() {
        Map propMap;
        if (this.inventoryService == null) {
            log.trace("inventory service not avaiable");
            return;
        }
        ConcurrentMap nodeProp = this.inventoryService.getNodeProps();
        for (Map.Entry entry : nodeProp.entrySet()) {
            Node node = (Node)entry.getKey();
            log.debug("getInventories: {} added for container {}", new Object[]{node, this.containerName});
            propMap = (Map)entry.getValue();
            HashSet<Property> props = new HashSet<Property>();
            for (Property property : propMap.values()) {
                props.add(property);
            }
            this.addNode(node, props);
        }
        ConcurrentMap nodeConnectorProp = this.inventoryService.getNodeConnectorProps();
        for (Map.Entry entry : nodeConnectorProp.entrySet()) {
            propMap = (Map)entry.getValue();
            for (Property property : propMap.values()) {
                this.addNodeConnectorProp((NodeConnector)entry.getKey(), property);
            }
        }
    }

    private void clearInventories() {
        this.nodeProps.clear();
        this.nodeConnectorProps.clear();
        this.nodeConnectorNames.clear();
        this.spanNodeConnectors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNode(Node node, UpdateType type, Map<String, Property> propMap) {
        Set<IInventoryListener> set = this.inventoryListeners;
        synchronized (set) {
            for (IInventoryListener service : this.inventoryListeners) {
                service.notifyNode(node, type, propMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNodeConnector(NodeConnector nodeConnector, UpdateType type, Map<String, Property> propMap) {
        Set<IInventoryListener> set = this.inventoryListeners;
        synchronized (set) {
            for (IInventoryListener service : this.inventoryListeners) {
                service.notifyNodeConnector(nodeConnector, type, propMap);
            }
        }
    }

    private void switchManagerAwareNotify(ISwitchManagerAware service) {
        for (Subnet sub : this.subnets.values()) {
            service.subnetNotify(sub, true);
        }
        for (Node node : this.getNodes()) {
            SwitchConfig sc = this.getSwitchConfig(node.toString());
            if (sc == null || !this.isDefaultContainer) continue;
            ForwardingMode mode = (ForwardingMode)sc.getProperty("forwarding");
            service.modeChangeNotify(node, mode == null ? false : mode.isProactive());
        }
    }

    private void bulkUpdateService(IInventoryListener service) {
        Map propMap;
        UpdateType type = UpdateType.ADDED;
        for (Node node : this.getNodes()) {
            propMap = (Map)this.nodeProps.get(node);
            service.notifyNode(node, type, propMap);
        }
        for (Map.Entry entry : this.nodeConnectorProps.entrySet()) {
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            propMap = (Map)this.nodeConnectorProps.get(nodeConnector);
            service.notifyNodeConnector(nodeConnector, type, propMap);
        }
    }

    private void spanAwareNotify(ISpanAware service) {
        for (Node node : this.getNodes()) {
            for (SpanConfig conf : this.getSpanConfigList(node)) {
                service.spanUpdate(node, (List)conf.getPortArrayList(), true);
            }
        }
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public Boolean isNodeConnectorEnabled(NodeConnector nodeConnector) {
        if (nodeConnector == null) {
            return false;
        }
        Config config = (Config)this.getNodeConnectorProp(nodeConnector, "config");
        State state = (State)this.getNodeConnectorProp(nodeConnector, "state");
        return config != null && config.getValue() == 1 && state != null && state.getValue() == 1;
    }

    public boolean doesNodeConnectorExist(NodeConnector nc) {
        return nc != null && this.nodeConnectorProps != null && this.nodeConnectorProps.containsKey(nc);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---Switch Manager---\n");
        help.append("\t pencs <node id>        - Print enabled node connectors for a given node\n");
        help.append("\t pdm <node id>          - Print switch ports in device map\n");
        return help.toString();
    }

    public void _pencs(CommandInterpreter ci) {
        String st = ci.nextArgument();
        if (st == null) {
            ci.println((Object)"Please enter node id");
            return;
        }
        Node node = Node.fromString((String)st);
        if (node == null) {
            ci.println((Object)"Please enter node id");
            return;
        }
        Set<NodeConnector> nodeConnectorSet = this.getUpNodeConnectors(node);
        if (nodeConnectorSet == null) {
            return;
        }
        for (NodeConnector nodeConnector : nodeConnectorSet) {
            if (nodeConnector == null) continue;
            ci.println((Object)nodeConnector);
        }
        ci.println((Object)("Total number of NodeConnectors: " + nodeConnectorSet.size()));
    }

    public void _pdm(CommandInterpreter ci) {
        String st = ci.nextArgument();
        if (st == null) {
            ci.println((Object)"Please enter node id");
            return;
        }
        Node node = Node.fromString((String)st);
        if (node == null) {
            ci.println((Object)"Please enter node id");
            return;
        }
        Switch sw = this.getSwitchByNode(node);
        ci.println((Object)"          NodeConnector                        Name");
        Set nodeConnectorSet = sw.getNodeConnectors();
        if (nodeConnectorSet != null && nodeConnectorSet.size() > 0) {
            for (NodeConnector nodeConnector : nodeConnectorSet) {
                String nodeConnectorName;
                Map<String, Property> propMap = this.getNodeConnectorProps(nodeConnector);
                String string = nodeConnectorName = propMap == null ? null : ((Name)propMap.get("name")).getValue();
                if (nodeConnectorName != null) {
                    Map map;
                    Node nd = nodeConnector.getNode();
                    if (!nd.equals((Object)node)) {
                        log.debug("node not match {} {}", (Object)nd, (Object)node);
                    }
                    if ((map = (Map)this.nodeConnectorNames.get(node)) != null) {
                        NodeConnector nc = (NodeConnector)map.get(nodeConnectorName);
                        if (nc == null) {
                            log.debug("no nodeConnector named {}", (Object)nodeConnectorName);
                        } else if (!nc.equals((Object)nodeConnector)) {
                            log.debug("nodeConnector not match {} {}", (Object)nc, (Object)nodeConnector);
                        }
                    }
                }
                ci.println((Object)(nodeConnector + "            " + (nodeConnectorName == null ? "" : nodeConnectorName) + "(" + nodeConnector.getID() + ")"));
            }
            ci.println((Object)("Total number of NodeConnectors: " + nodeConnectorSet.size()));
        }
    }

    public byte[] getNodeMAC(Node node) {
        MacAddress mac = (MacAddress)this.getNodeProp(node, "macAddress");
        return mac != null ? mac.getMacAddress() : null;
    }

    public boolean isSpecial(NodeConnector p) {
        return p.getType().equals(NodeConnector.NodeConnectorIDType.CONTROLLER) || p.getType().equals(NodeConnector.NodeConnectorIDType.ALL) || p.getType().equals(NodeConnector.NodeConnectorIDType.SWSTACK) || p.getType().equals(NodeConnector.NodeConnectorIDType.HWPATH);
    }

    private void addSpanPorts(Node node, List<NodeConnector> nodeConnectors) {
        ArrayList<NodeConnector> ncLists = new ArrayList<NodeConnector>();
        for (NodeConnector nodeConnector : nodeConnectors) {
            if (this.spanNodeConnectors.contains(nodeConnector)) continue;
            ncLists.add(nodeConnector);
        }
        if (ncLists.size() > 0) {
            this.spanNodeConnectors.addAll(ncLists);
            this.notifySpanPortChange(node, ncLists, true);
        }
    }

    private void addSpanPorts(Node node) {
        for (SpanConfig conf : this.getSpanConfigList(node)) {
            this.addSpanPorts(node, conf.getPortArrayList());
        }
    }

    private void addSpanPort(NodeConnector nodeConnector) {
        for (SpanConfig conf : this.getSpanConfigList(nodeConnector.getNode())) {
            if (!conf.getPortArrayList().contains(nodeConnector)) continue;
            ArrayList<NodeConnector> ncLists = new ArrayList<NodeConnector>();
            ncLists.add(nodeConnector);
            this.addSpanPorts(nodeConnector.getNode(), ncLists);
            return;
        }
    }

    private void removeSpanPorts(Node node, List<NodeConnector> nodeConnectors) {
        ArrayList<NodeConnector> ncLists = new ArrayList<NodeConnector>();
        for (NodeConnector nodeConnector : nodeConnectors) {
            if (!this.spanNodeConnectors.contains(nodeConnector)) continue;
            ncLists.add(nodeConnector);
        }
        if (ncLists.size() > 0) {
            this.spanNodeConnectors.removeAll(ncLists);
            this.notifySpanPortChange(node, ncLists, false);
        }
    }

    private void removeSpanPorts(Node node) {
        for (SpanConfig conf : this.getSpanConfigList(node)) {
            this.addSpanPorts(node, conf.getPortArrayList());
        }
    }

    private void removeSpanPort(NodeConnector nodeConnector) {
        if (this.spanNodeConnectors.contains(nodeConnector)) {
            ArrayList<NodeConnector> ncLists = new ArrayList<NodeConnector>();
            ncLists.add(nodeConnector);
            this.removeSpanPorts(nodeConnector.getNode(), ncLists);
        }
    }

    private void addNodeProps(Node node, Map<String, Property> propMap) {
        if (propMap == null) {
            propMap = new HashMap<String, Property>();
        }
        this.nodeProps.put(node, propMap);
    }

    public Status saveConfiguration() {
        return this.saveSwitchConfig();
    }

    public Property createProperty(String propName, String propValue) {
        if (propName == null) {
            log.debug("propName is null");
            return null;
        }
        if (propValue == null) {
            log.debug("propValue is null");
            return null;
        }
        try {
            if (propName.equalsIgnoreCase("description")) {
                return new Description(propValue);
            }
            if (propName.equalsIgnoreCase("tier")) {
                int tier = Integer.parseInt(propValue);
                return new Tier(tier);
            }
            if (propName.equalsIgnoreCase("bandwidth")) {
                long bw = Long.parseLong(propValue);
                return new Bandwidth(bw);
            }
            if (propName.equalsIgnoreCase("forwarding")) {
                int mode = Integer.parseInt(propValue);
                return new ForwardingMode(mode);
            }
            if (propName.equalsIgnoreCase("macAddress")) {
                return new MacAddress(propValue);
            }
            log.debug("Not able to create {} property", (Object)propName);
        }
        catch (Exception e) {
            log.debug("createProperty caught exception {}", (Object)e.getMessage());
        }
        return null;
    }

    public String getNodeDescription(Node node) {
        String configuredDesc;
        SwitchConfig config = this.getSwitchConfig(node.toString());
        if (config != null && (configuredDesc = config.getNodeDescription()) != null && !configuredDesc.isEmpty()) {
            return configuredDesc;
        }
        Description desc = (Description)this.getNodeProp(node, "description");
        return desc == null ? "" : desc.getValue();
    }

    public Set<Switch> getConfiguredNotConnectedSwitches() {
        HashSet<Switch> configuredNotConnectedSwitches = new HashSet<Switch>();
        if (this.inventoryService == null) {
            log.trace("inventory service not avaiable");
            return configuredNotConnectedSwitches;
        }
        Set configuredNotConnectedNodes = this.inventoryService.getConfiguredNotConnectedNodes();
        if (configuredNotConnectedNodes != null) {
            for (Node node : configuredNotConnectedNodes) {
                Switch sw = this.getSwitchByNode(node);
                configuredNotConnectedSwitches.add(sw);
            }
        }
        return configuredNotConnectedSwitches;
    }
}

