/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.switchmanager.internal;

import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.inventory.IInventoryService;
import org.opendaylight.controller.sal.inventory.IListenInventoryUpdates;
import org.opendaylight.controller.statisticsmanager.IStatisticsManager;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISpanAware;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.ISwitchManagerAware;
import org.opendaylight.controller.switchmanager.internal.SwitchManager;
import org.opendaylight.controller.switchmanager.internal.SwitchManagerCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{SwitchManager.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        if (imp.equals(SwitchManager.class)) {
            c.setInterface(new String[]{IListenInventoryUpdates.class.getName(), ISwitchManager.class.getName(), IConfigurationContainerAware.class.getName()}, null);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IInventoryService.class).setCallbacks("setInventoryService", "unsetInventoryService").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IStatisticsManager.class).setCallbacks("setStatisticsManager", "unsetStatisticsManager").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISwitchManagerAware.class).setCallbacks("setSwitchManagerAware", "unsetSwitchManagerAware").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IInventoryListener.class).setCallbacks("setInventoryListener", "unsetInventoryListener").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISpanAware.class).setCallbacks("setSpanAware", "unsetSpanAware").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IClusterContainerServices.class).setCallbacks("setClusterContainerService", "unsetClusterContainerService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IConfigurationContainerService.class).setCallbacks("setConfigurationContainerService", "unsetConfigurationContainerService").setRequired(true));
        }
    }

    protected Object[] getGlobalImplementations() {
        Object[] res = new Object[]{SwitchManagerCLI.class};
        return res;
    }
}

