/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.scheduled;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.threadpool.util.ScheduledThreadPoolWrapper;
import org.opendaylight.controller.config.yang.threadpool.impl.scheduled.AbstractScheduledThreadPoolModule;

public final class ScheduledThreadPoolModule
extends AbstractScheduledThreadPoolModule {
    public ScheduledThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public ScheduledThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, ScheduledThreadPoolModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        JmxAttributeValidationException.checkNotNull((Object)this.getMaxThreadCount(), (JmxAttribute)this.maxThreadCountJmxAttribute);
        JmxAttributeValidationException.checkCondition((this.getMaxThreadCount() > 0 ? 1 : 0) != 0, (String)"must be greater than zero", (JmxAttribute)this.maxThreadCountJmxAttribute);
    }

    @Override
    public AutoCloseable createInstance() {
        return new ScheduledThreadPoolWrapper(this.getMaxThreadCount(), this.getThreadFactoryDependency());
    }
}

