/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.scheduled;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.threadpool.ScheduledThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.scheduled.ScheduledThreadPoolModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl:scheduled", revision="2013-12-01", name="threadpool-impl-scheduled")
public abstract class AbstractScheduledThreadPoolModuleFactory
implements ModuleFactory {
    public static final String NAME = "threadpool-scheduled";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        ScheduledThreadPoolModule oldModule = null;
        try {
            oldModule = (ScheduledThreadPoolModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(old);
        }
        ScheduledThreadPoolModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setThreadFactory(oldModule.getThreadFactory());
        module.setMaxThreadCount(oldModule.getMaxThreadCount());
        return module;
    }

    public ScheduledThreadPoolModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, ScheduledThreadPoolModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new ScheduledThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public ScheduledThreadPoolModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new ScheduledThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public final String getImplementationName() {
        return NAME;
    }

    public ScheduledThreadPoolModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<ScheduledThreadPoolModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<ScheduledThreadPoolModule>();
    }

    static {
        HashSet<Class<ScheduledThreadPoolServiceInterface>> serviceIfcs2 = new HashSet<Class<ScheduledThreadPoolServiceInterface>>();
        serviceIfcs2.add(ScheduledThreadPoolServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

