/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.flexible;

import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.threadpool.util.FlexibleThreadPoolWrapper;
import org.opendaylight.controller.config.yang.threadpool.impl.flexible.AbstractFlexibleThreadPoolModule;

public final class FlexibleThreadPoolModule
extends AbstractFlexibleThreadPoolModule {
    public FlexibleThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public FlexibleThreadPoolModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, FlexibleThreadPoolModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        JmxAttributeValidationException.checkNotNull((Object)this.getKeepAliveMillis(), (JmxAttribute)this.keepAliveMillisJmxAttribute);
        JmxAttributeValidationException.checkCondition((this.getKeepAliveMillis() > 0L ? 1 : 0) != 0, (String)"must be greater than zero", (JmxAttribute)this.keepAliveMillisJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getMinThreadCount(), (JmxAttribute)this.minThreadCountJmxAttribute);
        JmxAttributeValidationException.checkCondition((this.getMinThreadCount() > 0 ? 1 : 0) != 0, (String)"must be greater than zero", (JmxAttribute)this.minThreadCountJmxAttribute);
        JmxAttributeValidationException.checkNotNull((Object)this.getMaxThreadCount(), (JmxAttribute)this.maxThreadCountJmxAttribute);
        JmxAttributeValidationException.checkCondition((this.getMaxThreadCount() > 0 ? 1 : 0) != 0, (String)"must be greater than zero", (JmxAttribute)this.maxThreadCountJmxAttribute);
    }

    @Override
    public AutoCloseable createInstance() {
        return new FlexibleThreadPoolWrapper(this.getMinThreadCount(), this.getMaxThreadCount(), this.getKeepAliveMillis(), TimeUnit.MILLISECONDS, this.getThreadFactoryDependency());
    }
}

