/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.threadpool.impl.flexible;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.threadpool.ThreadPoolServiceInterface;
import org.opendaylight.controller.config.yang.threadpool.impl.flexible.FlexibleThreadPoolModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:threadpool:impl:flexible", revision="2013-12-01", name="threadpool-impl-flexible")
public abstract class AbstractFlexibleThreadPoolModuleFactory
implements ModuleFactory {
    public static final String NAME = "threadpool-flexible";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        FlexibleThreadPoolModule oldModule = null;
        try {
            oldModule = (FlexibleThreadPoolModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(old);
        }
        FlexibleThreadPoolModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setThreadFactory(oldModule.getThreadFactory());
        module.setMinThreadCount(oldModule.getMinThreadCount());
        module.setMaxThreadCount(oldModule.getMaxThreadCount());
        module.setKeepAliveMillis(oldModule.getKeepAliveMillis());
        return module;
    }

    public FlexibleThreadPoolModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, FlexibleThreadPoolModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new FlexibleThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public FlexibleThreadPoolModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new FlexibleThreadPoolModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public final String getImplementationName() {
        return NAME;
    }

    public FlexibleThreadPoolModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<FlexibleThreadPoolModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<FlexibleThreadPoolModule>();
    }

    static {
        HashSet<Class<ThreadPoolServiceInterface>> serviceIfcs2 = new HashSet<Class<ThreadPoolServiceInterface>>();
        serviceIfcs2.add(ThreadPoolServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

